/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SafeIngredientUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<?>> CRASHING_INGREDIENT_RENDER_CLASSES = new HashSet();
    private static final Set<Class<?>> CRASHING_INGREDIENT_TOOLTIP_CLASSES = new HashSet();

    private SafeIngredientUtil() {
    }

    public static <T> List<Component> getTooltip(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient) {
        Minecraft minecraft = Minecraft.m_91087_();
        TooltipFlag.Default tooltipFlag = minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        return SafeIngredientUtil.getTooltip(ingredientManager, ingredientRenderer, typedIngredient, tooltipFlag);
    }

    public static <T> List<Component> getTooltip(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, TooltipFlag.Default tooltipFlag) {
        T ingredient = typedIngredient.getIngredient();
        Class<?> ingredientClass = ingredient.getClass();
        if (CRASHING_INGREDIENT_TOOLTIP_CLASSES.contains(ingredientClass)) {
            return SafeIngredientUtil.getErrorTooltip();
        }
        try {
            List<Component> tooltip = ingredientRenderer.getTooltip(ingredient, (TooltipFlag)tooltipFlag);
            return new ArrayList<Component>(tooltip);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_TOOLTIP_CLASSES.add(ingredientClass);
            if (SafeIngredientUtil.shouldCatchTooltipErrors()) {
                SafeIngredientUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient's tooltip", ingredientManager, typedIngredient);
                return SafeIngredientUtil.getErrorTooltip();
            }
            CrashReport crashReport = SafeIngredientUtil.createIngredientCrashReport(e, "Rendering ingredient tooltip", ingredientManager, typedIngredient);
            throw new ReportedException(crashReport);
        }
    }

    private static List<Component> getErrorTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        MutableComponent crash = Component.m_237115_((String)"jei.tooltip.error.crash");
        list.add((Component)crash.m_130940_(ChatFormatting.RED));
        return list;
    }

    public static <T> void render(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, GuiGraphics guiGraphics, ITypedIngredient<T> typedIngredient) {
        T ingredient = typedIngredient.getIngredient();
        Class<?> ingredientClass = ingredient.getClass();
        if (CRASHING_INGREDIENT_RENDER_CLASSES.contains(ingredientClass)) {
            SafeIngredientUtil.renderError(guiGraphics);
            return;
        }
        try {
            ingredientRenderer.render(guiGraphics, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_RENDER_CLASSES.add(ingredientClass);
            if (SafeIngredientUtil.shouldCatchRenderErrors()) {
                SafeIngredientUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient", ingredientManager, typedIngredient);
                SafeIngredientUtil.renderError(guiGraphics);
            }
            CrashReport crashReport = SafeIngredientUtil.createIngredientCrashReport(e, "Rendering ingredient", ingredientManager, typedIngredient);
            throw new ReportedException(crashReport);
        }
    }

    private static boolean shouldCatchRenderErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchRenderErrorsEnabled).orElse(false);
    }

    private static boolean shouldCatchTooltipErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchTooltipRenderErrorsEnabled).orElse(false);
    }

    private static void renderError(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        guiGraphics.m_280056_(font, "ERR", 0, 0, -65536, false);
        guiGraphics.m_280056_(font, "OR", 0, 8, -65536, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static <T> void logIngredientCrash(Throwable throwable, String title, IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        CrashReportCategory category = new CrashReportCategory("Ingredient");
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        SafeIngredientUtil.setIngredientCategoryDetails(category, typedIngredient, ingredientHelper);
        LOGGER.error(SafeIngredientUtil.crashReportToString(throwable, title, category));
    }

    private static <T> CrashReport createIngredientCrashReport(Throwable throwable, String title, IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)title);
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        CrashReportCategory category = crashReport.m_127514_("Ingredient");
        SafeIngredientUtil.setIngredientCategoryDetails(category, typedIngredient, ingredientHelper);
        return crashReport;
    }

    private static <T> void setIngredientCategoryDetails(CrashReportCategory category, ITypedIngredient<T> typedIngredient, IIngredientHelper<T> ingredientHelper) {
        Object ingredient = typedIngredient.getIngredient();
        IIngredientType ingredientType = typedIngredient.getType();
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        category.m_128165_("Name", () -> ingredientHelper.getDisplayName(ingredient));
        category.m_128165_("Mod's Name", () -> {
            String modId = ingredientHelper.getDisplayModId(ingredient);
            return modHelper.getModNameForModId(modId);
        });
        category.m_128165_("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
        category.m_128165_("Class Name", () -> ingredient.getClass().toString());
        category.m_128165_("toString Name", ingredient::toString);
        category.m_128165_("Unique Id for JEI (for JEI Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        category.m_128165_("Ingredient Type for JEI", () -> ingredientType.getIngredientClass().toString());
        category.m_128165_("Error Info gathered from JEI", () -> ingredientHelper.getErrorInfo(ingredient));
    }

    private static String crashReportToString(Throwable t, String title, CrashReportCategory ... categories) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(":\n\n");
        for (CrashReportCategory category : categories) {
            category.m_128168_(sb);
            sb.append("\n\n");
        }
        sb.append("-- Stack Trace --\n\n");
        sb.append(ExceptionUtils.getStackTrace((Throwable)t));
        return sb.toString();
    }
}

