/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.entity.projectile.ThrownSeedEntity;
import com.dairymoose.modernlife.core.CsvSourcedHashSet;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SeedSpreaderBlockEntity
extends BlockEntity
implements Container {
    public static final BlockEntityType<SeedSpreaderBlockEntity> SEED_SPREADER = BlockEntityType.Builder.m_155273_(SeedSpreaderBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_SEED_SPREADER.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int SEED_SPREADER_CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private TagKey<Item> seedTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "seeds"));
    final int DIAMETER = 9;
    final int VERTICAL_SPAN = 5;
    public static final double LAUNCHER_HEIGHT = 0.109375;
    public static final double LAUNCHER_HEIGHT_SAME_LEVEL = 0.75;
    public static final double LAUNCHER_RADIUS = 0.5;
    public static int RECENT_LOCATIONS_EXPIRY_MS = 5000;
    public static List<Item> extraItems = new ArrayList<Item>();
    public static CsvSourcedHashSet whitelist = null;
    public static String whitelistText = "";
    int counter = 0;
    Map<BlockPos, Long> recentLocations = new HashMap<BlockPos, Long>();
    public static final double PROJECTILE_GRAVITY = 0.03;

    public SeedSpreaderBlockEntity(BlockPos pos, BlockState state) {
        super(SEED_SPREADER, pos, state);
    }

    double freeFallTime(double h, double g) {
        return Math.sqrt(2.0 * h / g);
    }

    void launchTo(ThrownSeedEntity thrownSeed, double x, double y, double z, BlockPos pos) {
        this.recentLocations.put(pos, System.currentTimeMillis());
        double xMid = (double)pos.m_123341_() + 0.5;
        double zMid = (double)pos.m_123343_() + 0.5;
        double xDiff = xMid - x;
        double zDiff = zMid - z;
        double launchYaw = Math.atan2(zDiff, xDiff);
        double launchX = Math.cos(launchYaw) * 0.5 + x;
        double launchZ = Math.sin(launchYaw) * 0.5 + z;
        double xDiffNew = xMid - launchX;
        double zDiffNew = zMid - launchZ;
        double yDiff = y - (double)pos.m_123342_();
        double time = this.freeFallTime(yDiff, 0.03);
        double Vx = xDiffNew / (time -= 3.0);
        double Vz = zDiffNew / time;
        thrownSeed.m_6027_(launchX, y, launchZ);
        double v = Math.sqrt(Vx * Vx + Vz * Vz);
        thrownSeed.m_6686_(Vx, 0.0, Vz, (float)v, 0.0f);
    }

    public BlockPos getNextFarmland(Level world, BlockPos start, ItemStack seedStack) {
        ArrayList<BlockPos> farmlandSpots = new ArrayList<BlockPos>();
        int radius = 4;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos current = new BlockPos((Vec3i)start);
                current = current.m_122030_(x).m_122020_(z);
                BlockState state = world.m_8055_(current);
                BlockState aboveState = world.m_8055_(current.m_7494_());
                if (seedStack.m_41720_() == Items.f_42588_) {
                    if (!state.m_60713_(Blocks.f_50135_) || !aboveState.m_60795_() || this.recentLocations.containsKey(current)) continue;
                    farmlandSpots.add(current);
                    continue;
                }
                if (!state.m_60713_(Blocks.f_50093_) || !aboveState.m_60795_() || this.recentLocations.containsKey(current)) continue;
                farmlandSpots.add(current);
            }
        }
        if (farmlandSpots.size() == 0) {
            return null;
        }
        return (BlockPos)farmlandSpots.get((int)(Math.random() * (double)farmlandSpots.size()));
    }

    private void purgeRecentLocations() {
        long currentTime = System.currentTimeMillis();
        ArrayList<BlockPos> toPurge = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Long> entry : this.recentLocations.entrySet()) {
            BlockPos pos = entry.getKey();
            long time = entry.getValue();
            long timeDiff = currentTime - time;
            if (timeDiff <= (long)RECENT_LOCATIONS_EXPIRY_MS) continue;
            toPurge.add(pos);
        }
        for (BlockPos pos : toPurge) {
            this.recentLocations.remove(pos);
        }
    }

    public ItemStack getSeedFromInventory() {
        if (whitelist == null) {
            whitelist = new CsvSourcedHashSet((String)ModernLifeConfig.SERVER.seedSpreaderWhitelist.get());
        }
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            String registryNamespace = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).m_135827_();
            String registryPath = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).m_135815_();
            String fullRegistryText = registryNamespace + ":" + registryPath;
            if (!itemStack.m_204117_(this.seedTag) && !extraItems.contains(itemStack.m_41720_()) && (whitelist == null || !whitelist.contains(fullRegistryText))) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SeedSpreaderBlockEntity entity) {
        entity.tick();
    }

    public void tick() {
        ++this.counter;
        if (this.counter % 8 == 0) {
            BlockPos pos = this.m_58899_();
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.109375;
            double z = (double)pos.m_123343_() + 0.5;
            ItemStack seedStack = this.getSeedFromInventory();
            if (seedStack != ItemStack.f_41583_) {
                this.purgeRecentLocations();
                BlockPos farmlandPos = null;
                for (int yDelta = 0; yDelta < 5; ++yDelta) {
                    BlockPos toCheck = new BlockPos((Vec3i)pos);
                    farmlandPos = this.getNextFarmland(this.f_58857_, toCheck = toCheck.m_6625_(yDelta), seedStack);
                    if (farmlandPos != null) break;
                }
                if (farmlandPos != null) {
                    ThrownSeedEntity lvt_5_1_ = new ThrownSeedEntity(this.m_58904_(), x, y, z);
                    ItemStack seed = seedStack.m_41620_(1);
                    lvt_5_1_.m_37446_(seed);
                    if (farmlandPos.m_7494_().m_123342_() == pos.m_123342_()) {
                        y = (double)pos.m_123342_() + 0.75;
                    }
                    this.launchTo(lvt_5_1_, x, y, z, farmlandPos);
                    this.m_58904_().m_7967_((Entity)lvt_5_1_);
                }
            }
        }
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        super.m_142466_(p_230337_2_);
        ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.items);
    }

    protected void m_183515_(CompoundTag p_189515_1_) {
        ContainerHelper.m_18973_((CompoundTag)p_189515_1_, this.items);
    }

    public void m_6211_() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == ItemStack.f_41583_) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int var1) {
        this.m_6596_();
        return (ItemStack)this.items.get(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        this.m_6596_();
        return ContainerHelper.m_18969_(this.items, (int)var1, (int)var2);
    }

    public ItemStack m_8016_(int var1) {
        this.m_6596_();
        return ContainerHelper.m_18966_(this.items, (int)var1);
    }

    public void m_6836_(int var1, ItemStack var2) {
        this.items.set(var1, (Object)var2);
        this.m_6596_();
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    static {
        extraItems.add(Items.f_42588_);
        extraItems.add(Items.f_42620_);
        extraItems.add(Items.f_42619_);
    }
}

