/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerReceiverBlockEntity
extends BlockEntity
implements IChannelHolder {
    public static Map<Integer, Set<PowerReceiverBlockEntity>> perChannelPowerReceivers = new ConcurrentHashMap<Integer, Set<PowerReceiverBlockEntity>>();
    private int currentChannel = 0;
    public static final BlockEntityType<PowerReceiverBlockEntity> POWER_RECEIVER = BlockEntityType.Builder.m_155273_(PowerReceiverBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_POWER_RECEIVER.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();

    public String toString() {
        return "(channel=" + this.getCurrentChannel() + ", pos=" + this.m_58899_() + ")";
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("channel", this.currentChannel);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag.m_128441_("channel")) {
            this.currentChannel = tag.m_128451_("channel");
        }
        super.handleUpdateTag(tag);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("channel", this.currentChannel);
        ModernLifeCommon.LOGGER.debug("save with channel=" + this.currentChannel + " at pos=" + this.m_58899_());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("channel")) {
            this.currentChannel = nbt.m_128451_("channel");
            this.addToChannel(this.currentChannel);
        }
        ModernLifeCommon.LOGGER.debug("load with channel=" + this.currentChannel);
    }

    public boolean equals(Object other) {
        if (other instanceof PowerReceiverBlockEntity) {
            PowerReceiverBlockEntity otherTransmitter = (PowerReceiverBlockEntity)other;
            return this.m_58899_().equals((Object)otherTransmitter.m_58899_());
        }
        return false;
    }

    public int hashCode() {
        return this.m_58899_().hashCode();
    }

    public void addToChannel(int channel) {
        ModernLifeCommon.LOGGER.debug("adding receiver at " + this.m_58899_() + " with channel: " + this.currentChannel);
        Set<PowerReceiverBlockEntity> entities = perChannelPowerReceivers.get(channel);
        if (entities == null) {
            entities = new HashSet<PowerReceiverBlockEntity>();
            perChannelPowerReceivers.put(channel, entities);
        }
        entities.add(this);
        ModernLifeCommon.LOGGER.debug("receiver count = " + perChannelPowerReceivers.size());
    }

    public void removeFromChannel(int channel) {
        ModernLifeCommon.LOGGER.debug("removing receiver at " + this.m_58899_() + " with channel: " + this.currentChannel);
        Set<PowerReceiverBlockEntity> entities = perChannelPowerReceivers.get(channel);
        if (entities == null) {
            entities = new HashSet<PowerReceiverBlockEntity>();
            perChannelPowerReceivers.put(channel, entities);
        }
        entities.remove(this);
        ModernLifeCommon.LOGGER.debug("receiver count = " + perChannelPowerReceivers.size());
    }

    public PowerReceiverBlockEntity(BlockPos pos, BlockState state) {
        super(POWER_RECEIVER, pos, state);
        ModernLifeCommon.LOGGER.debug("PowerReceiverBlockEntity CONSTRUCTOR");
    }

    @Override
    public int getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public void setCurrentChannel(int newChannel) {
        this.m_6596_();
        this.removeFromChannel(this.currentChannel);
        this.currentChannel = newChannel;
        this.addToChannel(newChannel);
        ModernLifeCommon.LOGGER.debug("updating channel with world=" + this.m_58904_());
        this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
    }
}

