/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhotocopierBlockEntity
extends BlockEntity
implements Container {
    public static final BlockEntityType<PhotocopierBlockEntity> PHOTOCOPIER = BlockEntityType.Builder.m_155273_(PhotocopierBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_PHOTOCOPIER.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int PHOTOCOPIER_CONTAINER_SIZE = 27;
    private Queue<RequestQueueItem> copyRequestQueue = new ConcurrentLinkedQueue<RequestQueueItem>();
    private int counter = 0;
    private int copyProgress = -1;
    private static final int PAPER_PER_CANVAS = 1;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);

    public void addTaskToQueue(long uniqueId, CompoundTag nbt, int copies) {
        if (this.copyRequestQueue != null) {
            for (int i = 0; i < copies; ++i) {
                RequestQueueItem rqi = new RequestQueueItem();
                rqi.uniqueId = uniqueId;
                rqi.nbt = nbt;
                this.copyRequestQueue.add(rqi);
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PhotocopierBlockEntity entity) {
        entity.tick();
    }

    public void tick() {
        ++this.counter;
        if (this.counter % 5 == 0 && !this.copyRequestQueue.isEmpty()) {
            if (this.copyProgress == -1) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.BLOCKS, 0.25f, 0.5f);
                this.copyProgress = 4;
            } else if (this.copyProgress > 0) {
                --this.copyProgress;
            } else if (this.copyProgress == 0) {
                this.copyProgress = -1;
                int freeSlot = this.getFirstFreeSlot();
                int paperSlot = this.getFirstValidPaperSlot();
                if (freeSlot != -1 && paperSlot != -1) {
                    this.m_8020_(paperSlot).m_41774_(1);
                    RequestQueueItem rqi = this.copyRequestQueue.remove();
                    if (rqi != null) {
                        Long uniqueId = rqi.uniqueId;
                        CompoundTag nbt = rqi.nbt;
                        if (uniqueId != null) {
                            long newUniqueId = uniqueId;
                            Boolean bProductNewImage = (Boolean)ModernLifeConfig.SERVER.photocopierProducesNewImageFiles.get();
                            if (bProductNewImage != null && bProductNewImage.booleanValue()) {
                                newUniqueId = ServerboundMultipartCameraPacket.copyPng(uniqueId);
                            }
                            if (newUniqueId != -1L) {
                                ItemStack itemStack = new ItemStack((ItemLike)CustomBlocks.BLOCK_CANVAS.get());
                                if (nbt == null) {
                                    nbt = new CompoundTag();
                                }
                                itemStack.m_41751_(nbt);
                                itemStack.m_41783_().m_128356_("UniqueId", newUniqueId);
                                this.m_6836_(freeSlot, itemStack);
                                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12176_, SoundSource.BLOCKS, 0.25f, 0.5f);
                            }
                        }
                    }
                } else {
                    BlockPos pos = this.m_58899_();
                    List players = this.f_58857_.m_45976_(Player.class, AABB.m_165882_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (double)10.0, (double)10.0, (double)10.0));
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11794_, SoundSource.BLOCKS, 0.25f, 0.5f);
                    if (players != null && !players.isEmpty()) {
                        for (Player p : players) {
                            if (freeSlot == -1) {
                                p.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Photocopier inventory is full!  All pending jobs cancelled")));
                                continue;
                            }
                            if (paperSlot != -1) continue;
                            p.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Photocopier requires at least 1 paper in its inventory to copy!  All pending jobs cancelled")));
                        }
                    }
                    this.copyRequestQueue.clear();
                }
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public PhotocopierBlockEntity(BlockPos pos, BlockState state) {
        super(PHOTOCOPIER, pos, state);
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        super.m_142466_(p_230337_2_);
        ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.items);
    }

    protected void m_183515_(CompoundTag p_189515_1_) {
        ContainerHelper.m_18973_((CompoundTag)p_189515_1_, this.items);
    }

    public void m_6211_() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public int m_6643_() {
        return 27;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int freeSlotCount() {
        int freeSlots = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            ++freeSlots;
        }
        return freeSlots;
    }

    public int getFirstFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public int getFirstValidPaperSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_150930_(Items.f_42516_) || ((ItemStack)this.items.get(i)).m_41613_() < 1) continue;
            return i;
        }
        return -1;
    }

    public ItemStack m_8020_(int var1) {
        return (ItemStack)this.items.get(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return ContainerHelper.m_18969_(this.items, (int)var1, (int)var2);
    }

    public ItemStack m_8016_(int var1) {
        return ContainerHelper.m_18966_(this.items, (int)var1);
    }

    public void m_6836_(int var1, ItemStack var2) {
        this.items.set(var1, (Object)var2);
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public static class RequestQueueItem {
        Long uniqueId;
        CompoundTag nbt;
    }
}

