/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.network.play.client.ClientboundMultipartCanvasPacket;
import com.dairymoose.modernlife.network.play.client.ICanvasReader;
import com.dairymoose.modernlife.util.CanvasData;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CanvasBlockEntity
extends BlockEntity
implements Container,
ICanvasReader {
    public static final BlockEntityType<CanvasBlockEntity> CANVAS = BlockEntityType.Builder.m_155273_(CanvasBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_CANVAS.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int CANVAS_CONTAINER_SIZE = 1;
    public float blockWidth = 0.0f;
    public float blockHeight = 0.0f;
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    private Object nbtLock = new Object();
    private NonNullList<ItemStack> canvasStack = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    CanvasData canvasData = new CanvasData();
    private DynamicTexture texture = null;
    private RenderType dynamicRenderType;
    @OnlyIn(value=Dist.CLIENT)
    private TextureManager textureManager;
    private static ExecutorService canvasUpdateThreadpool = Executors.newCachedThreadPool();
    public boolean asyncUpdateInProgress = false;

    public CanvasBlockEntity(BlockPos pos, BlockState state) {
        super(CANVAS, pos, state);
        ClientboundMultipartCanvasPacket.subscribe(this);
    }

    @Override
    public void onUpdate(long uniqueId) {
        long thisUniqueId;
        CompoundTag nbt;
        if (this.m_58901_()) {
            ClientboundMultipartCanvasPacket.unsubscribe(this);
            return;
        }
        if (!this.m_7983_() && this.m_8020_(0).m_41720_() == CustomBlocks.ITEM_CANVAS.get() && (nbt = this.m_8020_(0).m_41783_()).m_128441_("UniqueId") && (thisUniqueId = nbt.m_128454_("UniqueId")) == uniqueId) {
            this.updateToNewTexture();
        }
    }

    public AABB getRenderBoundingBox() {
        BlockPos blockPos = this.m_58899_();
        Vec3 loc = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
        return AABB.m_165882_((Vec3)loc, (double)10.0, (double)10.0, (double)10.0);
    }

    private void updateToNewTexture() {
        final CanvasBlockEntity thisEntity = this;
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

            @Override
            public void run() {
                canvasUpdateThreadpool.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (!thisEntity.asyncUpdateInProgress && !thisEntity.m_7983_() && thisEntity.m_8020_(0).m_41720_() == CustomBlocks.ITEM_CANVAS.get()) {
                            thisEntity.asyncUpdateInProgress = true;
                            CompoundTag nbt = thisEntity.m_8020_(0).m_41783_();
                            if (nbt != null && nbt.m_128441_("UniqueId")) {
                                long uniqueId = nbt.m_128454_("UniqueId");
                                ModernLifeCommon.LOGGER.debug("updating texture for ID=" + uniqueId + " at pos = " + thisEntity.m_58899_());
                                if (CanvasBlockEntity.this.texture != null) {
                                    CanvasBlockEntity.this.texture.close();
                                }
                                CanvasBlockEntity.this.texture = null;
                                byte[] compressed = ModernLifeClient.getCanvasData(uniqueId);
                                if (compressed != null) {
                                    int texWidth = ModernLifeClient.getCanvasWidth(uniqueId);
                                    int texHeight = ModernLifeClient.getCanvasHeight(uniqueId);
                                    if (texWidth > 0 && texHeight > 0) {
                                        CanvasBlockEntity.this.canvasData.disable();
                                        CanvasBlockEntity.this.canvasData.setTextureSize(texWidth, texHeight);
                                        CanvasBlockEntity.this.canvasData.fromCompressedNbt(compressed);
                                        CanvasBlockEntity.this.canvasData.reenable();
                                        try {
                                            if (nbt.m_128441_("BlockWidth")) {
                                                thisEntity.blockWidth = nbt.m_128457_("BlockWidth");
                                            }
                                            if (nbt.m_128441_("BlockHeight")) {
                                                thisEntity.blockHeight = nbt.m_128457_("BlockHeight");
                                            }
                                            if (nbt.m_128441_("xOffset")) {
                                                thisEntity.xOffset = nbt.m_128457_("xOffset");
                                            }
                                            if (nbt.m_128441_("yOffset")) {
                                                thisEntity.yOffset = nbt.m_128457_("yOffset");
                                            }
                                        }
                                        catch (Exception ex) {
                                            ModernLifeCommon.LOGGER.warn("Error during async nbt update", (Throwable)ex);
                                        }
                                    }
                                }
                            }
                        }
                        thisEntity.asyncUpdateInProgress = false;
                    }
                });
            }
        });
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.m_7983_() || this.m_8020_(0).m_41720_() == CustomBlocks.ITEM_CANVAS.get()) {
            // empty if block
        }
        ContainerHelper.m_18973_((CompoundTag)nbt, this.canvasStack);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        ContainerHelper.m_18980_((CompoundTag)tag, this.canvasStack);
        ItemStack item = this.m_8020_(0);
        CompoundTag nbt = null;
        if (item != null) {
            nbt = item.m_41783_();
        }
        if (!this.m_7983_() && item != null && item.m_41720_() == CustomBlocks.ITEM_CANVAS.get() && nbt != null && nbt.m_128441_("UniqueId")) {
            long l = this.m_8020_(0).m_41783_().m_128454_("UniqueId");
        }
        this.updateToNewTexture();
        super.handleUpdateTag(tag);
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        super.m_142466_(p_230337_2_);
        ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.canvasStack);
        ItemStack item = this.m_8020_(0);
        if (!item.m_41619_() && item.m_41782_()) {
            this.updateToNewTexture();
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection conn, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.canvasStack);
            ItemStack item = this.m_8020_(0);
            if (!item.m_41619_() && item.m_41782_()) {
                this.updateToNewTexture();
            }
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.canvasStack);
    }

    public void m_6211_() {
        this.canvasStack.set(0, (Object)ItemStack.f_41583_);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.canvasStack.get(0)).m_41619_();
    }

    public ItemStack m_8020_(int var1) {
        return (ItemStack)this.canvasStack.get(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return ContainerHelper.m_18969_(this.canvasStack, (int)var1, (int)var2);
    }

    public ItemStack m_8016_(int var1) {
        return ContainerHelper.m_18966_(this.canvasStack, (int)var1);
    }

    public void m_6836_(int var1, ItemStack item) {
        this.canvasStack.set(var1, (Object)item);
        if (item.m_41720_() != CustomBlocks.ITEM_CANVAS.get() || item.m_41782_()) {
            // empty if block
        }
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public RenderType getDynamicRenderType() {
        return this.dynamicRenderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canInitImage() {
        return this.canvasData.isValid();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initImage() {
        if (this.textureManager == null) {
            this.textureManager = Minecraft.m_91087_().m_91097_();
        }
        this.canvasData.initImage();
        if (this.m_58904_() instanceof ClientLevel && this.texture == null && this.canvasData.isValid()) {
            this.texture = new DynamicTexture(this.canvasData.textureWidth(), this.canvasData.textureHeight(), true);
            ResourceLocation resourcelocation = this.textureManager.m_118490_("artpad/dyn", this.texture);
            this.dynamicRenderType = RenderType.m_110497_((ResourceLocation)resourcelocation);
            this.updateTexture();
        }
    }

    private void updateTexture() {
        if (!this.canvasData.isValid()) {
            return;
        }
        if (this.m_58904_() instanceof ClientLevel) {
            for (int i = 0; i < this.canvasData.textureHeight(); ++i) {
                for (int j = 0; j < this.canvasData.textureWidth(); ++j) {
                    int k = j + i * this.canvasData.textureWidth();
                    if (this.texture == null || this.texture.m_117991_() == null || !this.canvasData.isValid()) continue;
                    try {
                        this.texture.m_117991_().m_84988_(j, i, this.canvasData.getAbgrOutputPixel(j, i));
                        continue;
                    }
                    catch (IllegalStateException e) {
                        ModernLifeCommon.LOGGER.warn("Unallocated image error");
                    }
                }
            }
            try {
                if (this.texture != null && this.canvasData.isValid()) {
                    this.texture.m_117985_();
                }
            }
            catch (IllegalStateException e) {
                ModernLifeCommon.LOGGER.warn("Unallocated image error");
            }
        }
        if (this.m_58904_() instanceof ServerLevel) {
            this.m_58904_().markAndNotifyBlock(this.m_58899_(), this.m_58904_().m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 2, 0);
        }
    }
}

