/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.WinchBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.WinchBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WinchBlockEntityRenderer
implements BlockEntityRenderer<WinchBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private int tickCount = 0;

    public WinchBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public boolean shouldRenderOffScreen(WinchBlockEntity winchBlockEntity) {
        return true;
    }

    public boolean shouldRender(WinchBlockEntity winchBlockEntity, Vec3 vec3) {
        return true;
    }

    public void render(WinchBlockEntity blockEntity, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int lightmap, int overlay) {
        BlockPos pos = blockEntity.m_58899_();
        pos = WinchBlockEntity.moveAwayFromWinch(blockEntity.m_58900_(), pos);
        BlockState posState = blockEntity.m_58904_().m_8055_(pos);
        if (blockEntity.isValidCeilingChain(posState) || posState.m_60713_((Block)CustomBlocks.BLOCK_WINCH_ANCHOR.get()) && (blockEntity.m_58900_().m_61143_((Property)WinchBlock.f_53179_) == AttachFace.CEILING || blockEntity.m_58900_().m_61143_((Property)WinchBlock.f_53179_) == AttachFace.FLOOR)) {
            Minecraft.m_91087_().m_91289_().m_110912_((BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)Direction.Axis.Y), matrixStack, iRenderTypeBuffer, lightmap, overlay);
        } else if (blockEntity.isValidXChain(posState)) {
            Minecraft.m_91087_().m_91289_().m_110912_((BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)Direction.Axis.X), matrixStack, iRenderTypeBuffer, lightmap, overlay);
        } else if (blockEntity.isValidZChain(posState)) {
            Minecraft.m_91087_().m_91289_().m_110912_((BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)Direction.Axis.Z), matrixStack, iRenderTypeBuffer, lightmap, overlay);
        }
    }
}

