/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.CanvasBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.network.play.client.ServerboundPrintSizePacket;
import com.dairymoose.modernlife.tileentities.CanvasBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class CanvasBlockEntityRenderer
implements BlockEntityRenderer<CanvasBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CanvasBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public boolean shouldRenderOffScreen(CanvasBlockEntity p_112306_) {
        return false;
    }

    public boolean isSane(float blockWidth, float blockHeight, float xOffset, float yOffset) {
        float before = 0.0f;
        float after = 0.0f;
        before = blockWidth;
        after = ServerboundPrintSizePacket.sanitizeWidthHeight(before);
        if (before != after) {
            return false;
        }
        before = blockHeight;
        after = ServerboundPrintSizePacket.sanitizeWidthHeight(before);
        if (before != after) {
            return false;
        }
        before = xOffset;
        after = ServerboundPrintSizePacket.sanitizeOffset(before);
        if (before != after) {
            return false;
        }
        before = yOffset;
        after = ServerboundPrintSizePacket.sanitizeOffset(before);
        return before == after;
    }

    public void render(CanvasBlockEntity tileEntity, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int lightmap, int i1) {
        int canvasSize = (Integer)tileEntity.m_58900_().m_61143_((Property)CanvasBlock.SIZE);
        Direction facing = (Direction)tileEntity.m_58900_().m_61143_((Property)CanvasBlock.FACING);
        boolean saneCustomCanvas = false;
        if (canvasSize == 0) {
            saneCustomCanvas = this.isSane(tileEntity.blockWidth, tileEntity.blockHeight, tileEntity.xOffset, tileEntity.yOffset);
            if (saneCustomCanvas) {
                matrixStack.m_85836_();
                if (facing == Direction.EAST) {
                    matrixStack.m_85837_(0.5, 0.5, 0.5);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                    matrixStack.m_85837_(-0.5, -0.5, -0.5);
                } else if (facing == Direction.SOUTH) {
                    matrixStack.m_85837_(0.5, 0.5, 0.5);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    matrixStack.m_85837_(-0.5, -0.5, -0.5);
                } else if (facing == Direction.WEST) {
                    matrixStack.m_85837_(0.5, 0.5, 0.5);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    matrixStack.m_85837_(-0.5, -0.5, -0.5);
                }
                matrixStack.m_252880_(-tileEntity.xOffset, tileEntity.yOffset, 0.0f);
                float xDiff = tileEntity.blockWidth - 1.0f;
                float yDiff = tileEntity.blockHeight - 1.0f;
                matrixStack.m_85837_((double)(-xDiff / 2.0f), (double)(-yDiff / 2.0f), 0.0);
                matrixStack.m_85841_(tileEntity.blockWidth, tileEntity.blockHeight, 1.0f);
            }
            Minecraft.m_91087_().m_91289_().m_110912_((BlockState)((BlockState)((Block)CustomBlocks.BLOCK_FACELESS_CANVAS.get()).m_49966_().m_61124_((Property)CanvasBlock.SIZE, (Comparable)Integer.valueOf(1))).m_61124_((Property)CanvasBlock.FACING, (Comparable)Direction.NORTH), matrixStack, iRenderTypeBuffer, lightmap, i1);
            if (saneCustomCanvas) {
                matrixStack.m_85849_();
            }
        }
        switch (facing) {
            case EAST: {
                if (Minecraft.m_91087_().f_91074_.m_20183_().m_123341_() >= tileEntity.m_58899_().m_123341_()) break;
                return;
            }
            case WEST: {
                if (Minecraft.m_91087_().f_91074_.m_20183_().m_123341_() <= tileEntity.m_58899_().m_123341_()) break;
                return;
            }
            case NORTH: {
                if (Minecraft.m_91087_().f_91074_.m_20183_().m_123343_() <= tileEntity.m_58899_().m_123343_()) break;
                return;
            }
            case SOUTH: {
                if (Minecraft.m_91087_().f_91074_.m_20183_().m_123343_() >= tileEntity.m_58899_().m_123343_()) break;
                return;
            }
        }
        if (tileEntity.canInitImage() && !tileEntity.asyncUpdateInProgress) {
            tileEntity.initImage();
        }
        matrixStack.m_85836_();
        switch ((Direction)tileEntity.m_58900_().m_61143_((Property)CanvasBlock.FACING)) {
            case EAST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case WEST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, 1.0f);
                break;
            }
            case NORTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
                break;
            }
            case SOUTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, 0.0f);
            }
        }
        matrixStack.m_252880_(0.0f, 0.0f, -0.095f);
        RenderType renderType = tileEntity.getDynamicRenderType();
        if (renderType != null) {
            VertexConsumer dynamicBuilder = iRenderTypeBuffer.m_6299_(tileEntity.getDynamicRenderType());
            float mod = 0.0f;
            float topMod = 0.0f;
            float modWidth = 0.0f;
            float modHeight = 0.0f;
            if (canvasSize == 0) {
                if (saneCustomCanvas) {
                    float sizeW = (tileEntity.blockWidth - 1.0f) / 2.0f;
                    float sizeH = (tileEntity.blockHeight - 1.0f) / 2.0f;
                    matrixStack.m_252880_(-tileEntity.xOffset, tileEntity.yOffset, 0.0f);
                    matrixStack.m_85837_(0.0, (double)(-sizeH), 0.0);
                    modWidth = sizeW;
                    modHeight = sizeH;
                    topMod = sizeH;
                } else {
                    canvasSize = 1;
                }
            }
            if (canvasSize == 4) {
                mod = 1.0f;
            } else if (canvasSize == 3) {
                mod = 0.5f;
            } else if (canvasSize == 2) {
                mod = 0.25f;
            } else if (canvasSize == 5) {
                matrixStack.m_85837_(0.0, -0.3125, 0.0);
                topMod = mod = 0.3125f;
            } else if (canvasSize == 6) {
                matrixStack.m_85837_(0.0, -0.625, 0.0);
                topMod = mod = 0.625f;
            } else if (canvasSize == 7) {
                matrixStack.m_85837_(0.0, -1.0, 0.0);
                topMod = mod = 1.0f;
            }
            if (canvasSize != 0) {
                modWidth = mod;
                modHeight = mod;
            }
            Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
            dynamicBuilder.m_252986_(matrix4f, 0.0f - modWidth, 1.0f + modHeight + topMod, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(lightmap).m_5752_();
            dynamicBuilder.m_252986_(matrix4f, 1.0f + modWidth, 1.0f + modHeight + topMod, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(lightmap).m_5752_();
            dynamicBuilder.m_252986_(matrix4f, 1.0f + modWidth, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(lightmap).m_5752_();
            dynamicBuilder.m_252986_(matrix4f, 0.0f - modWidth, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(lightmap).m_5752_();
        }
        matrixStack.m_85849_();
    }
}

