/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import com.dairymoose.modernlife.tileentities.PowerReceiverBlockEntity;
import com.dairymoose.modernlife.tileentities.PowerTransmitterBlockEntity;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundWirelessChannelPacket
implements Packet<ServerGamePacketListener> {
    private int newChannel;
    private BlockPos wirelessBlockPos;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundWirelessChannelPacket() {
    }

    public ServerboundWirelessChannelPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundWirelessChannelPacket(int newChannel, BlockPos wirelessBlockPos) {
        this.newChannel = newChannel;
        this.wirelessBlockPos = wirelessBlockPos;
    }

    public void read(FriendlyByteBuf p_148837_1_) {
        this.newChannel = p_148837_1_.readInt();
        this.wirelessBlockPos = p_148837_1_.m_130135_();
    }

    public void m_5779_(FriendlyByteBuf p_148840_1_) {
        p_148840_1_.writeInt(this.newChannel);
        p_148840_1_.m_130064_(this.wirelessBlockPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public static <T extends BlockEntity> void purgeRemovedChannelHolders(Set<T> data) {
        if (data == null) {
            return;
        }
        ArrayList<BlockEntity> toRemove = new ArrayList<BlockEntity>();
        for (BlockEntity tileEntity : data) {
            if (!tileEntity.m_58898_() || tileEntity.m_58904_().m_46749_(tileEntity.m_58899_())) continue;
            toRemove.add(tileEntity);
        }
        for (BlockEntity t : toRemove) {
            ModernLifeCommon.LOGGER.debug("Purge entity: " + t);
            data.remove(t);
        }
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundWirelessChannelPacket");
        if (this.wirelessBlockPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            CompoundTag nbt = new CompoundTag();
            Level world = serverHandler.f_9743_.m_9236_();
            ModernLifeCommon.LOGGER.debug("world = " + world);
            if (world != null && world.m_46749_(this.wirelessBlockPos)) {
                BlockState wirelessBlockState = world.m_8055_(this.wirelessBlockPos);
                ModernLifeCommon.LOGGER.debug("wirelessBlockState = " + wirelessBlockState);
                if (wirelessBlockState != null && (wirelessBlockState.m_60713_((Block)CustomBlocks.BLOCK_POWER_TRANSMITTER.get()) || wirelessBlockState.m_60713_((Block)CustomBlocks.BLOCK_POWER_RECEIVER.get())) && this.newChannel >= 0 && this.newChannel <= 9999) {
                    IChannelHolder iChannelHolder;
                    ModernLifeCommon.LOGGER.debug("wirelessBlockPos = " + this.wirelessBlockPos);
                    BlockEntity tileEntity = world.m_46745_(this.wirelessBlockPos).m_7702_(this.wirelessBlockPos);
                    ModernLifeCommon.LOGGER.debug("tileEntity = " + tileEntity);
                    if (tileEntity instanceof IChannelHolder && (iChannelHolder = (IChannelHolder)tileEntity) != null) {
                        iChannelHolder.setCurrentChannel(this.newChannel);
                        Set<PowerTransmitterBlockEntity> transmitters = PowerTransmitterBlockEntity.perChannelPowerTransmitters.get(this.newChannel);
                        int transmitterCount = 0;
                        if (transmitters != null) {
                            ServerboundWirelessChannelPacket.purgeRemovedChannelHolders(transmitters);
                            transmitterCount = transmitters.size();
                        }
                        Set<PowerReceiverBlockEntity> receivers = PowerReceiverBlockEntity.perChannelPowerReceivers.get(this.newChannel);
                        int receiverCount = 0;
                        if (receivers != null) {
                            ServerboundWirelessChannelPacket.purgeRemovedChannelHolders(receivers);
                            receiverCount = receivers.size();
                        }
                        String outputText = "Channel " + this.newChannel + " now has " + transmitterCount + " transmitters and " + receiverCount + " receivers";
                        serverHandler.f_9743_.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(outputText)));
                        if (transmitters != null) {
                            for (PowerTransmitterBlockEntity transmitterNow : transmitters) {
                                String trans = "t=" + transmitterNow;
                                ModernLifeCommon.LOGGER.debug(trans);
                            }
                        }
                        if (receivers != null) {
                            for (PowerReceiverBlockEntity receiverNow : receivers) {
                                String recv = "r=" + receiverNow;
                                ModernLifeCommon.LOGGER.debug(recv);
                            }
                        }
                    }
                }
            }
        }
    }
}

