/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.RadiatorBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.RadiatorBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundRadiatorPacket
implements Packet<ServerGamePacketListener> {
    private RadiatorBlock.HeatType heatType;
    private BlockPos radiatorPos;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundRadiatorPacket() {
    }

    public ServerboundRadiatorPacket(RadiatorBlock.HeatType heatType, BlockPos easelPos) {
        this.heatType = heatType;
        this.radiatorPos = easelPos;
    }

    public ServerboundRadiatorPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.heatType = (RadiatorBlock.HeatType)buffer.m_130066_(RadiatorBlock.HeatType.class);
        this.radiatorPos = buffer.m_130135_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.heatType);
        buffer.m_130064_(this.radiatorPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundRadiatorPacket");
        if (this.radiatorPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            RadiatorBlockEntity radiatorBlockEntity;
            BlockEntity tileEntity;
            BlockState radiatorState;
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            CompoundTag nbt = new CompoundTag();
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            if (world != null && world.m_46749_(this.radiatorPos) && (radiatorState = world.m_8055_(this.radiatorPos)) != null && radiatorState.m_60713_((Block)CustomBlocks.BLOCK_RADIATOR.get()) && (tileEntity = world.m_46745_(this.radiatorPos).m_7702_(this.radiatorPos)) instanceof RadiatorBlockEntity && (radiatorBlockEntity = (RadiatorBlockEntity)tileEntity) != null) {
                world.m_46597_(this.radiatorPos, (BlockState)radiatorState.m_61124_(RadiatorBlock.HEAT, (Comparable)((Object)this.heatType)));
            }
        }
    }
}

