/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.CanvasBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.PrinterBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundPrintSizePacket
implements Packet<ServerGamePacketListener> {
    private static final Logger LOGGER = LogManager.getLogger();
    private int printSize = -1;
    private float blockWidth = 0.0f;
    private float blockHeight = 0.0f;
    private float xOffset = 0.0f;
    private float yOffset = 0.0f;
    private BlockPos pos;

    public ServerboundPrintSizePacket() {
    }

    public ServerboundPrintSizePacket(int printSize, BlockPos pos) {
        this.printSize = printSize;
        this.pos = pos;
    }

    public ServerboundPrintSizePacket(float blockWidth, float blockHeight, float xOffset, float yOffset, BlockPos pos) {
        this.printSize = 0;
        this.blockWidth = blockWidth;
        this.blockHeight = blockHeight;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.pos = pos;
    }

    public ServerboundPrintSizePacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.printSize = buffer.readInt();
        this.blockWidth = buffer.readFloat();
        this.blockHeight = buffer.readFloat();
        this.xOffset = buffer.readFloat();
        this.yOffset = buffer.readFloat();
        this.pos = buffer.m_130135_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.printSize);
        buffer.writeFloat(this.blockWidth);
        buffer.writeFloat(this.blockHeight);
        buffer.writeFloat(this.xOffset);
        buffer.writeFloat(this.yOffset);
        buffer.m_130064_(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public static float sanitizeWidthHeight(float input) {
        if (input <= 1.0f) {
            input = 1.0f;
        }
        if (input > 10.0f) {
            input = 10.0f;
        }
        return input;
    }

    public static float sanitizeOffset(float input) {
        if (input < -1.0f) {
            input = -1.0f;
        }
        if (input > 1.0f) {
            input = 1.0f;
        }
        return input;
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundPrintSizePacket");
        if (this.printSize < 0 || this.printSize > CanvasBlock.MAX_SIZE) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl handler = (ServerGamePacketListenerImpl)p_148833_1_;
            ModernLifeCommon.LOGGER.debug("check camera");
            ServerPlayer player = handler.f_9743_;
            ItemStack itemStack = handler.f_9743_.m_21205_();
            if (itemStack.m_41720_() == CustomBlocks.ITEM_CAMERA.get()) {
                Tag imageListTag = itemStack.m_41783_().m_128423_("ImageList");
                ListTag imageList = null;
                if (imageListTag instanceof ListTag && (imageList = (ListTag)imageListTag) != null) {
                    int printedPhotoCount = 0;
                    if (!player.m_9236_().m_46749_(this.pos)) {
                        return;
                    }
                    BlockEntity tileEntity = player.m_9236_().m_7702_(this.pos);
                    if (tileEntity instanceof PrinterBlockEntity) {
                        PrinterBlockEntity printer;
                        BlockState blockState = player.m_9236_().m_8055_(this.pos);
                        MenuProvider containerProvider = ((Block)CustomBlocks.BLOCK_PRINTER.get()).m_7246_(blockState, player.m_9236_(), this.pos);
                        if (containerProvider != null) {
                            player.m_5893_(containerProvider);
                        }
                        if ((printer = (PrinterBlockEntity)tileEntity).freeSlotCount() != 0) {
                            for (int i = 0; i < imageList.size(); ++i) {
                                CompoundTag nbt;
                                Tag Tag2 = imageList.get(i);
                                if (!(Tag2 instanceof CompoundTag) || !(nbt = (CompoundTag)Tag2).m_128441_("UniqueId")) continue;
                                int free = printer.getFirstFreeSlot();
                                if (free == -1) break;
                                imageList.remove(i);
                                --i;
                                long uniqueId = nbt.m_128454_("UniqueId");
                                itemStack.m_41721_(itemStack.m_41773_() - 1);
                                ItemStack newItemStack = new ItemStack(new ItemLike(){

                                    public Item m_5456_() {
                                        return (Item)CustomBlocks.ITEM_CANVAS.get();
                                    }
                                });
                                newItemStack.m_41784_().m_128356_("UniqueId", uniqueId);
                                if (itemStack.m_41783_().m_128441_("TextureSize")) {
                                    newItemStack.m_41783_().m_128405_("TextureSize", itemStack.m_41783_().m_128451_("TextureSize"));
                                }
                                if (itemStack.m_41783_().m_128441_("TextureWidth")) {
                                    newItemStack.m_41783_().m_128405_("TextureWidth", itemStack.m_41783_().m_128451_("TextureWidth"));
                                }
                                if (itemStack.m_41783_().m_128441_("TextureHeight")) {
                                    newItemStack.m_41783_().m_128405_("TextureHeight", itemStack.m_41783_().m_128451_("TextureHeight"));
                                }
                                newItemStack.m_41783_().m_128405_("Size", this.printSize);
                                if (this.printSize == 0) {
                                    newItemStack.m_41783_().m_128350_("BlockWidth", ServerboundPrintSizePacket.sanitizeWidthHeight(this.blockWidth));
                                    newItemStack.m_41783_().m_128350_("BlockHeight", ServerboundPrintSizePacket.sanitizeWidthHeight(this.blockHeight));
                                    newItemStack.m_41783_().m_128350_("xOffset", ServerboundPrintSizePacket.sanitizeOffset(this.xOffset));
                                    newItemStack.m_41783_().m_128350_("yOffset", ServerboundPrintSizePacket.sanitizeOffset(this.yOffset));
                                }
                                newItemStack.m_41714_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Photograph")));
                                printer.m_6836_(free, newItemStack);
                                ++printedPhotoCount;
                            }
                            if (printedPhotoCount > 0) {
                                String photosText = "photos";
                                if (printedPhotoCount == 1) {
                                    photosText = "photo";
                                }
                                player.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Printed " + String.valueOf(printedPhotoCount) + " " + photosText)));
                            }
                        } else if (imageList.size() > 0) {
                            player.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Printer tray is full!  Clear some space to print your photos")));
                        }
                    }
                }
                ModernLifeCommon.LOGGER.debug("finished checking camera");
            } else if (itemStack.m_41720_() == CustomBlocks.ITEM_CANVAS.get()) {
                itemStack.m_41784_().m_128405_("Size", this.printSize);
                if (this.printSize == 0) {
                    itemStack.m_41783_().m_128350_("BlockWidth", ServerboundPrintSizePacket.sanitizeWidthHeight(this.blockWidth));
                    itemStack.m_41783_().m_128350_("BlockHeight", ServerboundPrintSizePacket.sanitizeWidthHeight(this.blockHeight));
                    itemStack.m_41783_().m_128350_("xOffset", ServerboundPrintSizePacket.sanitizeOffset(this.xOffset));
                    itemStack.m_41783_().m_128350_("yOffset", ServerboundPrintSizePacket.sanitizeOffset(this.yOffset));
                }
            }
        }
    }
}

