/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.items.GuitarItem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundGuitarPacket
implements Packet<ServerGamePacketListener> {
    private boolean distorted = false;
    private GuitarItem.Tuning string;
    private int fret;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final float GUITAR_VOLUME = 1.2f;
    public static final float GUITAR_VOLUME_BOOST_CLEAN = 1.4f;

    public ServerboundGuitarPacket() {
    }

    public ServerboundGuitarPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundGuitarPacket(GuitarItem.Tuning string, int fret, boolean distorted) {
        this.string = string;
        this.fret = fret;
        this.distorted = distorted;
    }

    public void read(FriendlyByteBuf p_148837_1_) {
        this.string = (GuitarItem.Tuning)p_148837_1_.m_130066_(GuitarItem.Tuning.class);
        this.fret = p_148837_1_.readInt();
        this.distorted = p_148837_1_.readBoolean();
    }

    public void m_5779_(FriendlyByteBuf p_148840_1_) {
        p_148840_1_.m_130068_((Enum)this.string);
        p_148840_1_.writeInt(this.fret);
        p_148840_1_.writeBoolean(this.distorted);
    }

    public static float getFreqMultForFret(int fret) {
        return (float)(0.9470365854 * Math.exp(0.058 * (double)fret) / 2.0);
    }

    public static SoundEvent getSoundEvent(GuitarItem.Tuning string, boolean distorted) {
        SoundEvent soundEvent = (SoundEvent)CustomBlocks.SOUND_GUITAR_E.get();
        if (!distorted) {
            if (string == GuitarItem.Tuning.STRING_E) {
                soundEvent = (SoundEvent)CustomBlocks.SOUND_GUITAR_E.get();
            } else if (string == GuitarItem.Tuning.STRING_A) {
                soundEvent = (SoundEvent)CustomBlocks.SOUND_GUITAR_A.get();
            } else if (string == GuitarItem.Tuning.STRING_D) {
                soundEvent = (SoundEvent)CustomBlocks.SOUND_GUITAR_D.get();
            } else if (string == GuitarItem.Tuning.STRING_G) {
                soundEvent = (SoundEvent)CustomBlocks.SOUND_GUITAR_G.get();
            } else if (string == GuitarItem.Tuning.STRING_B) {
                soundEvent = (SoundEvent)CustomBlocks.SOUND_GUITAR_B.get();
            } else if (string == GuitarItem.Tuning.STRING_HI_E) {
                soundEvent = (SoundEvent)CustomBlocks.SOUND_GUITAR_HI_E.get();
            }
        } else if (string == GuitarItem.Tuning.STRING_E) {
            soundEvent = (SoundEvent)CustomBlocks.SOUND_DIST_GUITAR_E.get();
        } else if (string == GuitarItem.Tuning.STRING_A) {
            soundEvent = (SoundEvent)CustomBlocks.SOUND_DIST_GUITAR_A.get();
        } else if (string == GuitarItem.Tuning.STRING_D) {
            soundEvent = (SoundEvent)CustomBlocks.SOUND_DIST_GUITAR_D.get();
        } else if (string == GuitarItem.Tuning.STRING_G) {
            soundEvent = (SoundEvent)CustomBlocks.SOUND_DIST_GUITAR_G.get();
        } else if (string == GuitarItem.Tuning.STRING_B) {
            soundEvent = (SoundEvent)CustomBlocks.SOUND_DIST_GUITAR_B.get();
        } else if (string == GuitarItem.Tuning.STRING_HI_E) {
            soundEvent = (SoundEvent)CustomBlocks.SOUND_DIST_GUITAR_HI_E.get();
        }
        return soundEvent;
    }

    public static void playGuitarSound(Level world, Player player, BlockPos pos, SoundEvent soundEvent, boolean distorted, int fret) {
        Double configValue;
        if (world == null || soundEvent == null) {
            return;
        }
        float calculatedVolume = 1.2f;
        if (!distorted) {
            calculatedVolume *= 1.4f;
        }
        if ((configValue = (Double)ModernLifeConfig.COMMON.guitarVolumeBoost.get()) != null) {
            calculatedVolume *= configValue.floatValue();
        }
        ModernLifeCommon.LOGGER.debug("world = " + world);
        world.m_5594_(player, pos, soundEvent, SoundSource.BLOCKS, calculatedVolume, ServerboundGuitarPacket.getFreqMultForFret(fret));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundGuitarPacket");
        if (this.string == null || this.fret < 1 || this.fret > 25) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            Boolean configValue;
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            ModernLifeCommon.LOGGER.debug("world = " + (Level)world);
            if (!(world == null || (configValue = (Boolean)ModernLifeConfig.SERVER.guitarOnlyPlaysLocally.get()) != null && configValue.booleanValue())) {
                SoundEvent soundEvent = ServerboundGuitarPacket.getSoundEvent(this.string, this.distorted);
                ModernLifeCommon.LOGGER.debug("play note, fret=" + this.fret + ", freq=" + ServerboundGuitarPacket.getFreqMultForFret(this.fret));
                ServerboundGuitarPacket.playGuitarSound((Level)world, (Player)serverHandler.f_9743_, serverHandler.f_9743_.m_20183_(), soundEvent, this.distorted, this.fret);
            }
        }
    }
}

