/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.gui.chess.BishopPiece;
import com.dairymoose.modernlife.blocks.gui.chess.ChessScreen;
import com.dairymoose.modernlife.blocks.gui.chess.KingPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KnightPiece;
import com.dairymoose.modernlife.blocks.gui.chess.PawnPiece;
import com.dairymoose.modernlife.blocks.gui.chess.Piece;
import com.dairymoose.modernlife.blocks.gui.chess.PieceIds;
import com.dairymoose.modernlife.blocks.gui.chess.QueenPiece;
import com.dairymoose.modernlife.blocks.gui.chess.RookPiece;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.ChessBoardBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundChessStatePacket
implements Packet<ServerGamePacketListener> {
    public int currentTurn;
    public int newCheckState;
    public String whitePlayer;
    public String blackPlayer;
    public boolean isWhiteTurn;
    public List<Piece> whitePieces;
    public List<Piece> blackPieces;
    public Piece movedPiece;
    private BlockPos chessBoardPos;
    public ChessScreen.CastleFlags castleFlags;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundChessStatePacket() {
    }

    public ServerboundChessStatePacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundChessStatePacket(int currentTurn, int newCheckState, String whitePlayer, String blackPlayer, boolean isWhiteTurn, BlockPos chessBoardPos, List<Piece> whitePieces, List<Piece> blackPieces, Piece movedPiece, ChessScreen.CastleFlags castleFlags) {
        this.currentTurn = currentTurn;
        this.newCheckState = newCheckState;
        this.whitePlayer = whitePlayer;
        this.blackPlayer = blackPlayer;
        this.isWhiteTurn = isWhiteTurn;
        this.chessBoardPos = chessBoardPos;
        this.whitePieces = whitePieces;
        this.blackPieces = blackPieces;
        this.movedPiece = movedPiece;
        this.castleFlags = castleFlags;
    }

    private void addPieceToList(List<Piece> pieceList, int type, int x, int y) {
        if (type == PieceIds.BISHOP.ordinal()) {
            pieceList.add(new BishopPiece().withXy(x, y));
        } else if (type == PieceIds.KING.ordinal()) {
            pieceList.add(new KingPiece().withXy(x, y));
        } else if (type == PieceIds.KNIGHT.ordinal()) {
            pieceList.add(new KnightPiece().withXy(x, y));
        } else if (type == PieceIds.PAWN.ordinal()) {
            pieceList.add(new PawnPiece().withXy(x, y));
        } else if (type == PieceIds.QUEEN.ordinal()) {
            pieceList.add(new QueenPiece().withXy(x, y));
        } else if (type == PieceIds.ROOK.ordinal()) {
            pieceList.add(new RookPiece().withXy(x, y));
        }
    }

    public void read(FriendlyByteBuf packet) {
        int y;
        int x;
        int type;
        this.whitePieces = new ArrayList<Piece>();
        this.blackPieces = new ArrayList<Piece>();
        this.currentTurn = packet.readInt();
        this.newCheckState = packet.readInt();
        this.whitePlayer = packet.m_130136_(40);
        this.blackPlayer = packet.m_130136_(40);
        this.isWhiteTurn = packet.readBoolean();
        this.chessBoardPos = packet.m_130135_();
        int whiteCount = packet.readInt();
        for (int i = 0; i < whiteCount; ++i) {
            type = packet.readInt();
            x = packet.readInt();
            y = packet.readInt();
            this.addPieceToList(this.whitePieces, type, x, y);
        }
        int blackCount = packet.readInt();
        for (int i = 0; i < blackCount; ++i) {
            int type2 = packet.readInt();
            int x2 = packet.readInt();
            int y2 = packet.readInt();
            this.addPieceToList(this.blackPieces, type2, x2, y2);
        }
        type = packet.readInt();
        x = packet.readInt();
        y = packet.readInt();
        ArrayList<Piece> movedPieces = new ArrayList<Piece>();
        this.addPieceToList(movedPieces, type, x, y);
        if (movedPieces.size() == 1) {
            this.movedPiece = (Piece)movedPieces.get(0);
        }
        if (this.castleFlags == null) {
            this.castleFlags = new ChessScreen.CastleFlags();
        }
        this.castleFlags.blackKingHasMoved = packet.readBoolean();
        this.castleFlags.blackLeftRookHasMoved = packet.readBoolean();
        this.castleFlags.blackRightRookHasMoved = packet.readBoolean();
        this.castleFlags.whiteKingHasMoved = packet.readBoolean();
        this.castleFlags.whiteLeftRookHasMoved = packet.readBoolean();
        this.castleFlags.whiteRightRookHasMoved = packet.readBoolean();
    }

    public void m_5779_(FriendlyByteBuf packet) {
        packet.writeInt(this.currentTurn);
        packet.writeInt(this.newCheckState);
        if (this.whitePlayer != null) {
            packet.m_130070_(this.whitePlayer);
        } else {
            packet.m_130070_("");
        }
        if (this.blackPlayer != null) {
            packet.m_130070_(this.blackPlayer);
        } else {
            packet.m_130070_("");
        }
        packet.writeBoolean(this.isWhiteTurn);
        packet.m_130064_(this.chessBoardPos);
        packet.writeInt(this.whitePieces.size());
        for (Piece p : this.whitePieces) {
            packet.writeInt(p.getId());
            packet.writeInt(p.x);
            packet.writeInt(p.y);
        }
        packet.writeInt(this.blackPieces.size());
        for (Piece p : this.blackPieces) {
            packet.writeInt(p.getId());
            packet.writeInt(p.x);
            packet.writeInt(p.y);
        }
        if (this.movedPiece != null) {
            packet.writeInt(this.movedPiece.getId());
            packet.writeInt(this.movedPiece.x);
            packet.writeInt(this.movedPiece.y);
        } else {
            packet.writeInt(-1);
            packet.writeInt(0);
            packet.writeInt(0);
        }
        packet.writeBoolean(this.castleFlags.blackKingHasMoved);
        packet.writeBoolean(this.castleFlags.blackLeftRookHasMoved);
        packet.writeBoolean(this.castleFlags.blackRightRookHasMoved);
        packet.writeBoolean(this.castleFlags.whiteKingHasMoved);
        packet.writeBoolean(this.castleFlags.whiteLeftRookHasMoved);
        packet.writeBoolean(this.castleFlags.whiteRightRookHasMoved);
    }

    public static ServerboundChessStatePacket fromNbt(CompoundTag nbt) {
        ServerboundChessStatePacket packet = new ServerboundChessStatePacket();
        packet.whitePieces = new ArrayList<Piece>();
        packet.blackPieces = new ArrayList<Piece>();
        if (nbt.m_128441_("BoardState")) {
            int y;
            int x;
            int type;
            CompoundTag item;
            Tag Tag2;
            CompoundTag boardState = nbt.m_128469_("BoardState");
            packet.currentTurn = boardState.m_128451_("CurrentTurn");
            packet.newCheckState = boardState.m_128451_("NewCheckState");
            packet.whitePlayer = boardState.m_128461_("WhitePlayer");
            packet.blackPlayer = boardState.m_128461_("BlackPlayer");
            packet.isWhiteTurn = boardState.m_128471_("IsWhiteTurn");
            if (packet.castleFlags == null) {
                packet.castleFlags = new ChessScreen.CastleFlags();
            }
            packet.castleFlags.blackKingHasMoved = boardState.m_128471_("BlackKingHasMoved");
            packet.castleFlags.blackLeftRookHasMoved = boardState.m_128471_("BlackLeftRookHasMoved");
            packet.castleFlags.blackRightRookHasMoved = boardState.m_128471_("BlackRightRookHasMoved");
            packet.castleFlags.whiteKingHasMoved = boardState.m_128471_("WhiteKingHasMoved");
            packet.castleFlags.whiteLeftRookHasMoved = boardState.m_128471_("WhiteLeftRookHasMoved");
            packet.castleFlags.whiteRightRookHasMoved = boardState.m_128471_("WhiteRightRookHasMoved");
            Tag movedPieceNbt = boardState.m_128423_("MovedPiece");
            if (movedPieceNbt instanceof CompoundTag) {
                CompoundTag item2 = (CompoundTag)movedPieceNbt;
                int type2 = item2.m_128451_("id");
                int x2 = item2.m_128451_("x");
                int y2 = item2.m_128451_("y");
                ArrayList<Piece> movedPieces = new ArrayList<Piece>();
                packet.addPieceToList(movedPieces, type2, x2, y2);
                if (movedPieces.size() == 1) {
                    packet.movedPiece = (Piece)movedPieces.get(0);
                }
            }
            if (boardState.m_128441_("WhitePieces") && (Tag2 = boardState.m_128423_("WhitePieces")) instanceof ListTag) {
                ListTag list = (ListTag)Tag2;
                for (Tag nbtItem : list) {
                    if (!(nbtItem instanceof CompoundTag)) continue;
                    item = (CompoundTag)nbtItem;
                    if (item.m_128441_("id") && item.m_128441_("x") && item.m_128441_("y")) {
                        type = item.m_128451_("id");
                        x = item.m_128451_("x");
                        y = item.m_128451_("y");
                        packet.addPieceToList(packet.whitePieces, type, x, y);
                        continue;
                    }
                    return packet;
                }
            }
            if (boardState.m_128441_("BlackPieces") && (Tag2 = boardState.m_128423_("BlackPieces")) instanceof ListTag) {
                ListTag list = (ListTag)Tag2;
                for (Tag nbtItem : list) {
                    if (!(nbtItem instanceof CompoundTag)) continue;
                    item = (CompoundTag)nbtItem;
                    if (item.m_128441_("id") && item.m_128441_("x") && item.m_128441_("y")) {
                        type = item.m_128451_("id");
                        x = item.m_128451_("x");
                        y = item.m_128451_("y");
                        packet.addPieceToList(packet.blackPieces, type, x, y);
                        continue;
                    }
                    return packet;
                }
            }
        }
        return packet;
    }

    public CompoundTag getPieceNbt(Piece piece) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("id", piece.getId());
        nbt.m_128405_("x", piece.x);
        nbt.m_128405_("y", piece.y);
        return nbt;
    }

    public void writeToNbt(CompoundTag nbt) {
        CompoundTag boardState = new CompoundTag();
        ListTag whiteNbt = new ListTag();
        for (Piece p : this.whitePieces) {
            whiteNbt.add((Object)this.getPieceNbt(p));
        }
        ListTag blackNbt = new ListTag();
        for (Piece p : this.blackPieces) {
            blackNbt.add((Object)this.getPieceNbt(p));
        }
        boardState.m_128365_("WhitePieces", (Tag)whiteNbt);
        boardState.m_128365_("BlackPieces", (Tag)blackNbt);
        boardState.m_128405_("CurrentTurn", this.currentTurn);
        boardState.m_128405_("NewCheckState", this.newCheckState);
        boardState.m_128359_("WhitePlayer", this.whitePlayer);
        boardState.m_128359_("BlackPlayer", this.blackPlayer);
        boardState.m_128379_("IsWhiteTurn", this.isWhiteTurn);
        boardState.m_128379_("BlackKingHasMoved", this.castleFlags.blackKingHasMoved);
        boardState.m_128379_("BlackLeftRookHasMoved", this.castleFlags.blackLeftRookHasMoved);
        boardState.m_128379_("BlackRightRookHasMoved", this.castleFlags.blackRightRookHasMoved);
        boardState.m_128379_("WhiteKingHasMoved", this.castleFlags.whiteKingHasMoved);
        boardState.m_128379_("WhiteLeftRookHasMoved", this.castleFlags.whiteLeftRookHasMoved);
        boardState.m_128379_("WhiteRightRookHasMoved", this.castleFlags.whiteRightRookHasMoved);
        if (this.movedPiece != null) {
            boardState.m_128365_("MovedPiece", (Tag)this.getPieceNbt(this.movedPiece));
        }
        nbt.m_128365_("BoardState", (Tag)boardState);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundChessStatePacket");
        if (this.chessBoardPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            BlockEntity tileEntity;
            BlockState chessBoardState;
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            if (world != null && world.m_46749_(this.chessBoardPos) && (chessBoardState = world.m_8055_(this.chessBoardPos)) != null && chessBoardState.m_60713_((Block)CustomBlocks.BLOCK_CHESS_BOARD.get()) && (tileEntity = world.m_46745_(this.chessBoardPos).m_7702_(this.chessBoardPos)) instanceof ChessBoardBlockEntity) {
                ChessBoardBlockEntity chessBoardBlockEntity = (ChessBoardBlockEntity)tileEntity;
                ItemStack currentItem = chessBoardBlockEntity.m_8020_(0);
                if (chessBoardBlockEntity != null) {
                    ItemStack itemStack = currentItem;
                    this.writeToNbt(itemStack.m_41784_());
                    world.m_7260_(this.chessBoardPos, chessBoardState, chessBoardState, 2);
                }
            }
        }
    }
}

