/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundCameraPacket
implements Packet<ServerGamePacketListener> {
    private byte[] image;
    private int texSize;
    private static final Logger LOGGER = LogManager.getLogger();
    private static long lastPacketTimestamp = 0L;
    private static int incomingPacketCounter = 0;
    private static long reenableCamera = 0L;
    private boolean enabled = false;

    public ServerboundCameraPacket() {
    }

    public ServerboundCameraPacket(byte[] image, int texSize) {
        this.image = image;
        this.texSize = texSize;
    }

    public ServerboundCameraPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.image = buffer.m_130052_();
        this.texSize = buffer.readInt();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.m_130087_(this.image);
        buffer.writeInt(this.texSize);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        if (!this.enabled) {
            return;
        }
        ModernLifeCommon.LOGGER.debug("Handle ServerboundCameraPacket");
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            CompoundTag nbt = new CompoundTag();
            Level world = serverHandler.f_9743_.m_9236_();
            ModernLifeCommon.LOGGER.debug("world = " + world);
            if (world != null) {
                ModernLifeCommon.LOGGER.debug("image length = " + this.image.length);
                if (this.image != null && this.image.length != 0 && this.image.length < 197000 && this.texSize <= 256) {
                    long currentTimestamp = System.currentTimeMillis();
                    long timeDiff = currentTimestamp - lastPacketTimestamp;
                    long timeDiffReenableCamera = currentTimestamp - reenableCamera;
                    if (timeDiffReenableCamera >= 0L) {
                        ItemStack itemStack = new ItemStack(new ItemLike(){

                            public Item m_5456_() {
                                return (Item)CustomBlocks.ITEM_CANVAS.get();
                            }
                        });
                        itemStack.m_41784_().m_128382_("image", this.image);
                        if (this.texSize > 0) {
                            itemStack.m_41783_().m_128405_("TextureSize", this.texSize);
                        }
                        serverHandler.f_9743_.m_36356_(itemStack);
                        ++incomingPacketCounter;
                        if (timeDiff >= 5000L) {
                            if (incomingPacketCounter > 50) {
                                reenableCamera = currentTimestamp + 3600000L;
                            }
                            incomingPacketCounter = 0;
                            lastPacketTimestamp = System.currentTimeMillis();
                        }
                    }
                } else {
                    ModernLifeCommon.LOGGER.debug("incoming image is too big");
                }
            }
        }
    }

    public byte[] getImage() {
        return this.image;
    }
}

