/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.network.play.client.ICanvasReader;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundMultipartCanvasPacket
implements Packet<ClientGamePacketListener> {
    private long uniqueId;
    private int texWidth;
    private int texHeight;
    private int seqNo;
    private int series;
    private boolean last;
    private byte[] image;
    private BlockPos pos;
    private static final Logger LOGGER = LogManager.getLogger();
    public static AtomicInteger seriesCounter = new AtomicInteger(0);
    private static Map<DualKey, List<ClientboundMultipartCanvasPacket>> cameraPackets = new ConcurrentHashMap<DualKey, List<ClientboundMultipartCanvasPacket>>();
    private static List<ICanvasReader> updateSubscribers = new CopyOnWriteArrayList<ICanvasReader>();
    private ExecutorService threadExecutor = Executors.newCachedThreadPool();

    public static void subscribe(ICanvasReader reader) {
        if (reader != null) {
            updateSubscribers.add(reader);
        }
    }

    public static void unsubscribe(ICanvasReader reader) {
        if (reader != null) {
            updateSubscribers.remove(reader);
        }
    }

    public ClientboundMultipartCanvasPacket() {
    }

    public ClientboundMultipartCanvasPacket(int series, long uniqueId, int seqNo, boolean last, byte[] image, int texWidth, int texHeight, BlockPos pos) {
        this.series = series;
        this.uniqueId = uniqueId;
        this.seqNo = seqNo;
        this.last = last;
        this.image = image;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.pos = pos;
    }

    public ClientboundMultipartCanvasPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.series = buffer.readInt();
        this.uniqueId = buffer.readLong();
        this.seqNo = buffer.readInt();
        this.last = buffer.readBoolean();
        this.image = buffer.m_130052_();
        this.texWidth = buffer.readInt();
        this.texHeight = buffer.readInt();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.series);
        buffer.writeLong(this.uniqueId);
        buffer.writeInt(this.seqNo);
        buffer.writeBoolean(this.last);
        buffer.m_130087_(this.image);
        buffer.writeInt(this.texWidth);
        buffer.writeInt(this.texHeight);
        buffer.m_130064_(this.pos);
    }

    public void handle(final Supplier<NetworkEvent.Context> ctx) {
        final ClientboundMultipartCanvasPacket thisHandler = this;
        this.threadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                thisHandler.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private ClientboundMultipartCanvasPacket getLastPacket(List<ClientboundMultipartCanvasPacket> packets) {
        for (ClientboundMultipartCanvasPacket packet : packets) {
            if (!packet.last) continue;
            return packet;
        }
        return null;
    }

    public static boolean ensureDirectory(String subDir) {
        if (StringUtils.isEmpty((CharSequence)subDir)) {
            return false;
        }
        String dir = subDir;
        File f = new File(dir);
        return f.mkdirs();
    }

    public static String getFolderPath() {
        String root = "";
        String folderName = null;
        String prefix = "";
        if (FMLEnvironment.dist == Dist.CLIENT) {
            prefix = "multiplayer/";
            if (Minecraft.m_91087_().m_91091_()) {
                prefix = "singleplayer/";
                folderName = Minecraft.m_91087_().m_91092_().m_129910_().m_5462_();
                ModernLifeCommon.LOGGER.debug("currentServer name: " + folderName);
            } else if (Minecraft.m_91087_().m_91089_() != null) {
                folderName = Minecraft.m_91087_().m_91089_().f_105362_;
                if (StringUtils.isEmpty((CharSequence)(folderName = folderName.replaceAll("\\W+", "_").trim()).replaceAll("_", ""))) {
                    folderName = Minecraft.m_91087_().m_91089_().f_105363_;
                }
                ModernLifeCommon.LOGGER.debug("getServer name: " + folderName);
            } else {
                folderName = "offline";
            }
        } else {
            folderName = "";
            if (ModernLifeCommon.ServerLevelFolderName != null) {
                root = ModernLifeCommon.ServerLevelFolderName;
            }
        }
        String path = root + "modernlife/" + prefix + folderName;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ClientboundMultipartCanvasPacket.ensureDirectory(path);
        return path;
    }

    public static synchronized void syncHandle(ClientboundMultipartCanvasPacket thisPacket, ClientGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ClientboundMultipartCanvasPacket for series = " + thisPacket.series + " with unique ID = " + thisPacket.uniqueId);
        DualKey dk = new DualKey(Minecraft.m_91087_().f_91074_, thisPacket.series);
        List<ClientboundMultipartCanvasPacket> packets = cameraPackets.get(dk);
        if (packets == null) {
            packets = new ArrayList<ClientboundMultipartCanvasPacket>();
            cameraPackets.put(dk, packets);
        }
        packets.add(thisPacket);
        ClientboundMultipartCanvasPacket lastPacket = thisPacket.getLastPacket(packets);
        byte[] stitchedImage = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (lastPacket != null && packets.size() == lastPacket.seqNo) {
            packets.sort(new Comparator<ClientboundMultipartCanvasPacket>(){

                @Override
                public int compare(ClientboundMultipartCanvasPacket var1, ClientboundMultipartCanvasPacket var2) {
                    return var1.seqNo - var2.seqNo;
                }
            });
            for (ClientboundMultipartCanvasPacket packet : packets) {
                try {
                    stream.write(packet.image);
                }
                catch (IOException e) {
                    ModernLifeCommon.LOGGER.debug("error writing image part", (Throwable)e);
                }
            }
            stitchedImage = stream.toByteArray();
        }
        if (stitchedImage != null) {
            ModernLifeCommon.LOGGER.debug("image length = " + stitchedImage.length + " for series = " + thisPacket.series);
        }
        if (stitchedImage != null && stitchedImage.length != 0) {
            packets.clear();
            ModernLifeCommon.LOGGER.debug("Got image update with ID = " + thisPacket.uniqueId);
            ServerboundMultipartCameraPacket.savePng(thisPacket.uniqueId, stitchedImage, thisPacket.texWidth, thisPacket.texHeight);
            ModernLifeClient.putCachedData(System.currentTimeMillis(), thisPacket.uniqueId, stitchedImage, thisPacket.texWidth, thisPacket.texHeight);
            for (ICanvasReader reader : updateSubscribers) {
                reader.onUpdate(thisPacket.uniqueId);
            }
        } else if (stitchedImage != null) {
            packets.clear();
            ModernLifeCommon.LOGGER.debug("incoming image is too big");
        }
    }

    public void handle(ClientGamePacketListener p_148833_1_) {
        ClientboundMultipartCanvasPacket.syncHandle(this, p_148833_1_);
    }

    public byte[] getImage() {
        return this.image;
    }

    private static class DualKey {
        public Player player;
        public int series;

        public DualKey(Object player, int series) {
            this.player = (Player)player;
            this.series = series;
        }

        public int hashCode() {
            return 31 + 7 * this.player.hashCode() + 11 * Integer.hashCode(this.series);
        }

        public boolean equals(Object var1) {
            if (var1 instanceof DualKey) {
                if (this.player != ((DualKey)var1).player) {
                    return false;
                }
                return this.series == ((DualKey)var1).series;
            }
            return false;
        }
    }
}

