/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ServerboundChainsawTargetPacket;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChainsawItem
extends DiggerItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Block> CHAINSAW_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.f_50692_, Blocks.f_50451_, Blocks.f_50033_});
    private static final Set<Block> OTHER_DIGGABLE_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.f_50155_, Blocks.f_50616_, Blocks.f_50251_, Blocks.f_50252_, Blocks.f_50253_, Blocks.f_50254_, Blocks.f_50309_, Blocks.f_50308_, Blocks.f_50669_, Blocks.f_50670_, Blocks.f_50451_, Blocks.f_50033_});
    private static final Set<Block> CHAINSAW_DIGGABLE_SET = Sets.union(CHAINSAW_BLOCKS, OTHER_DIGGABLE_BLOCKS);
    public static Map<Player, MiningInfo> mineMap = new HashMap<Player, MiningInfo>();
    boolean isWieldingChainsaw = false;
    private int chainsawStartTick = 0;
    private static final int CHAINSAW_START_PAUSE = 6;
    private static final int CHAINSAW_IDLE_PAUSE = 18;

    public ChainsawItem(Tier tier, float p_i48530_2_, float p_i48530_3_, Item.Properties p_i48530_4_) {
        super(p_i48530_2_, p_i48530_3_, tier, BlockTags.f_144280_, p_i48530_4_);
    }

    public boolean isDiggable(BlockState state) {
        return state.m_204336_(BlockTags.f_144280_) || CHAINSAW_DIGGABLE_SET.contains(state.m_60734_()) || state.m_204336_(BlockTags.f_13035_);
    }

    public float m_8102_(ItemStack p_150893_1_, BlockState state) {
        float webMult = 1.0f;
        if (state.m_60713_(Blocks.f_50033_)) {
            webMult = 2.0f;
        }
        return this.isDiggable(state) ? webMult * this.f_40980_ : super.m_8102_(p_150893_1_, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void chainsawAttack(Level world, Player player, ItemStack itemStack, Entity targetEntity, Vec3 loc) {
        LivingEntity livingEntity = (LivingEntity)targetEntity;
        if (livingEntity.m_6084_() && livingEntity.m_6097_()) {
            int initialInvulnerableTime = livingEntity.f_19802_;
            AttributeInstance kbResist = livingEntity.m_21051_(Attributes.f_22278_);
            double kbResistInitial = kbResist.m_22115_();
            try {
                double pickRange = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
                double chainsawRange = pickRange * 1.0;
                double chainsawRangeSqr = chainsawRange * chainsawRange;
                if (livingEntity.m_20238_(player.m_20299_(1.0f)) <= chainsawRangeSqr && world instanceof ServerLevel) {
                    livingEntity.f_19802_ = 0;
                    kbResist.m_22100_(1.0);
                    if (livingEntity.m_6469_(world.m_269111_().m_269075_(player), 1.87f)) {
                        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123784_, livingEntity.m_20185_() + (Math.random() * 0.5 - 0.25), loc.f_82480_, livingEntity.m_20189_() + (Math.random() * 0.5 - 0.25), 30, 0.0, 0.0, 0.0, 0.0);
                        int durabilityDamage = 26;
                        Integer chainsawConfigDamage = (Integer)ModernLifeConfig.SERVER.chainsawDurabilityDamageOnAttack.get();
                        if (chainsawConfigDamage != null) {
                            durabilityDamage = chainsawConfigDamage;
                        }
                        itemStack.m_41622_(durabilityDamage, (LivingEntity)player, t -> {});
                        if (itemStack.m_41613_() <= 0) {
                            return;
                        }
                    }
                }
            }
            finally {
                livingEntity.f_19802_ = initialInvulnerableTime;
                kbResist.m_22100_(kbResistInitial);
            }
        }
    }

    private void chainsawSound(Level world, Player player, int count, float pitchMod) {
        if (count % 4 == 0) {
            float volume = 0.15f;
            world.m_5594_(player, player.m_20183_(), (SoundEvent)CustomBlocks.SOUND_CHAINSAW_RUNNING.get(), SoundSource.BLOCKS, volume, 0.9f + pitchMod);
        }
    }

    private boolean shouldPlayChainsawIdleSound() {
        boolean shouldPlay = true;
        Boolean shouldPlayConfig = (Boolean)ModernLifeConfig.CLIENT.chainsawPlaysIdleSound.get();
        if (shouldPlayConfig != null) {
            shouldPlay = shouldPlayConfig;
        }
        return shouldPlay;
    }

    private void chainsawStartSound(Level world, Player player, int count) {
        float volume = 0.15f;
        if (this.shouldPlayChainsawIdleSound()) {
            world.m_5594_(player, player.m_20183_(), (SoundEvent)CustomBlocks.SOUND_CHAINSAW_START.get(), SoundSource.BLOCKS, volume, 1.0f);
        }
    }

    private void chainsawIdleSound(Level world, Player player, int count) {
        if (count % 4 == 0 && this.shouldPlayChainsawIdleSound()) {
            float volume = 0.04f;
            world.m_5594_(player, player.m_20183_(), (SoundEvent)CustomBlocks.SOUND_CHAINSAW_IDLE.get(), SoundSource.BLOCKS, volume, 1.0f);
        }
    }

    private void chainsawStopSound(Level world, Player player, int count) {
        float volume = 0.15f;
        if (this.shouldPlayChainsawIdleSound()) {
            world.m_5594_(player, player.m_20183_(), (SoundEvent)CustomBlocks.SOUND_CHAINSAW_STOP.get(), SoundSource.BLOCKS, volume, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int slot, boolean isMainHand) {
        LivingEntity le;
        if (level.f_46443_ && entity instanceof LivingEntity && (le = (LivingEntity)entity).m_19879_() == Minecraft.m_91087_().f_91074_.m_19879_()) {
            LocalPlayer self = Minecraft.m_91087_().f_91074_;
            ItemStack mainHandItem = le.m_21205_();
            ItemStack offHandItem = le.m_21206_();
            if (!this.isWieldingChainsaw) {
                if (mainHandItem.m_150930_((Item)CustomBlocks.ITEM_CHAINSAW.get()) || offHandItem.m_150930_((Item)CustomBlocks.ITEM_CHAINSAW.get())) {
                    this.isWieldingChainsaw = true;
                    this.chainsawStartTick = ModernLifeCommon.clientTickCounter;
                }
            } else {
                int tickDiff = ModernLifeCommon.clientTickCounter - this.chainsawStartTick;
                if (!mainHandItem.m_150930_((Item)CustomBlocks.ITEM_CHAINSAW.get()) && !offHandItem.m_150930_((Item)CustomBlocks.ITEM_CHAINSAW.get())) {
                    if (this.isWieldingChainsaw && tickDiff >= 18) {
                        this.chainsawStopSound(level, (Player)self, 0);
                    }
                    this.isWieldingChainsaw = false;
                } else if (tickDiff == 6) {
                    this.chainsawStartSound(level, (Player)self, 0);
                } else if (!(tickDiff < 18 || le.m_21211_() != null && le.m_21211_().m_150930_((Item)CustomBlocks.ITEM_CHAINSAW.get()))) {
                    this.chainsawIdleSound(level, (Player)self, ModernLifeCommon.clientTickCounter);
                }
            }
        }
        super.m_6883_(itemStack, level, entity, slot, isMainHand);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int count) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (livingEntity.m_9236_().f_46443_) {
                if (livingEntity != Minecraft.m_91087_().f_91074_) {
                    return;
                }
                HitResult rayTrace = this.getRayTraceForPlayer(player.m_9236_(), player);
                BlockHitResult blockRayTrace = null;
                int entityId = -1;
                if (rayTrace.m_6662_() == HitResult.Type.ENTITY) {
                    EntityHitResult entityRayTrace = (EntityHitResult)rayTrace;
                    Entity entity = entityRayTrace.m_82443_();
                    if (entity instanceof LivingEntity) {
                        entityId = entity.m_19879_();
                        Vec3 loc = entityRayTrace.m_82450_();
                        blockRayTrace = BlockHitResult.m_82426_((Vec3)loc, (Direction)Direction.UP, (BlockPos)BlockPos.m_274561_((double)loc.f_82479_, (double)loc.f_82480_, (double)loc.f_82481_));
                    }
                } else if (rayTrace.m_6662_() == HitResult.Type.BLOCK) {
                    blockRayTrace = (BlockHitResult)rayTrace;
                }
                float pitchMod = 0.0f;
                if (rayTrace.m_6662_() == HitResult.Type.BLOCK || rayTrace.m_6662_() == HitResult.Type.ENTITY) {
                    pitchMod = 0.1f;
                }
                this.chainsawSound(player.m_9236_(), player, count, pitchMod);
                ServerboundChainsawTargetPacket chainsawTarget = new ServerboundChainsawTargetPacket(blockRayTrace, entityId);
                ModernLifeNetwork.INSTANCE.sendToServer((Object)chainsawTarget);
            } else {
                MiningInfo mInfo = mineMap.get(player);
                if (mInfo == null) {
                    mInfo = new MiningInfo();
                    mineMap.put(player, mInfo);
                }
                Level world = livingEntity.m_9236_();
                HitResult rayTrace = null;
                rayTrace = mInfo.rayTrace;
                if (rayTrace == null) {
                    return;
                }
                float pitchMod = 0.0f;
                if (rayTrace.m_6662_() == HitResult.Type.BLOCK || rayTrace.m_6662_() == HitResult.Type.ENTITY) {
                    pitchMod = 0.1f;
                }
                this.chainsawSound(player.m_9236_(), player, count, pitchMod);
                Vec3 loc = rayTrace.m_82450_();
                Entity entity = null;
                if (rayTrace.m_6662_() == HitResult.Type.ENTITY) {
                    mInfo.rayTrace = rayTrace;
                    EntityHitResult entityRayTrace = (EntityHitResult)rayTrace;
                    entity = entityRayTrace.m_82443_();
                    if (entity instanceof LivingEntity) {
                        Entity targetEntity = entity;
                        if (itemStack != null && itemStack.m_41720_() == CustomBlocks.ITEM_CHAINSAW.get() && itemStack.m_41613_() > 0) {
                            this.chainsawAttack(world, player, itemStack, targetEntity, loc);
                            if (!targetEntity.m_6084_()) {
                                mInfo.rayTrace = null;
                            }
                        }
                    }
                } else if (rayTrace.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult blockRayTrace = (BlockHitResult)rayTrace;
                    double pickRange = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
                    double chainsawRange = pickRange * 1.0;
                    double chainsawRangeSqr = chainsawRange * chainsawRange;
                    if (blockRayTrace.m_82450_().m_82557_(player.m_20299_(1.0f)) > chainsawRangeSqr) {
                        return;
                    }
                    BlockPos pos = blockRayTrace.m_82425_();
                    BlockState state = world.m_8055_(pos);
                    if (!state.m_60795_()) {
                        ParticleType particles = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ForgeRegistries.PARTICLE_TYPES.getKey((Object)ParticleTypes.f_123794_));
                        if (particles != null) {
                            BlockParticleOption blockParticle = new BlockParticleOption(particles, state);
                            if (world instanceof ServerLevel) {
                                for (int i = 0; i < 10; ++i) {
                                    ((ServerLevel)world).m_8767_((ParticleOptions)blockParticle, loc.f_82479_ + (Math.random() * 1.0 - 0.5), loc.f_82480_ + (Math.random() * 1.0 - 0.5), loc.f_82481_ + (Math.random() * 1.0 - 0.5), 1, 0.0, 0.0, 0.0, 0.0);
                                }
                            }
                        }
                        this.mineIfPossible(player, world, pos, mInfo);
                    }
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void destroyGrid(Level world, BlockPos center, int width, int height) {
        BlockPos newCenter = center.m_6625_(height / 2);
        for (int h = 0; h < height; ++h) {
            BlockPos westPos = newCenter.m_122025_(width / 2);
            for (int w = 0; w < width; ++w) {
                BlockPos destroyPos = westPos.m_122013_(width / 2);
                for (int slice = 0; slice < width; ++slice) {
                    if (!destroyPos.equals((Object)center) && world.m_8055_(destroyPos).m_60713_(world.m_8055_(center).m_60734_())) {
                        this.destroyIfPossible(world, destroyPos);
                    }
                    destroyPos = destroyPos.m_122019_();
                }
                westPos = westPos.m_122029_();
            }
            newCenter = newCenter.m_7494_();
        }
    }

    public boolean mineIfPossible(Player player, Level world, BlockPos pos, MiningInfo mInfo) {
        if (!pos.equals((Object)mInfo.pos)) {
            mInfo.pos = pos;
            mInfo.miningProgress = 0.0f;
        } else {
            BlockState state = world.m_8055_(pos);
            float toolMult = this.m_8102_(player.m_21211_(), state);
            float usingChainsawMult = 2.0f;
            ItemStack itemStack = player.m_21211_();
            float enchantMult = 1.0f;
            if (this.isDiggable(state)) {
                usingChainsawMult = 6.0f;
                if (itemStack.m_41793_()) {
                    ListTag enchantmentTags = itemStack.m_41785_();
                    for (int i = 0; i < enchantmentTags.size(); ++i) {
                        Tag Tag2 = enchantmentTags.get(i);
                        if (!(Tag2 instanceof CompoundTag)) continue;
                        CompoundTag nbt = (CompoundTag)Tag2;
                        String id = nbt.m_128461_("id");
                        int level = nbt.m_128451_("lvl");
                        if (id == null || !"minecraft:efficiency".equals(id) || level <= 0) continue;
                        enchantMult = 1.0f + (float)level / 5.0f;
                    }
                }
            }
            float blockDestroySpeed = state.m_60800_((BlockGetter)world, pos);
            float progressIncrement = usingChainsawMult * toolMult * enchantMult / blockDestroySpeed;
            mInfo.miningProgress += progressIncrement;
            float destroyProgress = state.m_60625_(player, (BlockGetter)world, pos);
            int newProgressValueToSet = (int)(mInfo.miningProgress / 10.0f);
            world.m_6801_(-1, pos, --newProgressValueToSet);
            if (mInfo.miningProgress >= 100.0f && world instanceof ServerLevel) {
                mInfo.pos = null;
                mInfo.miningProgress = 0.0f;
                if (this.isDiggable(state)) {
                    this.destroyGrid(world, pos, 3, 3);
                    if (!state.m_204336_(BlockTags.f_13035_)) {
                        itemStack.m_41622_(3, (LivingEntity)player, x -> {});
                    }
                } else {
                    itemStack.m_41622_(6, (LivingEntity)player, x -> {});
                }
                world.m_6801_(player.m_19879_(), pos, 10);
                return world.m_46961_(pos, true);
            }
        }
        return false;
    }

    public boolean destroyIfPossible(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (this.isDiggable(state)) {
            return world.m_46961_(pos, true);
        }
        return false;
    }

    private HitResult getRayTraceForPlayer(Level world, Player player) {
        double d0 = Minecraft.m_91087_().f_91072_.m_105286_();
        BlockHitResult rayTrace = Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        Vec3 Vec32 = player.m_20299_(1.0f);
        boolean flag = false;
        int i = 3;
        double d1 = d0;
        if (Minecraft.m_91087_().f_91072_.m_105291_()) {
            d0 = d1 = 6.0;
        } else if (d0 > 3.0) {
            flag = true;
        }
        d1 *= d1;
        if (rayTrace != null) {
            d1 = rayTrace.m_82450_().m_82557_(Vec32);
        }
        Vec3 Vec31 = player.m_20252_(1.0f);
        Vec3 Vec322 = Vec32.m_82520_(Vec31.f_82479_ * d0, Vec31.f_82480_ * d0, Vec31.f_82481_ * d0);
        float f = 1.0f;
        AABB axisalignedbb = player.m_20191_().m_82369_(Vec31.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)Vec32, (Vec3)Vec322, (AABB)axisalignedbb, entity -> !entity.m_5833_() && entity.m_6087_(), (double)d1);
        if (entityHitResult != null) {
            Entity entity1 = entityHitResult.m_82443_();
            Vec3 Vec33 = entityHitResult.m_82450_();
            double d2 = Vec32.m_82557_(Vec33);
            if (flag && d2 > 9.0) {
                rayTrace = BlockHitResult.m_82426_((Vec3)Vec33, (Direction)Direction.m_122366_((double)Vec31.f_82479_, (double)Vec31.f_82480_, (double)Vec31.f_82481_), (BlockPos)BlockPos.m_274561_((double)Vec33.f_82479_, (double)Vec33.f_82480_, (double)Vec33.f_82481_));
            } else if (d2 < d1 || rayTrace == null) {
                rayTrace = entityHitResult;
            }
        }
        return rayTrace;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Right click to use")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* Highly effective on trees and leaves")));
    }

    public void m_5551_(ItemStack itemStack, Level p_77615_2_, LivingEntity entity, int p_77615_4_) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5810_();
            MiningInfo mInfo = mineMap.get(player);
            if (mInfo != null) {
                mInfo.pos = null;
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand p_77659_3_) {
        ItemStack itemStack = player.m_21120_(p_77659_3_);
        player.m_6672_(p_77659_3_);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public static class MiningInfo {
        public float miningProgress;
        public BlockPos pos;
        public HitResult rayTrace;
    }
}

