/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import com.dairymoose.modernlife.util.CanvasData;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CameraItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean usingCamera = false;
    public static Map<Player, Boolean> usingCameraServer = new HashMap<Player, Boolean>();
    public static boolean pendingSnapshot = false;

    public CameraItem(Item.Properties p_i48530_4_) {
        super(p_i48530_4_);
    }

    private static int toInternalRgbFormat(int nativeRgb) {
        int r = nativeRgb & 0xFF;
        int g = (nativeRgb & 0xFF00) >> 8;
        int b = (nativeRgb & 0xFF0000) >> 16;
        return r << 16 | g << 8 | b;
    }

    private static int getAverageRgbAt(NativeImage img, int x, int y, float pixelSampleWidth, float pixelSampleHeight) {
        int destX = (int)((float)x * pixelSampleWidth);
        int destY = (int)((float)y * pixelSampleHeight);
        int rSum = 0;
        int gSum = 0;
        int bSum = 0;
        int iterations = 0;
        int hStart = (int)(-pixelSampleHeight / 2.0f);
        int hEnd = (int)(pixelSampleHeight / 2.0f);
        int wStart = (int)(-pixelSampleWidth / 2.0f);
        int wEnd = (int)(pixelSampleWidth / 2.0f);
        if (hStart == hEnd) {
            hStart = 0;
            hEnd = 1;
            wStart = 0;
            wEnd = 1;
        }
        for (int h = hStart; h < hEnd; ++h) {
            for (int w = wStart; w < wEnd; ++w) {
                int finalX = destX + w;
                int finalY = destY + h;
                finalX = Math.max(finalX, 0);
                finalY = Math.max(finalY, 0);
                finalX = Math.min(finalX, img.m_84982_() - 1);
                finalY = Math.min(finalY, img.m_85084_() - 1);
                int rgb = CameraItem.toInternalRgbFormat(img.m_84985_(finalX, finalY));
                rSum += CanvasData.getRValue(rgb);
                gSum += CanvasData.getGValue(rgb);
                bSum += CanvasData.getBValue(rgb);
                ++iterations;
            }
        }
        int rAvg = rSum / iterations;
        int gAvg = gSum / iterations;
        int bAvg = bSum / iterations;
        return rAvg << 16 | gAvg << 8 | bAvg;
    }

    public static void takePhoto() {
        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12388_, 1.0f, 2.0f);
        NativeImage img = Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_());
        int texW = 512;
        int texH = 512;
        Integer configIntW = (Integer)ModernLifeConfig.COMMON.cameraResolutionW.get();
        Integer configIntH = (Integer)ModernLifeConfig.COMMON.cameraResolutionH.get();
        if (configIntW != null) {
            texW = configIntW;
        }
        if (configIntH != null) {
            texH = configIntH;
        }
        int maxW = Minecraft.m_91087_().m_91268_().m_85443_();
        int maxH = Minecraft.m_91087_().m_91268_().m_85444_();
        if (texW > maxW) {
            texW = maxW;
        }
        if (texH > maxH) {
            texH = maxH;
        }
        float pixelsPerWidth = (float)img.m_84982_() / (float)texW;
        float pixelsPerHeight = (float)img.m_85084_() / (float)texH;
        pixelsPerWidth = Math.max(pixelsPerWidth, 1.0f);
        pixelsPerHeight = Math.max(pixelsPerHeight, 1.0f);
        CanvasData cameraData = new CanvasData();
        cameraData.setTextureSize(texW, texH);
        cameraData.initImage();
        for (int h = 0; h < texH; ++h) {
            for (int w = 0; w < texW; ++w) {
                cameraData.setRgbPixel(w, h, CameraItem.getAverageRgbAt(img, w, h, pixelsPerWidth, pixelsPerHeight));
            }
        }
        int MAX_IMAGE_PART = 30000;
        byte[] compressed = cameraData.toCompressedNbt();
        ArrayList<byte[]> parts = new ArrayList<byte[]>();
        int i = 0;
        while ((double)i < Math.ceil((float)compressed.length / (float)MAX_IMAGE_PART)) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int startIndex = i * MAX_IMAGE_PART;
            int bytesToWrite = Math.min(compressed.length - startIndex, MAX_IMAGE_PART);
            stream.write(compressed, startIndex, bytesToWrite);
            byte[] part = stream.toByteArray();
            parts.add(part);
            ++i;
        }
        for (i = 0; i < parts.size(); ++i) {
            int seqNo = i + 1;
            boolean last = false;
            if (seqNo == parts.size()) {
                last = true;
            }
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundMultipartCameraPacket(seqNo, last, (byte[])parts.get(i), texW, texH));
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        int photoCount = 0;
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("ImageList")) {
            Tag imageListTag = itemStack.m_41783_().m_128423_("ImageList");
            ListTag imageList = null;
            if (imageListTag instanceof ListTag) {
                imageList = (ListTag)imageListTag;
                photoCount = imageList.size();
            }
        }
        int maxPhotos = itemStack.m_41776_();
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.valueOf(photoCount) + "/" + String.valueOf(maxPhotos) + " photos stored in memory card")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* Does not break when durability hits 0")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* Take to a printer to print your photos")));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41773_() < itemStack.m_41776_()) {
            if (world.f_46443_) {
                if (usingCamera) {
                    pendingSnapshot = true;
                }
                usingCamera = !usingCamera;
            } else {
                Boolean result = usingCameraServer.get(player);
                if (result == null) {
                    result = false;
                }
                result = result == false;
                usingCameraServer.put(player, result);
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }
}

