/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import net.minecraftforge.common.ForgeConfigSpec;

public class ModernLifeServerConfig {
    public final ForgeConfigSpec.ConfigValue<Integer> maxImageSizePixels;
    public final ForgeConfigSpec.BooleanValue guitarOnlyPlaysLocally;
    public final ForgeConfigSpec.ConfigValue<Integer> seedSpreaderThrowCooldown;
    public final ForgeConfigSpec.ConfigValue<Integer> chainsawDurabilityDamageOnAttack;
    public final ForgeConfigSpec.ConfigValue<Integer> streetLightMiddlePartCount;
    public final ForgeConfigSpec.BooleanValue photocopierProducesNewImageFiles;
    public final ForgeConfigSpec.ConfigValue<String> seedSpreaderWhitelist;
    public final ForgeConfigSpec.ConfigValue<Integer> flashlightUpdatePeriod;
    public final ForgeConfigSpec.ConfigValue<Double> flashlightRange;
    public final ForgeConfigSpec.ConfigValue<Double> handgunDamage;
    public final ForgeConfigSpec.ConfigValue<Double> handgunCritMultiplier;
    public final ForgeConfigSpec.BooleanValue handgunEnableHeadshots;

    public ModernLifeServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("server");
        builder.push("misc");
        this.maxImageSizePixels = builder.comment("Maximum allowable image size in pixels that the server will load (applies to camera/easel)").translation("config.modernlife.maxImageSizePixels").define("maxImageSizePixels", (Object)2048);
        this.seedSpreaderThrowCooldown = builder.comment("How long the seed spreader will wait to re-attempt throwing to a recent location (milliseconds)").translation("config.modernlife.seedSpreaderThrowCooldown").define("seedSpreaderThrowCooldown", (Object)5000);
        this.seedSpreaderWhitelist = builder.comment("Seedspreader whitelist").translation("config.modernlife.seedspreaderWhitelist").define("seedspreaderWhitelist", (Object)"doggytalents:rice_grains,cobblemon:vivichoke_seeds,cobblemon:revival_herb");
        this.chainsawDurabilityDamageOnAttack = builder.comment("How much durability damage the chainsaw takes every time it ticks for damage").translation("config.modernlife.chainsawDurabilityDamageOnAttack").define("chainsawDurabilityDamageOnAttack", (Object)26);
        this.streetLightMiddlePartCount = builder.comment("Configure the number of 'middle' blocks the street light has").translation("config.modernlife.streetLightMiddlePartCount").define("streetLightMiddlePartCount", (Object)3);
        this.photocopierProducesNewImageFiles = builder.comment("Photocopier will generate a new image file (and new unique ID) every time it is used").translation("config.modernlife.photocopierProducesNewImageFiles").define("photocopierProducesNewImageFiles", true);
        builder.pop();
        builder.push("guitar");
        this.guitarOnlyPlaysLocally = builder.comment("Guitar only plays sounds locally").translation("config.modernlife.guitarOnlyPlaysLocally").define("guitarOnlyPlaysLocally", false);
        builder.pop();
        builder.push("flashlight");
        this.flashlightUpdatePeriod = builder.comment("Time between flashlight updates (in ticks)").translation("config.modernlife.flashlightUpdatePeriod").define("flashlightUpdatePeriod", (Object)4);
        this.flashlightRange = builder.comment("Flashlight block range").translation("config.modernlife.flashlightRange").define("flashlightRange", (Object)6.0);
        builder.pop();
        builder.push("handgun");
        this.handgunDamage = builder.comment("InteractionHandgun base damage").translation("config.modernlife.handgunDamage").define("handgunDamage", (Object)19.5);
        this.handgunCritMultiplier = builder.comment("InteractionHandgun headshot damage multiplier").translation("config.modernlife.handgunCritMultiplier").define("handgunCritMultiplier", (Object)2.0);
        this.handgunEnableHeadshots = builder.comment("InteractionHandgun is capable of dealing critical-damage headshots").translation("config.modernlife.handgunEnableHeadshots").define("handgunEnableHeadshots", true);
        builder.pop();
        builder.pop();
    }
}

