/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CsvSourcedHashSet
extends HashSet<String> {
    private static final long serialVersionUID = 5081837333271002941L;
    private static final Logger LOGGER = LogManager.getLogger();

    public CsvSourcedHashSet(String csvText) {
        ModernLifeCommon.LOGGER.debug("Loading CSV HashSet");
        if (StringUtils.isBlank((CharSequence)csvText)) {
            return;
        }
        String[] split = csvText.split(",");
        if (split == null || split.length == 0) {
            return;
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String datum : split) {
            if (!StringUtils.isNotBlank((CharSequence)datum)) continue;
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(datum);
            this.add(datum);
        }
        ModernLifeCommon.LOGGER.debug("Parsed CSV = " + result.toString());
    }
}

