/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.modernlife.core.AutoRegister;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoRegisterProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, Block> blockInstances = new HashMap<String, Block>();

    public static void processAnnotations(DeferredRegister<Block> BLOCKS, DeferredRegister<Item> ITEMS, Class cls) {
        int registerBlockCount = 0;
        int registerItemCount = 0;
        HashMap soundTypes = new HashMap();
        Field[] soundTypeFields = SoundType.class.getDeclaredFields();
        for (int i = 0; i < soundTypeFields.length; ++i) {
            Field f = soundTypeFields[i];
            if (!SoundType.class.isAssignableFrom(f.getType())) continue;
        }
        HashMap itemGroups = new HashMap();
        Field[] itemGroupFields = CreativeModeTab.class.getDeclaredFields();
        for (int i = 0; i < itemGroupFields.length; ++i) {
            Field f = itemGroupFields[i];
            if (!CreativeModeTab.class.isAssignableFrom(f.getType())) continue;
        }
        HashMap inheritBlocks = new HashMap();
        Field[] inheritBlockFields = Blocks.class.getDeclaredFields();
        for (int i = 0; i < inheritBlockFields.length; ++i) {
            Field f = inheritBlockFields[i];
            if (!Block.class.isAssignableFrom(f.getType())) continue;
        }
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Class blockClass;
            Block blockInstance;
            Field f = fields[i];
            AutoRegister autoReg = f.getDeclaredAnnotation(AutoRegister.class);
            if (autoReg == null) continue;
            if (RegistryObject.class.isAssignableFrom(f.getType()) && f.getGenericType() instanceof ParameterizedType && Block.class.getTypeName().equals(((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0].getTypeName())) {
                blockInstance = null;
                blockClass = autoReg.blockClass();
                try {
                    blockInstance = (Block)((RegistryObject)f.get(null)).get();
                }
                catch (IllegalAccessException | IllegalArgumentException e1) {
                    ModernLifeCommon.LOGGER.error("Error getting block instance", (Throwable)e1);
                }
                if (blockInstance == null) {
                    ModernLifeCommon.LOGGER.error("blockInstance is null");
                    continue;
                }
                blockInstances.put(autoReg.name(), blockInstance);
                ModernLifeCommon.LOGGER.debug("Registered block: " + autoReg.name());
                ++registerBlockCount;
                continue;
            }
            if (RegistryObject.class.isAssignableFrom(f.getType()) && f.getGenericType() instanceof ParameterizedType && Item.class.getTypeName().equals(((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0].getTypeName())) {
                blockInstance = null;
                blockClass = autoReg.blockClass();
                Item itemInstance = null;
                try {
                    itemInstance = (Item)((RegistryObject)f.get(null)).get();
                }
                catch (IllegalAccessException | IllegalArgumentException e1) {
                    ModernLifeCommon.LOGGER.error("Error getting item instance", (Throwable)e1);
                }
                ++registerItemCount;
                continue;
            }
            ModernLifeCommon.LOGGER.error("Not assignable: " + f.getType());
        }
        ModernLifeCommon.LOGGER.debug("Registered " + registerBlockCount + " blocks");
        ModernLifeCommon.LOGGER.debug("Registered " + registerItemCount + " items");
    }

    public static void processRenderTypes(Class cls) {
        int renderTypeCount = 0;
        HashMap<String, RenderType> renderTypes = new HashMap<String, RenderType>();
        Method[] renderTypeMethods = RenderType.class.getDeclaredMethods();
        for (int i = 0; i < renderTypeMethods.length; ++i) {
            Method m = renderTypeMethods[i];
            if (m.getReturnType() == RenderType.class && m.getParameterCount() != 0) continue;
        }
        renderTypes.put("solid", RenderType.m_110451_());
        renderTypes.put("translucent", RenderType.m_110466_());
        renderTypes.put("cutout", RenderType.m_110463_());
        renderTypes.put("cutoutmipped", RenderType.m_110457_());
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            RenderType renderType;
            Field f = fields[i];
            AutoRegister autoReg = f.getDeclaredAnnotation(AutoRegister.class);
            if (autoReg == null || autoReg.renderType().isEmpty() || (renderType = (RenderType)renderTypes.get(autoReg.renderType().toLowerCase())) == null) continue;
            ++renderTypeCount;
            Block blockInstance = blockInstances.get(autoReg.name());
            if (blockInstance == null) {
                ModernLifeCommon.LOGGER.error("blockInstance was null for " + autoReg.name());
                continue;
            }
            ItemBlockRenderTypes.setRenderLayer((Block)blockInstance, (RenderType)renderType);
        }
        ModernLifeCommon.LOGGER.debug("Set " + renderTypeCount + " render types");
    }
}

