/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui.chess;

import com.dairymoose.modernlife.blocks.gui.chess.ChessScreen;
import com.dairymoose.modernlife.blocks.gui.chess.KingPiece;
import net.minecraft.client.gui.components.Button;

public abstract class Piece {
    public int x;
    public int y;
    int initialX = -1;
    int initialY = -1;
    Button button;
    ChessScreen screen;
    boolean black;
    boolean top;
    boolean ignoreCheckRules = false;

    protected Piece() {
    }

    public Piece withXy(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public abstract int getId();

    protected boolean isOutOfBounds(int x, int y) {
        block7: {
            block6: {
                block5: {
                    block4: {
                        if (x < 0) break block4;
                        if (x < 8) break block5;
                    }
                    return true;
                }
                if (y < 0) break block6;
                if (y < 8) break block7;
            }
            return true;
        }
        return false;
    }

    protected boolean wouldCollide(int x, int y) {
        if (this.isOutOfBounds(x, y)) {
            return true;
        }
        if (this.x == x && this.y == y) {
            return true;
        }
        int currentX = this.x;
        int currentY = this.y;
        while (true) {
            Piece p;
            int moveY;
            int xDiff = x - currentX;
            int yDiff = y - currentY;
            int moveX = xDiff == 0 ? 0 : xDiff / Math.abs(xDiff);
            int n = moveY = yDiff == 0 ? 0 : yDiff / Math.abs(yDiff);
            if (currentX == x && currentY == y) {
                return false;
            }
            if ((currentX != this.x || currentY != this.y) && this.screen != null && (p = this.screen.getPieceAt(currentX, currentY)) != null) {
                return true;
            }
            currentX += moveX;
            currentY += moveY;
        }
    }

    public void absMoveTo(int x, int y) {
        this.button.m_252865_(this.screen.boardXtoScreenX(x));
        this.button.m_253211_(this.screen.boardYtoScreenY(y));
        this.x = x;
        this.y = y;
    }

    private boolean wouldPutKingInCheck(int x, int y, KingPiece king) {
        int thisOriginalX = this.x;
        int thisOriginalY = this.y;
        int pOriginalX = -1;
        int pOriginalY = -1;
        Piece p = this.screen.getPieceAt(x, y);
        if (p != null) {
            pOriginalX = p.x;
            pOriginalY = p.y;
            if (this.black != p.black) {
                p.x = -1;
                p.y = -1;
            }
        }
        this.x = x;
        this.y = y;
        boolean kingInCheck = king.inCheck();
        if (p != null) {
            p.x = pOriginalX;
            p.y = pOriginalY;
        }
        this.x = thisOriginalX;
        this.y = thisOriginalY;
        return kingInCheck;
    }

    private boolean internalDoMove(int x, int y, boolean simulate) {
        if (this.isOutOfBounds(x, y)) {
            return false;
        }
        if (!this.ignoreCheckRules && (this.black ? this.wouldPutKingInCheck(x, y, this.screen.blackKing) : this.wouldPutKingInCheck(x, y, this.screen.whiteKing))) {
            return false;
        }
        if (this.screen != null) {
            Piece p = this.screen.getPieceAt(x, y);
            if (p != null) {
                if (this.black == !p.black) {
                    if (!simulate) {
                        this.kill(p);
                    }
                } else {
                    return false;
                }
            }
            if (!simulate) {
                this.absMoveTo(x, y);
            }
        }
        return true;
    }

    protected boolean doMove(int x, int y) {
        return this.internalDoMove(x, y, false);
    }

    protected boolean canDoMove(int x, int y) {
        return this.internalDoMove(x, y, true);
    }

    public boolean move(int x, int y) {
        if (this.canMove(x, y)) {
            return this.doMove(x, y);
        }
        return false;
    }

    public abstract boolean canMove(int var1, int var2);

    public void kill(Piece piece) {
        piece.remove();
    }

    public void remove() {
        this.button.f_93623_ = false;
        this.button.f_93624_ = false;
        this.x = -1;
        this.y = -1;
        if (this.screen != null) {
            if (this.black) {
                this.screen.blackPieces.remove(this);
            } else {
                this.screen.whitePieces.remove(this);
            }
        }
    }
}

