/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui;

import com.dairymoose.modernlife.blocks.gui.HPoint;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartEaselPacket;
import com.dairymoose.modernlife.util.CanvasData;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EaselScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CANVAS_UI = new ResourceLocation("modernlife", "textures/gui/canvas_ui.png");
    private static final ResourceLocation COLOR_PICKER_UI = new ResourceLocation("modernlife", "textures/gui/ui_color_picker.png");
    final int GUI_WIDTH = 256;
    final int GUI_HEIGHT = 216;
    private final int CANVAS_AREA_WIDTH = 128;
    private final int CANVAS_AREA_HEIGHT = 128;
    private Level world = null;
    private BlockPos pos = null;
    private static ImageButton pencil = null;
    private static ImageButton paintbrush = null;
    private static ImageButton line = null;
    private static ImageButton bucket = null;
    private static ImageButton colorPicker = null;
    private static ImageButton undo = null;
    private static ImageButton cancel = null;
    private static ImageButton accept = null;
    List<List<Integer>> colorRowRgbs;
    private int colorRgb = 0;
    private int colorRgbLeft = 0;
    private int colorRgbRight = 0;
    private int lastMouseButton = 0;
    private double H = -1.0;
    private double S = 0.0;
    private double V = 1.0;
    CanvasData canvasData = new CanvasData();
    Deque<CanvasData> undoStack = new LinkedList<CanvasData>();
    private boolean dragStart = false;
    int dragStartX = -1;
    int dragStartY = -1;
    int lastX = -1;
    int lastY = -1;
    private DynamicTexture texture = null;
    private TextureManager textureManager = Minecraft.m_91087_().m_91097_();
    private ResourceLocation dynamicTextureResource = null;
    private boolean firstRender = true;
    private BlockPos easelPos = null;
    private long introTimestamp;
    private final int UNDO_STACK_MAX_SIZE = 10;

    public EaselScreen(Level world, BlockPos easelBlock) {
        super((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Canvas")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x404040))));
        this.world = world;
        this.pos = easelBlock;
        this.introTimestamp = System.currentTimeMillis();
        this.colorRowRgbs = new ArrayList<List<Integer>>();
        ArrayList<Integer> rgbRow = new ArrayList<Integer>();
        rgbRow.add(13152666);
        rgbRow.add(0x790000);
        rgbRow.add(10422798);
        rgbRow.add(15604517);
        rgbRow.add(16017996);
        rgbRow.add(16160633);
        rgbRow.add(15604517);
        rgbRow.add(0xFF0000);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(10127476);
        rgbRow.add(8072704);
        rgbRow.add(10568204);
        rgbRow.add(16082463);
        rgbRow.add(16289878);
        rgbRow.add(16559489);
        rgbRow.add(16512000);
        rgbRow.add(0xFFFF00);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(7561815);
        rgbRow.add(8210432);
        rgbRow.add(10838281);
        rgbRow.add(16356635);
        rgbRow.add(16560477);
        rgbRow.add(16697228);
        rgbRow.add(42574);
        rgbRow.add(65280);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(5457729);
        rgbRow.add(8682496);
        rgbRow.add(11378944);
        rgbRow.add(16775017);
        rgbRow.add(16775322);
        rgbRow.add(16775322);
        rgbRow.add(45549);
        rgbRow.add(65535);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(3551277);
        rgbRow.add(4154648);
        rgbRow.add(5867303);
        rgbRow.add(9422910);
        rgbRow.add(11326578);
        rgbRow.add(12771228);
        rgbRow.add(2896020);
        rgbRow.add(255);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(12885100);
        rgbRow.add(89379);
        rgbRow.add(1735216);
        rgbRow.add(3716935);
        rgbRow.add(8176757);
        rgbRow.add(10605725);
        rgbRow.add(15597709);
        rgbRow.add(16515325);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(10910546);
        rgbRow.add(23330);
        rgbRow.add(28982);
        rgbRow.add(42574);
        rgbRow.add(3913592);
        rgbRow.add(8768156);
        rgbRow.add(0x8B8B8B);
        rgbRow.add(0xFFFFFF);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(9265721);
        rgbRow.add(22608);
        rgbRow.add(29546);
        rgbRow.add(43677);
        rgbRow.add(1817268);
        rgbRow.add(8113864);
        rgbRow.add(0x7C7C7C);
        rgbRow.add(0xEBEBEB);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(7686948);
        rgbRow.add(22914);
        rgbRow.add(30372);
        rgbRow.add(45806);
        rgbRow.add(48116);
        rgbRow.add(7262711);
        rgbRow.add(0x717171);
        rgbRow.add(0xE1E2E2);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(6371347);
        rgbRow.add(144743);
        rgbRow.add(19837);
        rgbRow.add(29117);
        rgbRow.add(4361676);
        rgbRow.add(8169946);
        rgbRow.add(0x636363);
        rgbRow.add(0xD7D7D7);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(0x464646);
        rgbRow.add(8533);
        rgbRow.add(13674);
        rgbRow.add(21929);
        rgbRow.add(5600441);
        rgbRow.add(8754636);
        rgbRow.add(0x535353);
        rgbRow.add(0xCDCDCD);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(0x464646);
        rgbRow.add(786507);
        rgbRow.add(1840227);
        rgbRow.add(2896020);
        rgbRow.add(6315177);
        rgbRow.add(9077695);
        rgbRow.add(0x464646);
        rgbRow.add(0xC3C3C3);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(0x464646);
        rgbRow.add(3145801);
        rgbRow.add(4525921);
        rgbRow.add(6630290);
        rgbRow.add(8806312);
        rgbRow.add(10520768);
        rgbRow.add(0x363636);
        rgbRow.add(0xB7B7B7);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(0x464646);
        rgbRow.add(4915273);
        rgbRow.add(6489183);
        rgbRow.add(9578129);
        rgbRow.add(10838946);
        rgbRow.add(0xBB8CBC);
        rgbRow.add(0x252525);
        rgbRow.add(0xADADAD);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(0x464646);
        rgbRow.add(7929926);
        rgbRow.add(10485853);
        rgbRow.add(15597709);
        rgbRow.add(15888042);
        rgbRow.add(16162243);
        rgbRow.add(987664);
        rgbRow.add(0xA1A1A0);
        this.colorRowRgbs.add(rgbRow);
        rgbRow = new ArrayList();
        rgbRow.add(0x464646);
        rgbRow.add(7929895);
        rgbRow.add(10420280);
        rgbRow.add(15733595);
        rgbRow.add(15953018);
        rgbRow.add(16226462);
        rgbRow.add(0);
        rgbRow.add(9868692);
        this.colorRowRgbs.add(rgbRow);
    }

    public void setTextureSize(int w, int h) {
        if (w > 0 && h > 0) {
            this.canvasData.setTextureSize(w, h);
        }
    }

    public void setInitialData(byte[] initialData) {
        if (initialData != null) {
            this.canvasData.fromCompressedNbt(initialData);
        }
    }

    public void setBlockPos(BlockPos easelPos) {
        this.easelPos = easelPos;
    }

    public boolean blendColorIntoCanvas(int rgb, int pickedX, int pickedY, double blendFactor) {
        if (pickedX >= this.canvasData.textureWidth() || pickedY >= this.canvasData.textureHeight() || pickedX < 0 || pickedY < 0) {
            return false;
        }
        int newRgb = this.canvasData.applyBlend(rgb, this.canvasData.getRgbPixel(pickedX, pickedY), blendFactor);
        this.canvasData.setRgbPixel(pickedX, pickedY, newRgb);
        this.texture.m_117991_().m_84988_(pickedX, pickedY, this.canvasData.getRgbOutputPixel(pickedX, pickedY));
        return true;
    }

    public List<HPoint> lineTo(int fromX, int fromY, int toX, int toY) {
        ArrayList<HPoint> output = new ArrayList<HPoint>();
        output.add(new HPoint(fromX, fromY));
        int newX = fromX;
        int newY = fromY;
        int iterCount = 0;
        int fnX = 1;
        int xDiff = toX - fromX;
        int yDiff = -(toY - fromY);
        boolean inverted = false;
        if (Math.abs(yDiff) > Math.abs(xDiff)) {
            int xDiffTemp = xDiff;
            xDiff = yDiff;
            yDiff = xDiffTemp;
            inverted = true;
        }
        int nIterations = Math.abs(xDiff);
        int direction = 0;
        direction = xDiff > 0 ? 1 : -1;
        double angle = Math.atan((double)yDiff / (double)xDiff);
        if (Math.toDegrees(angle) == 90.0) {
            return output;
        }
        for (int i = 0; i < nIterations && ++iterCount < 1000; ++i) {
            int yValue = (int)Math.round(Math.tan(angle) * (double)fnX);
            if (!inverted) {
                newX = fromX + fnX * direction;
                newY = fromY - yValue * direction;
            }
            if (inverted) {
                newX = fromX + yValue * direction;
                newY = fromY - fnX * direction;
            }
            newX = Math.max(newX, 0);
            newX = Math.min(newX, this.canvasData.textureWidth() - 1);
            newY = Math.max(newY, 0);
            newY = Math.min(newY, this.canvasData.textureHeight() - 1);
            output.add(new HPoint(newX, newY));
            ++fnX;
        }
        return output;
    }

    boolean pointIsValid(HPoint point) {
        int x = point.x;
        int y = point.y;
        return x >= 0 && x < this.canvasData.textureWidth() && y >= 0 && y < this.canvasData.textureHeight();
    }

    void iterativeFloodFill(int newRgb, int originalRgb, int startX, int startY) {
        int x = startX;
        int y = startY;
        float loadFactor = 0.75f;
        HashSet<HPoint> visited = new HashSet<HPoint>((int)(4097.0f / loadFactor) + 1, loadFactor);
        LinkedList<HPoint> toVisit = new LinkedList<HPoint>();
        HPoint firstPoint = new HPoint(x, y);
        visited.add(firstPoint);
        toVisit.add(firstPoint);
        int visitCount = 0;
        while (!toVisit.isEmpty()) {
            HPoint down;
            HPoint up;
            HPoint left;
            int currentRgb;
            ++visitCount;
            HPoint current = (HPoint)toVisit.remove();
            x = current.x;
            y = current.y;
            if (!this.pointIsValid(current) || (currentRgb = this.canvasData.getRgbPixel(x, y)) != originalRgb) continue;
            this.blendColorIntoCanvas(newRgb, x, y, 1.0);
            HPoint right = new HPoint(x + 1, y);
            if (this.pointIsValid(right) && !visited.contains(right)) {
                visited.add(right);
                toVisit.add(right);
            }
            if (this.pointIsValid(left = new HPoint(x - 1, y)) && !visited.contains(left)) {
                visited.add(left);
                toVisit.add(left);
            }
            if (this.pointIsValid(up = new HPoint(x, y - 1)) && !visited.contains(up)) {
                visited.add(up);
                toVisit.add(up);
            }
            if (!this.pointIsValid(down = new HPoint(x, y + 1)) || visited.contains(down)) continue;
            visited.add(down);
            toVisit.add(down);
        }
    }

    public void assignHsvFromRgb() {
        Boolean extendedColorPicker = (Boolean)ModernLifeConfig.CLIENT.extendedEaselColorPicker.get();
        if (extendedColorPicker != null && extendedColorPicker.booleanValue()) {
            double dR = (double)CanvasData.getRValue(this.colorRgb) / 255.0;
            double dG = (double)CanvasData.getGValue(this.colorRgb) / 255.0;
            double dB = (double)CanvasData.getBValue(this.colorRgb) / 255.0;
            boolean rMax = false;
            boolean gMax = false;
            boolean bMax = false;
            if (dR >= dG && dR >= dB) {
                rMax = true;
            } else if (dG >= dR && dG >= dB) {
                gMax = true;
            } else if (dB >= dR && dB >= dG) {
                bMax = true;
            }
            double cMax = Math.max(Math.max(dR, dG), dB);
            double cMin = Math.min(Math.min(dR, dG), dB);
            double delta = cMax - cMin;
            if (delta == 0.0) {
                this.H = 0.0;
            } else if (rMax) {
                this.H = 60.0 * ((dG - dB) / delta % 6.0);
            } else if (gMax) {
                this.H = 60.0 * ((dB - dR) / delta + 2.0);
            } else if (bMax) {
                this.H = 60.0 * ((dR - dG) / delta + 4.0);
            }
            this.H %= 360.0;
            if (this.H < 0.0) {
                this.H += 360.0;
            }
            ModernLifeCommon.LOGGER.debug("H = " + this.H);
            this.S = cMax == 0.0 ? 0.0 : delta / cMax;
            this.V = cMax;
        } else {
            this.H = -1.0;
        }
    }

    public void assignRgbFromHsv(int mouseButton) {
        double C = this.V * this.S;
        double X = C * (1.0 - Math.abs(this.H / 60.0 % 2.0 - 1.0));
        double m = this.V - C;
        double dR = 0.0;
        double dG = 0.0;
        double dB = 0.0;
        if (this.H >= 0.0 && this.H < 60.0) {
            dR = C;
            dG = X;
            dB = 0.0;
        } else if (this.H < 120.0) {
            dR = X;
            dG = C;
            dB = 0.0;
        } else if (this.H < 180.0) {
            dR = 0.0;
            dG = C;
            dB = X;
        } else if (this.H < 240.0) {
            dR = 0.0;
            dG = X;
            dB = C;
        } else if (this.H < 300.0) {
            dR = X;
            dG = 0.0;
            dB = C;
        } else {
            dR = C;
            dG = 0.0;
            dB = X;
        }
        int r = (int)((dR + m) * 255.0);
        int g = (int)((dG + m) * 255.0);
        int b = (int)((dB + m) * 255.0);
        if (mouseButton == 0) {
            this.colorRgbLeft = CanvasData.toRgb(r, g, b);
        } else if (mouseButton == 1) {
            this.colorRgbRight = CanvasData.toRgb(r, g, b);
        }
    }

    public void handleMouseEvent(double clickX, double clickY, boolean mouseDown, int mouseButton) {
        if (this.texture == null || !this.canvasData.isValid()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        long timeDiff = timestamp - this.introTimestamp;
        if (timeDiff <= 350L) {
            return;
        }
        int uiStartX = (this.f_96543_ - 256) / 2;
        int uiStartY = (this.f_96544_ - 216) / 2;
        if (clickX > (double)uiStartX + 7.0 && clickX < (double)uiStartX + 62.0 && clickY > (double)uiStartY + 21.0 && clickY < (double)uiStartY + 127.0) {
            Integer rgb;
            List<Integer> rgbRow;
            int colorPickerWidth = 53;
            int colorPickerHeight = 105;
            int pickerRows = 16;
            int pickerColumns = 8;
            double cellWidth = (double)colorPickerWidth / (double)pickerColumns;
            double cellHeight = (double)colorPickerHeight / (double)pickerRows;
            double yOffsetInPicker = clickY - ((double)uiStartY + 21.0);
            double xOffsetInPicker = clickX - ((double)uiStartX + 7.0);
            int pickedColumn = (int)(yOffsetInPicker / cellHeight);
            int pickedRow = (int)(xOffsetInPicker / cellWidth);
            if (pickedColumn < this.colorRowRgbs.size() && (rgbRow = this.colorRowRgbs.get(pickedColumn)) != null && pickedRow < rgbRow.size() && (rgb = rgbRow.get(pickedRow)) != null) {
                if (mouseButton == 0) {
                    this.colorRgbLeft = rgb;
                } else if (mouseButton == 1) {
                    this.colorRgbRight = rgb;
                }
                this.assignHsvFromRgb();
            }
        }
        if (mouseButton == 0) {
            this.colorRgb = this.colorRgbLeft;
        } else if (mouseButton == 1) {
            this.colorRgb = this.colorRgbRight;
        }
        Boolean extendedColorPicker = (Boolean)ModernLifeConfig.CLIENT.extendedEaselColorPicker.get();
        if (extendedColorPicker != null && extendedColorPicker.booleanValue()) {
            int margin = 2;
            if (clickX > (double)(this.xStartColorPicker() - margin) && clickX < (double)(this.xStartColorPicker() + this.colorPickerWidth() + margin) && clickY > (double)(this.yStartColorPicker() - margin) && clickY < (double)(this.yStartColorPicker() + this.colorPickerHeight() + margin)) {
                double pickerX = clickX - (double)this.xStartColorPicker();
                double pickerY = clickY - (double)this.yStartColorPicker();
                double xPercent = pickerX / (double)this.colorPickerWidth();
                double yPercent = pickerY / (double)this.colorPickerHeight();
                if (xPercent < 0.0) {
                    xPercent = 0.0;
                } else if (xPercent > 1.0) {
                    xPercent = 1.0;
                }
                if (yPercent < 0.0) {
                    yPercent = 0.0;
                }
                if (yPercent > 1.0) {
                    yPercent = 1.0;
                }
                yPercent = 1.0 - yPercent;
                this.H = xPercent * 360.0;
                this.S = yPercent;
                this.assignRgbFromHsv(mouseButton);
            }
        }
        if (clickX > (double)uiStartX + 94.0 && clickX < (double)uiStartX + 223.0 && clickY > (double)uiStartY + 25.0 && clickY < (double)uiStartY + 154.0) {
            int canvasWidth = this.canvasAspectedWidth();
            int canvasHeight = this.canvasAspectedHeight();
            int canvasMaxX = this.canvasData.textureWidth();
            int canvaxMaxY = this.canvasData.textureHeight();
            double cellWidth = (double)canvasWidth / (double)canvasMaxX;
            double cellHeight = (double)canvasHeight / (double)canvaxMaxY;
            double yOffsetInCanvas = clickY - ((double)uiStartY + 25.0);
            double xOffsetInCanvas = clickX - ((double)uiStartX + 94.0);
            int pickedY = (int)(yOffsetInCanvas / cellHeight);
            int pickedX = (int)(xOffsetInCanvas / cellWidth);
            if (!(pickedX >= this.canvasData.textureWidth() || pickedY >= this.canvasData.textureHeight() || mouseDown && pickedX == this.lastX && pickedY == this.lastY)) {
                if (!this.dragStart && this.m_7282_()) {
                    if (this.undoStack.size() >= 10) {
                        this.undoStack.removeLast();
                    }
                    CanvasData undoData = new CanvasData();
                    undoData.copyDataFrom(this.canvasData);
                    this.undoStack.push(undoData);
                    this.dragStart = true;
                    this.dragStartX = pickedX;
                    this.dragStartY = pickedY;
                }
                if (pencil.m_93696_()) {
                    this.blendColorIntoCanvas(this.colorRgb, pickedX, pickedY, 1.0);
                    this.texture.m_117985_();
                } else if (paintbrush.m_93696_() && mouseDown) {
                    this.blendColorIntoCanvas(this.colorRgb, pickedX, pickedY, 0.8);
                    this.blendColorIntoCanvas(this.colorRgb, pickedX + 1, pickedY, 0.3125);
                    this.blendColorIntoCanvas(this.colorRgb, pickedX - 1, pickedY, 0.3125);
                    this.blendColorIntoCanvas(this.colorRgb, pickedX, pickedY + 1, 0.3125);
                    this.blendColorIntoCanvas(this.colorRgb, pickedX, pickedY - 1, 0.3125);
                    this.blendColorIntoCanvas(this.colorRgb, pickedX + 1, pickedY + 1, 0.04);
                    this.blendColorIntoCanvas(this.colorRgb, pickedX - 1, pickedY + 1, 0.04);
                    this.blendColorIntoCanvas(this.colorRgb, pickedX - 1, pickedY - 1, 0.04);
                    this.blendColorIntoCanvas(this.colorRgb, pickedX + 1, pickedY - 1, 0.04);
                    this.texture.m_117985_();
                } else if (line.m_93696_()) {
                    ModernLifeCommon.LOGGER.debug("line focus");
                    if (this.dragStart || !this.m_7282_()) {
                        if (this.dragStart && this.m_7282_()) {
                            EaselScreen.updateTexture(this.canvasData, this.texture);
                            linePixels = this.lineTo(this.dragStartX, this.dragStartY, pickedX, pickedY);
                            for (int i = 0; i < linePixels.size(); ++i) {
                                HPoint HPoint2 = linePixels.get(i);
                                this.texture.m_117991_().m_84988_(HPoint2.x, HPoint2.y, this.canvasData.convertToRgbOutput(this.colorRgb));
                            }
                            this.texture.m_117985_();
                        } else if (this.dragStart && !this.m_7282_()) {
                            linePixels = this.lineTo(this.dragStartX, this.dragStartY, pickedX, pickedY);
                            for (int i = 0; i < linePixels.size(); ++i) {
                                HPoint HPoint3 = linePixels.get(i);
                                this.blendColorIntoCanvas(this.colorRgb, HPoint3.x, HPoint3.y, 1.0);
                            }
                            this.texture.m_117985_();
                        }
                    }
                } else if (bucket.m_93696_()) {
                    this.iterativeFloodFill(this.colorRgb, this.canvasData.getRgbPixel(pickedX, pickedY), pickedX, pickedY);
                    this.texture.m_117985_();
                } else if (colorPicker.m_93696_() && mouseDown) {
                    if (mouseButton == 0) {
                        this.colorRgbLeft = this.canvasData.getRgbPixel(pickedX, pickedY);
                    } else if (mouseButton == 1) {
                        this.colorRgbRight = this.canvasData.getRgbPixel(pickedX, pickedY);
                    }
                    this.assignHsvFromRgb();
                }
                if (this.dragStart && !this.m_7282_()) {
                    ModernLifeCommon.LOGGER.debug("drag end");
                    this.dragStart = false;
                    this.dragStartX = -1;
                    this.dragStartY = -1;
                }
            }
            if (mouseDown) {
                this.lastX = pickedX;
                this.lastY = pickedY;
            } else {
                this.lastX = -1;
                this.lastY = -1;
            }
        }
        this.lastMouseButton = mouseButton;
    }

    public boolean m_7979_(double dragX, double dragY, int mouseButton, double p_231045_6_, double p_231045_8_) {
        if (mouseButton == 0 || mouseButton == 1) {
            this.handleMouseEvent(dragX, dragY, true, mouseButton);
        }
        return super.m_7979_(dragX, dragY, mouseButton, p_231045_6_, p_231045_8_);
    }

    public boolean m_6375_(double clickX, double clickY, int mouseButton) {
        if (mouseButton == 0 || mouseButton == 1) {
            this.m_7897_(true);
            this.handleMouseEvent(clickX, clickY, true, mouseButton);
        }
        return super.m_6375_(clickX, clickY, mouseButton);
    }

    public boolean m_6348_(double clickX, double clickY, int mouseButton) {
        this.m_7897_(false);
        if (mouseButton == 0 || mouseButton == 1) {
            this.handleMouseEvent(clickX, clickY, false, mouseButton);
        }
        return super.m_6348_(clickX, clickY, mouseButton);
    }

    public static void unfocusAll() {
        if (pencil != null && pencil.m_93696_()) {
            pencil.m_93692_(false);
        }
        if (paintbrush != null && paintbrush.m_93696_()) {
            paintbrush.m_93692_(false);
        }
        if (line != null && line.m_93696_()) {
            line.m_93692_(false);
        }
        if (bucket != null && bucket.m_93696_()) {
            bucket.m_93692_(false);
        }
        if (colorPicker != null && colorPicker.m_93696_()) {
            colorPicker.m_93692_(false);
        }
    }

    public boolean m_7933_(int key, int p_231046_2_, int p_231046_3_) {
        if (key == 80) {
            pencil.m_5691_();
            return false;
        }
        if (key == 66) {
            paintbrush.m_5691_();
            return false;
        }
        if (key == 76) {
            line.m_5691_();
            return false;
        }
        if (key == 70) {
            bucket.m_5691_();
            return false;
        }
        if (key == 67) {
            colorPicker.m_5691_();
            return false;
        }
        if (key == 90) {
            if (this.m_96637_()) {
                undo.m_5691_();
                return false;
            }
        }
        return super.m_7933_(key, p_231046_2_, p_231046_3_);
    }

    protected void m_7856_() {
        int startX = (this.f_96543_ - 256) / 2 + 77;
        int startY = (this.f_96544_ - 216) / 2 + 164;
        pencil = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX, startY, 20, 18, 0, 219, 19, CANVAS_UI, new Button.OnPress(){

            public void m_93750_(Button button) {
                EaselScreen.unfocusAll();
                button.m_93692_(true);
            }
        }));
        paintbrush = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX + 22, startY, 20, 18, 21, 219, 19, CANVAS_UI, new Button.OnPress(){

            public void m_93750_(Button button) {
                EaselScreen.unfocusAll();
                button.m_93692_(true);
            }
        }));
        line = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX + 44, startY, 20, 18, 42, 219, 19, CANVAS_UI, new Button.OnPress(){

            public void m_93750_(Button button) {
                EaselScreen.unfocusAll();
                button.m_93692_(true);
            }
        }));
        bucket = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX + 66, startY, 20, 18, 63, 219, 19, CANVAS_UI, new Button.OnPress(){

            public void m_93750_(Button button) {
                EaselScreen.unfocusAll();
                button.m_93692_(true);
            }
        }));
        colorPicker = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX + 88, startY, 20, 18, 84, 219, 19, CANVAS_UI, new Button.OnPress(){

            public void m_93750_(Button button) {
                EaselScreen.unfocusAll();
                button.m_93692_(true);
            }
        }));
        undo = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX + 110, startY, 20, 18, 105, 219, 19, CANVAS_UI, new Button.OnPress(){

            public void m_93750_(Button button) {
                CanvasData undoData;
                if (!EaselScreen.this.undoStack.isEmpty() && (undoData = EaselScreen.this.undoStack.pop()).isValid()) {
                    EaselScreen.this.canvasData.copyDataFrom(undoData);
                    EaselScreen.updateTexture(EaselScreen.this.canvasData, EaselScreen.this.texture);
                }
            }
        }));
        cancel = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX + 132, startY, 20, 18, 126, 219, 19, CANVAS_UI, new Button.OnPress(){

            public void m_93750_(Button button) {
                Minecraft.m_91087_().m_91152_(null);
            }
        }));
        accept = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX + 154, startY, 20, 18, 147, 219, 19, CANVAS_UI, new Button.OnPress(){

            public void m_93750_(Button button) {
                if (EaselScreen.this.easelPos != null) {
                    int MAX_IMAGE_PART = 30000;
                    byte[] compressed = EaselScreen.this.canvasData.toCompressedNbt();
                    ArrayList<byte[]> parts = new ArrayList<byte[]>();
                    int i = 0;
                    while ((double)i < Math.ceil((float)compressed.length / (float)MAX_IMAGE_PART)) {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        int startIndex = i * MAX_IMAGE_PART;
                        int bytesToWrite = Math.min(compressed.length - startIndex, MAX_IMAGE_PART);
                        stream.write(compressed, startIndex, bytesToWrite);
                        byte[] part = stream.toByteArray();
                        parts.add(part);
                        ++i;
                    }
                    for (i = 0; i < parts.size(); ++i) {
                        int seqNo = i + 1;
                        boolean last = false;
                        if (seqNo == parts.size()) {
                            last = true;
                        }
                        ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundMultipartEaselPacket(seqNo, last, (byte[])parts.get(i), EaselScreen.this.canvasData.textureWidth(), EaselScreen.this.canvasData.textureHeight(), EaselScreen.this.easelPos));
                    }
                }
                Minecraft.m_91087_().m_91152_(null);
            }
        }));
        pencil.m_93692_(true);
    }

    public static void updateTexture(CanvasData canvasData, DynamicTexture texture) {
        if (!canvasData.isValid()) {
            return;
        }
        for (int i = 0; i < canvasData.textureHeight(); ++i) {
            for (int j = 0; j < canvasData.textureWidth(); ++j) {
                if (texture == null || texture.m_117991_() == null || !canvasData.isValid()) continue;
                try {
                    texture.m_117991_().m_84988_(j, i, canvasData.getRgbOutputPixel(j, i));
                    continue;
                }
                catch (IllegalStateException e) {
                    ModernLifeCommon.LOGGER.warn("Unallocated image error");
                }
            }
        }
        try {
            if (texture != null && canvasData.isValid()) {
                texture.m_117985_();
            }
        }
        catch (IllegalStateException e) {
            ModernLifeCommon.LOGGER.warn("Unallocated image error");
        }
    }

    public static void updateTextureDownsampled(CanvasData canvasData, DynamicTexture texture, int newSize) {
        if (!canvasData.isValid()) {
            return;
        }
        int ratio = canvasData.textureWidth() / newSize;
        for (int i = 0; i < newSize; ++i) {
            for (int j = 0; j < newSize; ++j) {
                int sampleX = j * ratio;
                int sampleY = i * ratio;
                texture.m_117991_().m_84988_(j, i, canvasData.getRgbOutputPixel(sampleX, sampleY));
            }
        }
        texture.m_117985_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void drawCenteredStringNoShadow(GuiGraphics graphics, Font font, Component p_238472_2_, int p_238472_3_, int p_238472_4_, int p_238472_5_) {
        FormattedCharSequence lvt_6_1_ = p_238472_2_.m_7532_();
        graphics.drawString(font, lvt_6_1_, (float)(p_238472_3_ - font.m_92724_(lvt_6_1_) / 2), (float)p_238472_4_, p_238472_5_, false);
    }

    public boolean m_6050_(double a, double b, double c) {
        Boolean extendedColorPicker = (Boolean)ModernLifeConfig.CLIENT.extendedEaselColorPicker.get();
        if (extendedColorPicker != null && extendedColorPicker.booleanValue()) {
            this.V = c > 0.0 ? (this.m_96638_() ? (this.V += 0.01) : (this.V += 0.1)) : (this.m_96638_() ? (this.V -= 0.01) : (this.V -= 0.1));
            if (this.V > 1.0) {
                this.V = 1.0;
            }
            if (this.V < 0.0) {
                this.V = 0.0;
            }
            this.assignRgbFromHsv(this.lastMouseButton);
        }
        return super.m_6050_(a, b, c);
    }

    public void m_88315_(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_280273_(graphics);
        if (this.firstRender) {
            this.firstRender = false;
            this.canvasData.initImage();
            if (this.texture == null) {
                this.texture = new DynamicTexture(this.canvasData.textureWidth(), this.canvasData.textureHeight(), true);
                this.dynamicTextureResource = this.textureManager.m_118490_("artpad/dyn", this.texture);
                EaselScreen.updateTexture(this.canvasData, this.texture);
            }
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CANVAS_UI);
        int xStart = (this.f_96543_ - 256) / 2;
        int yStart = (this.f_96544_ - 216) / 2;
        graphics.m_280218_(CANVAS_UI, xStart, yStart, 0, 0, 256, 216);
        int r = CanvasData.getRValue(this.colorRgbLeft);
        int g = CanvasData.getGValue(this.colorRgbLeft);
        int b = CanvasData.getBValue(this.colorRgbLeft);
        float fR = (float)r / 255.0f;
        float fG = (float)g / 255.0f;
        float fB = (float)b / 255.0f;
        RenderSystem.setShaderColor((float)fR, (float)fG, (float)fB, (float)1.0f);
        graphics.m_280218_(CANVAS_UI, xStart + 39, yStart + 135, 39, 135, 9, 9);
        int r2 = CanvasData.getRValue(this.colorRgbRight);
        int g2 = CanvasData.getGValue(this.colorRgbRight);
        int b2 = CanvasData.getBValue(this.colorRgbRight);
        float fR2 = (float)r2 / 255.0f;
        float fG2 = (float)g2 / 255.0f;
        float fB2 = (float)b2 / 255.0f;
        RenderSystem.setShaderColor((float)fR2, (float)fG2, (float)fB2, (float)1.0f);
        graphics.m_280218_(CANVAS_UI, xStart + 52, yStart + 135, 52, 135, 9, 9);
        if (this.dynamicTextureResource != null) {
            int canvasHeight;
            float xTexStart = 0.0f;
            float xTexDiff = 0.0f;
            int canvasWidth = this.canvasAspectedWidth();
            if (canvasWidth != (canvasHeight = this.canvasAspectedHeight())) {
                graphics.m_280509_(xStart + 94, yStart + 25, xStart + 94 + 128, yStart + 25 + 128, -16777216);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280163_(this.dynamicTextureResource, xStart + 94, yStart + 25, xTexStart, xTexDiff, canvasWidth, canvasHeight, canvasWidth, canvasHeight);
        }
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, this.f_96539_, xStart + 128, yStart + 2, 0);
        for (GuiEventListener gw : this.m_6702_()) {
            AbstractWidget w;
            if (!(gw instanceof AbstractWidget) || !(w = (AbstractWidget)gw).m_198029_() || w.m_93696_()) continue;
            String text = "";
            if (w == pencil) {
                text = "Pencil (P)";
            } else if (w == paintbrush) {
                text = "Paintbrush (B)";
            } else if (w == line) {
                text = "Line (L)";
            } else if (w == bucket) {
                text = "Bucket (F)";
            } else if (w == colorPicker) {
                text = "Color Picker (C)";
            } else if (w == undo) {
                text = "Undo (Ctrl+Z)";
            } else if (w == cancel) {
                text = "Cancel";
            } else if (w == accept) {
                text = "Accept";
            }
            if (text.isEmpty()) continue;
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(text)), w.m_252754_(), w.m_252907_());
        }
        Boolean extendedColorPicker = (Boolean)ModernLifeConfig.CLIENT.extendedEaselColorPicker.get();
        if (extendedColorPicker != null && extendedColorPicker.booleanValue()) {
            int COLOR_PICKER_WIDTH = this.colorPickerWidth();
            int COLOR_PICKER_HEIGHT = this.colorPickerHeight();
            int xStartColorPicker = this.xStartColorPicker();
            int yStartColorPicker = this.yStartColorPicker();
            float xTexStart = 0.0f;
            float xTexDiff = 0.0f;
            graphics.m_280163_(COLOR_PICKER_UI, xStartColorPicker, yStartColorPicker, xTexStart, xTexDiff, COLOR_PICKER_WIDTH, COLOR_PICKER_HEIGHT, COLOR_PICKER_WIDTH, COLOR_PICKER_HEIGHT);
            String rgbText = "R" + r + " G" + g + " B" + b;
            this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(rgbText)), xStart + 128, (int)((double)yStart + 205.2), 0);
            if (this.H >= 0.0) {
                double sText = this.S * 100.0;
                double vText = this.V * 100.0;
                String hsvText = String.format("H%.1f S%.1f V%.0f", this.H, sText, vText);
                this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(hsvText)), xStart + 128, (int)((double)yStart + 194.4), 0);
                String scrollHintText = "(scroll wheel adjusts V)";
                this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(scrollHintText)), xStart + 128, (int)((double)yStart + 183.6), 0);
            }
        }
        super.m_88315_(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    public int xStartColorPicker() {
        return (this.f_96543_ - 256) / 2 + 5;
    }

    public int yStartColorPicker() {
        return (this.f_96544_ - 216) / 2 + 147;
    }

    public float getAspectRatio() {
        return (float)this.canvasData.textureWidth() / (float)this.canvasData.textureHeight();
    }

    public int canvasAspectedWidth() {
        if (this.canvasData.textureWidth() < this.canvasData.textureHeight()) {
            return (int)(128.0f * this.getAspectRatio());
        }
        return 128;
    }

    public int canvasAspectedHeight() {
        if (this.canvasData.textureHeight() < this.canvasData.textureWidth()) {
            return (int)(128.0f * (1.0f / this.getAspectRatio()));
        }
        return 128;
    }

    public int colorPickerWidth() {
        return 60;
    }

    public int colorPickerHeight() {
        return 60;
    }
}

