/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.PavedRoadBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RampBlock
extends Block {
    protected static final VoxelShape SHAPE_WEST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)13.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)11.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)10.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)9.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)7.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)6.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)}).m_83296_();
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_EAST_CORNER = Stream.of(Block.m_49796_((double)-0.75, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.5, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)15.0), Block.m_49796_((double)1.5, (double)2.0, (double)0.0, (double)16.0, (double)3.0, (double)14.0), Block.m_49796_((double)2.5, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)13.0), Block.m_49796_((double)3.5, (double)4.0, (double)0.0, (double)16.0, (double)5.0, (double)12.0), Block.m_49796_((double)4.5, (double)5.0, (double)0.0, (double)16.0, (double)6.0, (double)11.0), Block.m_49796_((double)5.5, (double)6.0, (double)0.0, (double)16.0, (double)7.0, (double)10.0), Block.m_49796_((double)6.5, (double)7.0, (double)0.0, (double)16.0, (double)8.0, (double)9.0), Block.m_49796_((double)7.5, (double)8.0, (double)0.0, (double)16.0, (double)9.0, (double)8.0), Block.m_49796_((double)8.5, (double)9.0, (double)0.0, (double)16.0, (double)10.0, (double)7.0), Block.m_49796_((double)9.5, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)6.0), Block.m_49796_((double)10.5, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)5.0), Block.m_49796_((double)11.5, (double)12.0, (double)0.0, (double)16.0, (double)13.0, (double)4.0), Block.m_49796_((double)12.5, (double)13.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), Block.m_49796_((double)13.5, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_SOUTH_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST_CORNER);
    protected static final VoxelShape SHAPE_WEST_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_CORNER);
    protected static final VoxelShape SHAPE_NORTH_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_CORNER);
    protected static final Map<Direction, VoxelShape> SHAPE_MAP;
    protected static final Map<Direction, VoxelShape> SHAPE_MAP_CORNER;
    public static final EnumProperty<Direction> FACING;
    public static final EnumProperty<PartType> PART;

    public RampBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60978_(1.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.EAST)).m_61124_(PART, (Comparable)((Object)PartType.straight)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 5;
        }
        return 0;
    }

    public RampBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.EAST));
    }

    public void m_141947_(Level p_176199_1_, BlockPos p_176199_2_, BlockState state, Entity entity) {
        if (p_176199_1_.m_8055_(p_176199_2_).m_60713_((Block)CustomBlocks.BLOCK_PAVED_ROAD_RAMP.get())) {
            PavedRoadBlock.steppedOn(entity);
        }
    }

    public boolean m_7923_(BlockState p_220074_1_) {
        return true;
    }

    private boolean isOpposite(BlockState first, BlockState second) {
        return first.m_60734_() == second.m_60734_() && first.m_61143_(PART) == second.m_61143_(PART) && first.m_61143_(FACING) == ((Direction)second.m_61143_(FACING)).m_122424_();
    }

    private BlockState setPartType(LevelAccessor world, BlockState state, BlockPos pos) {
        BlockState nRamp = world.m_8055_(pos.m_121945_(Direction.NORTH));
        BlockState eRamp = world.m_8055_(pos.m_121945_(Direction.EAST));
        BlockState sRamp = world.m_8055_(pos.m_121945_(Direction.SOUTH));
        BlockState wRamp = world.m_8055_(pos.m_121945_(Direction.WEST));
        boolean hasNramp = nRamp.m_60713_((Block)this);
        boolean hasEramp = eRamp.m_60713_((Block)this);
        boolean hasSramp = sRamp.m_60713_((Block)this);
        boolean hasWramp = wRamp.m_60713_((Block)this);
        int adjacentRampCount = (hasNramp ? 1 : 0) + (hasEramp ? 1 : 0) + (hasSramp ? 1 : 0) + (hasWramp ? 1 : 0);
        BlockState forwardState = world.m_8055_(pos.m_121945_((Direction)state.m_61143_(FACING)));
        if (adjacentRampCount >= 2) {
            if (hasSramp && hasWramp && !this.isOpposite(state, forwardState)) {
                state = (BlockState)state.m_61124_(PART, (Comparable)((Object)PartType.corner));
                state = (BlockState)state.m_61124_(FACING, (Comparable)Direction.WEST);
            } else if (hasSramp && hasEramp && !this.isOpposite(state, forwardState)) {
                state = (BlockState)state.m_61124_(PART, (Comparable)((Object)PartType.corner));
                state = (BlockState)state.m_61124_(FACING, (Comparable)Direction.SOUTH);
            } else if (hasNramp && hasWramp && !this.isOpposite(state, forwardState)) {
                state = (BlockState)state.m_61124_(PART, (Comparable)((Object)PartType.corner));
                state = (BlockState)state.m_61124_(FACING, (Comparable)Direction.NORTH);
            } else if (hasNramp && hasEramp && !this.isOpposite(state, forwardState)) {
                state = (BlockState)state.m_61124_(PART, (Comparable)((Object)PartType.corner));
                state = (BlockState)state.m_61124_(FACING, (Comparable)Direction.EAST);
            }
        } else {
            if (state.m_61143_(PART) == PartType.corner) {
                boolean cornerAdjustment = false;
                if (hasNramp && nRamp.m_61143_(PART) == PartType.corner) {
                    cornerAdjustment = true;
                    state = nRamp.m_61143_(FACING) == Direction.WEST ? (BlockState)state.m_61124_(FACING, (Comparable)Direction.WEST) : (BlockState)state.m_61124_(FACING, (Comparable)Direction.EAST);
                }
                if (hasEramp && eRamp.m_61143_(PART) == PartType.corner) {
                    cornerAdjustment = true;
                    state = eRamp.m_61143_(FACING) == Direction.NORTH ? (BlockState)state.m_61124_(FACING, (Comparable)Direction.NORTH) : (BlockState)state.m_61124_(FACING, (Comparable)Direction.SOUTH);
                }
                if (hasSramp && sRamp.m_61143_(PART) == PartType.corner) {
                    cornerAdjustment = true;
                    state = sRamp.m_61143_(FACING) == Direction.EAST ? (BlockState)state.m_61124_(FACING, (Comparable)Direction.EAST) : (BlockState)state.m_61124_(FACING, (Comparable)Direction.WEST);
                }
                if (hasWramp && wRamp.m_61143_(PART) == PartType.corner) {
                    cornerAdjustment = true;
                    state = wRamp.m_61143_(FACING) == Direction.EAST ? (BlockState)state.m_61124_(FACING, (Comparable)Direction.NORTH) : (BlockState)state.m_61124_(FACING, (Comparable)Direction.SOUTH);
                }
                if (!cornerAdjustment) {
                    if (hasNramp) {
                        state = (BlockState)state.m_61124_(FACING, (Comparable)((Direction)nRamp.m_61143_(FACING)));
                    }
                    if (hasEramp) {
                        state = (BlockState)state.m_61124_(FACING, (Comparable)((Direction)eRamp.m_61143_(FACING)));
                    }
                    if (hasSramp) {
                        state = (BlockState)state.m_61124_(FACING, (Comparable)((Direction)sRamp.m_61143_(FACING)));
                    }
                    if (hasWramp) {
                        state = (BlockState)state.m_61124_(FACING, (Comparable)((Direction)wRamp.m_61143_(FACING)));
                    }
                }
            }
            state = (BlockState)state.m_61124_(PART, (Comparable)((Object)PartType.straight));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        return this.setPartType(world, state, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        if (p_220053_1_.m_61143_(PART) == PartType.corner) {
            VoxelShape result = SHAPE_MAP_CORNER.get(p_220053_1_.m_61143_(FACING));
            return result == null ? SHAPE_EAST_CORNER : result;
        }
        VoxelShape result = SHAPE_MAP.get(p_220053_1_.m_61143_(FACING));
        return result == null ? SHAPE_EAST : result;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.setPartType((LevelAccessor)context.m_43725_(), (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_()), context.m_8083_());
    }

    static {
        HashMap<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();
        shapes.put(Direction.EAST, SHAPE_EAST);
        shapes.put(Direction.SOUTH, SHAPE_SOUTH);
        shapes.put(Direction.WEST, SHAPE_WEST);
        shapes.put(Direction.NORTH, SHAPE_NORTH);
        SHAPE_MAP = Collections.unmodifiableMap(shapes);
        shapes = new HashMap();
        shapes.put(Direction.EAST, SHAPE_EAST_CORNER);
        shapes.put(Direction.SOUTH, SHAPE_SOUTH_CORNER);
        shapes.put(Direction.WEST, SHAPE_WEST_CORNER);
        shapes.put(Direction.NORTH, SHAPE_NORTH_CORNER);
        SHAPE_MAP_CORNER = Collections.unmodifiableMap(shapes);
        FACING = BlockStateProperties.f_61374_;
        PART = EnumProperty.m_61587_((String)"part", PartType.class);
    }

    public static enum PartType implements StringRepresentable
    {
        straight,
        corner;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

