/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.core.CsvSourcedHashSet;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.tileentities.ModernBookshelfBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModernBookshelfBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    public static long usedBookTimestamp = 0L;
    public static int oldItemSlot = -1;
    public static BlockPos lastBlockPos = null;
    public static CsvSourcedHashSet whitelist;
    public static CsvSourcedHashSet blacklist;
    public static CsvSourcedHashSet textToSearch;
    public static CsvSourcedHashSet textToAvoid;
    public static ItemStack clientAwaitingBook;
    public static final DirectionProperty FACING;

    public ModernBookshelfBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 5;
        }
        return 0;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return 2.0f;
    }

    private boolean textToSearchHasMatch(String toSearch) {
        for (String s : textToSearch) {
            if (!toSearch.contains(s)) continue;
            return true;
        }
        return false;
    }

    private boolean textToAvoidHasMatch(String toSearch) {
        for (String s : textToAvoid) {
            if (!toSearch.contains(s)) continue;
            return true;
        }
        return false;
    }

    private void getBookFromSlot(Player player, ModernBookshelfBlockEntity modernBookshelfBlockEntity, int slot) {
        player.m_36356_(modernBookshelfBlockEntity.m_8020_(slot).m_41777_());
        modernBookshelfBlockEntity.m_6836_(slot, ItemStack.f_41583_);
        modernBookshelfBlockEntity.m_6596_();
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        ItemStack itemStack = player.m_21120_(hand);
        BlockEntity tileEntity = world.m_7702_(blockPos);
        ModernBookshelfBlockEntity modernBookshelfBlockEntity = null;
        if (tileEntity instanceof ModernBookshelfBlockEntity) {
            modernBookshelfBlockEntity = (ModernBookshelfBlockEntity)tileEntity;
        }
        boolean tookItem = false;
        boolean placedItem = false;
        if (whitelist == null) {
            whitelist = new CsvSourcedHashSet((String)ModernLifeConfig.COMMON.bookshelfWhitelist.get());
        }
        if (blacklist == null) {
            blacklist = new CsvSourcedHashSet((String)ModernLifeConfig.COMMON.bookshelfBlacklist.get());
        }
        if (textToSearch == null) {
            textToSearch = new CsvSourcedHashSet((String)ModernLifeConfig.COMMON.bookshelfSearchText.get());
        }
        if (textToAvoid == null) {
            textToAvoid = new CsvSourcedHashSet((String)ModernLifeConfig.COMMON.bookshelfAvoidText.get());
        }
        if (modernBookshelfBlockEntity != null) {
            if (!player.m_20161_() && !itemStack.m_41619_()) {
                String displayName = itemStack.m_41611_().getString().toLowerCase();
                String registryNamespace = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).m_135827_();
                String registryPath = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).m_135815_();
                String registryPathLowercase = registryPath.toLowerCase();
                String fullRegistryText = registryNamespace + ":" + registryPath;
                boolean itemIsWhitelisted = false;
                boolean itemIsBlacklisted = false;
                if (blacklist.contains(fullRegistryText)) {
                    itemIsBlacklisted = true;
                }
                if (whitelist.contains(fullRegistryText)) {
                    itemIsWhitelisted = true;
                }
                if (!modernBookshelfBlockEntity.isFull()) {
                    if (itemIsBlacklisted) {
                        placedItem = false;
                    } else {
                        boolean itemMatchesSearchCondition;
                        boolean bl = itemMatchesSearchCondition = (this.textToSearchHasMatch(displayName) || this.textToSearchHasMatch(registryPathLowercase)) && !this.textToAvoidHasMatch(displayName) && !this.textToAvoidHasMatch(registryPathLowercase);
                        if (itemIsWhitelisted || itemMatchesSearchCondition) {
                            placedItem = true;
                        }
                        if (placedItem && !world.f_46443_) {
                            ItemStack oneItem = itemStack.m_41620_(1);
                            modernBookshelfBlockEntity.placeItem(oneItem);
                            placedItem = true;
                            modernBookshelfBlockEntity.m_6596_();
                        }
                    }
                }
            } else if (player.m_20161_() && !modernBookshelfBlockEntity.m_7983_()) {
                int slot;
                tookItem = true;
                int hitIndex = modernBookshelfBlockEntity.getHitIndex(player, (HitResult)rayTrace);
                if (hitIndex != -1) {
                    this.getBookFromSlot(player, modernBookshelfBlockEntity, hitIndex);
                } else if (!world.f_46443_ && (slot = modernBookshelfBlockEntity.getNextOccupiedSlot()) != -1) {
                    this.getBookFromSlot(player, modernBookshelfBlockEntity, slot);
                }
            }
            if (!placedItem && !tookItem && rayTrace != null) {
                ItemStack pickedBook;
                oldItemSlot = -1;
                int hitIndex = modernBookshelfBlockEntity.getHitIndex(player, (HitResult)rayTrace);
                if (hitIndex != -1 && !(pickedBook = modernBookshelfBlockEntity.m_8020_(hitIndex)).m_41619_()) {
                    ItemStack originalItem = null;
                    originalItem = player.m_21120_(hand);
                    int freeSlot = player.m_150109_().m_36062_();
                    if (freeSlot != -1) {
                        usedBookTimestamp = System.currentTimeMillis();
                        modernBookshelfBlockEntity.m_6836_(hitIndex, ItemStack.f_41583_);
                        modernBookshelfBlockEntity.bookNames.set(hitIndex, (Object)"");
                        oldItemSlot = freeSlot;
                        lastBlockPos = blockPos;
                        if (!world.f_46443_) {
                            player.m_21008_(hand, pickedBook);
                            player.m_36356_(originalItem);
                            try {
                                pickedBook.m_41682_(world, player, hand);
                            }
                            catch (Exception e) {
                                ModernLifeCommon.LOGGER.error("Use book error", (Throwable)e);
                            }
                        } else {
                            clientAwaitingBook = pickedBook;
                        }
                    }
                }
            }
        }
        if (!world.f_46443_) {
            world.m_7260_(blockPos, blockState, blockState, 2);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.m_60713_(p_196243_4_.m_60734_())) {
            BlockEntity lvt_6_1_ = p_196243_2_.m_7702_(p_196243_3_);
            if (lvt_6_1_ instanceof ModernBookshelfBlockEntity) {
                Containers.m_19002_((Level)p_196243_2_, (BlockPos)p_196243_3_, (Container)((ModernBookshelfBlockEntity)lvt_6_1_));
                p_196243_2_.m_46717_(p_196243_3_, (Block)this);
            }
            super.m_6810_(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Right click to place a book on the shelf")));
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Shift-right-click with an empty hand to remove a book")));
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        return ((Direction)p_196271_1_.m_61143_((Property)FACING)).m_122424_() == p_196271_2_ && !p_196271_1_.m_60710_((LevelReader)p_196271_4_, p_196271_5_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        ModernBookshelfBlockEntity toReturn = (ModernBookshelfBlockEntity)ModernBookshelfBlockEntity.MODERN_BOOKSHELF.m_155264_(pos, state);
        return toReturn;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return FaceAttachedHorizontalDirectionalBlock.m_53196_((LevelReader)p_196260_2_, (BlockPos)p_196260_3_, (Direction)((Direction)p_196260_1_.m_61143_((Property)FACING)).m_122424_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction lvt_5_1_ : context.m_6232_()) {
            BlockState lvt_6_2_;
            if (lvt_5_1_.m_122434_() == Direction.Axis.Y || !(lvt_6_2_ = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)lvt_5_1_.m_122424_())).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return lvt_6_2_;
        }
        return this.m_49966_();
    }

    static {
        clientAwaitingBook = null;
        FACING = BlockStateProperties.f_61374_;
    }
}

