/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.MirrorBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MirrorBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public MirrorBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level p_225533_2_, BlockPos p_225533_3_, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        BlockEntity tileEntity;
        if (p_225533_1_.m_60713_((Block)CustomBlocks.BLOCK_CCTV_SCREEN.get()) && (tileEntity = p_225533_2_.m_7702_(p_225533_3_)) instanceof MirrorBlockEntity) {
            MirrorBlockEntity mirrorBlockEntity = (MirrorBlockEntity)tileEntity;
            mirrorBlockEntity.cctvScreenCurrentCamera = p_225533_4_.m_20161_() ? --mirrorBlockEntity.cctvScreenCurrentCamera : ++mirrorBlockEntity.cctvScreenCurrentCamera;
            if (!p_225533_2_.f_46443_) {
                ((ServerLevel)p_225533_2_).m_7260_(p_225533_3_, p_225533_1_, p_225533_1_, 2);
                mirrorBlockEntity.m_6596_();
            }
        }
        return InteractionResult.CONSUME;
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return FaceAttachedHorizontalDirectionalBlock.m_53196_((LevelReader)p_196260_2_, (BlockPos)p_196260_3_, (Direction)((Direction)p_196260_1_.m_61143_((Property)FACING)).m_122424_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction lvt_5_1_ : context.m_6232_()) {
            BlockState lvt_6_2_;
            if (lvt_5_1_.m_122434_() == Direction.Axis.Y || !(lvt_6_2_ = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)lvt_5_1_.m_122424_())).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return lvt_6_2_;
        }
        return this.m_49966_();
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        return ((Direction)p_196271_1_.m_61143_((Property)FACING)).m_122424_() == p_196271_2_ && !p_196271_1_.m_60710_((LevelReader)p_196271_4_, p_196271_5_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        MirrorBlockEntity toReturn = (MirrorBlockEntity)MirrorBlockEntity.MIRROR.m_155264_(pos, state);
        return toReturn;
    }
}

