/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.StandardHorizontalBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.MicrowaveBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MicrowaveBlock
extends StandardHorizontalBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)10.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    public static final BooleanProperty OPEN_DOOR = BooleanProperty.m_61465_((String)"open_door");

    public MicrowaveBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)OPEN_DOOR, (Comparable)Boolean.valueOf(false)));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ModernLifeUtil.createTickerHelper(type, MicrowaveBlockEntity.MICROWAVE, MicrowaveBlockEntity::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        MicrowaveBlockEntity toReturn = (MicrowaveBlockEntity)MicrowaveBlockEntity.MICROWAVE.m_155264_(pos, state);
        return toReturn;
    }

    public void m_6810_(BlockState newBlockState, Level world, BlockPos pos, BlockState oldBlockState, boolean b) {
        if (!newBlockState.m_60713_(oldBlockState.m_60734_())) {
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof MicrowaveBlockEntity) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((MicrowaveBlockEntity)tileEntity));
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(newBlockState, world, pos, oldBlockState, b);
        }
    }

    public static int calculateTime(Optional<CampfireCookingRecipe> optionalCookingRecipe) {
        if (optionalCookingRecipe.isPresent()) {
            return optionalCookingRecipe.get().m_43753_() / 9;
        }
        return 0;
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!world.f_46443_) {
            if (blockState.m_60713_((Block)CustomBlocks.BLOCK_MICROWAVE.get()) && !((Boolean)blockState.m_61143_((Property)OPEN_DOOR)).booleanValue()) {
                world.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)OPEN_DOOR, (Comparable)Boolean.valueOf(true)));
            } else {
                boolean tookItem = false;
                ItemStack itemStack = player.m_21120_(hand);
                if (!itemStack.m_41619_()) {
                    BlockEntity tileEntity;
                    Optional optional = world.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), world);
                    if (optional.isPresent() && (tileEntity = world.m_7702_(blockPos)) instanceof MicrowaveBlockEntity) {
                        MicrowaveBlockEntity microwaveBlockEntity = (MicrowaveBlockEntity)tileEntity;
                        if (microwaveBlockEntity.m_7983_()) {
                            ItemStack oneItem = itemStack.m_41620_(1);
                            microwaveBlockEntity.cookItem(oneItem, MicrowaveBlock.calculateTime(optional));
                        }
                        microwaveBlockEntity.m_6596_();
                    }
                } else {
                    BlockEntity tileEntity = world.m_7702_(blockPos);
                    if (tileEntity instanceof MicrowaveBlockEntity) {
                        MicrowaveBlockEntity microwaveBlockEntity = (MicrowaveBlockEntity)tileEntity;
                        if (!microwaveBlockEntity.m_7983_() && player.m_20161_()) {
                            tookItem = true;
                            player.m_36356_(microwaveBlockEntity.m_8020_(0).m_41777_());
                            microwaveBlockEntity.m_6836_(0, ItemStack.f_41583_);
                        }
                        microwaveBlockEntity.m_6596_();
                    }
                }
                if (!tookItem) {
                    world.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)OPEN_DOOR, (Comparable)Boolean.valueOf(false)));
                }
                world.m_7260_(blockPos, blockState, blockState, 2);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, OPEN_DOOR});
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_());
    }
}

