/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.entity;

import com.dairymoose.entity.RenderableBlock;
import com.dairymoose.modernlife.blocks.gui.HBlockPos;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DummyEntity
extends Entity {
    public static final EntityType<DummyEntity> DUMMY_ENTITY = EntityType.Builder.m_20704_(DummyEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.0f, 0.0f).m_20712_(new ResourceLocation("modernlife", "dummy").toString());
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Float> DATA_ID_RIDE_HEIGHT = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public List<RenderableBlock> renderables = new ArrayList<RenderableBlock>();

    public DummyEntity(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public boolean isEntityStandingOnSolidGround(Entity e) {
        for (RenderableBlock renderable : this.renderables) {
            BlockPos dummyPos = this.m_20183_();
            double x = (double)dummyPos.m_123341_() + renderable.relativeX;
            double y = (double)dummyPos.m_123342_() + renderable.relativeY;
            double z = (double)dummyPos.m_123343_() + renderable.relativeZ;
            int blockX = (int)x;
            int blockY = (int)y;
            int blockZ = (int)z;
            HBlockPos renderablePos = new HBlockPos(blockX, 0, blockZ);
            HBlockPos entityPos = new HBlockPos(e.m_20183_().m_123341_(), 0, e.m_20183_().m_123343_());
            if (!renderable.state.m_60638_((BlockGetter)this.m_9236_(), (BlockPos)renderablePos, e, Direction.UP) || !renderablePos.equals((Object)entityPos) || !(e.m_20275_(x, y, z) <= 2.25)) continue;
            return true;
        }
        return false;
    }

    public Vec3 getEntitySolidGround(Entity e) {
        for (RenderableBlock renderable : this.renderables) {
            double yDiff;
            Vec3 dummyPos = this.m_20182_();
            double x = dummyPos.f_82479_ + renderable.relativeX;
            double y = dummyPos.f_82480_ + renderable.relativeY;
            double z = dummyPos.f_82481_ + renderable.relativeZ;
            int blockX = (int)x;
            int blockY = (int)y;
            int blockZ = (int)z;
            HBlockPos renderablePos = new HBlockPos(blockX, 0, blockZ);
            HBlockPos entityPos = new HBlockPos(e.m_20183_().m_123341_(), 0, e.m_20183_().m_123343_());
            if (!renderable.state.m_60638_((BlockGetter)this.m_9236_(), (BlockPos)entityPos, e, Direction.UP) || !renderablePos.equals((Object)entityPos) || !((yDiff = e.m_20186_() - y) > 0.0) || !(yDiff <= 1.0)) continue;
            return new Vec3(x, y + 1.0, z);
        }
        return null;
    }

    public boolean isEntityColliding(Entity e) {
        for (RenderableBlock renderable : this.renderables) {
            double zDiff;
            double xDiff;
            double horizontalDistSqr;
            Vec3 dummyPos = this.m_20182_();
            double x = dummyPos.f_82479_ + renderable.relativeX;
            double y = dummyPos.f_82480_ + renderable.relativeY;
            double z = dummyPos.f_82481_ + renderable.relativeZ;
            int blockX = (int)x;
            int blockY = (int)y;
            int blockZ = (int)z;
            HBlockPos renderablePos = new HBlockPos(blockX, blockY, blockZ);
            HBlockPos entityPos = new HBlockPos(e.m_20183_().m_123341_(), e.m_20183_().m_123342_(), e.m_20183_().m_123343_());
            VoxelShape collisionShape = renderable.state.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)renderablePos);
            AABB collisionBB = null;
            if (!collisionShape.m_83281_()) {
                collisionBB = collisionShape.m_83215_().m_82386_(x - 0.5, y, z - 0.5);
            }
            AABB entityBB = e.m_20191_();
            entityBB = entityBB.m_82386_(0.0, 0.13, 0.0);
            if (e instanceof Player) {
                Player player = (Player)e;
            }
            if (collisionBB == null || !collisionBB.m_82381_(entityBB) || !(e.m_20186_() + 0.13 >= y) || !((horizontalDistSqr = (xDiff = e.m_20185_() - x) * xDiff + (zDiff = e.m_20189_() - z) * zDiff) <= 1.44)) continue;
            renderable.state = Blocks.f_50493_.m_49966_();
            return true;
        }
        return false;
    }

    public float m_6143_() {
        return 500.0f;
    }

    public Vec3 m_7371_(float p_241842_1_) {
        Vec3 superPos = super.m_7371_(p_241842_1_);
        return new Vec3(superPos.f_82479_, superPos.f_82480_, superPos.f_82481_);
    }

    public Vec3 m_7688_(LivingEntity p_230268_1_) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        return super.m_7688_(p_230268_1_);
    }

    public double m_6048_() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_RIDE_HEIGHT)).floatValue();
    }

    public static DummyEntity getEntity(float rideHeight, Level world, BlockPos pos, boolean oppositeFacing) {
        List dummies = world.m_142425_(DUMMY_ENTITY, new AABB(pos), e -> true);
        if (!dummies.isEmpty()) {
            ModernLifeCommon.LOGGER.debug("Found dummy");
            return (DummyEntity)((Object)dummies.get(0));
        }
        ModernLifeCommon.LOGGER.debug("New dummy");
        DummyEntity dummy = (DummyEntity)DUMMY_ENTITY.m_20615_(world);
        dummy.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        dummy.setRideHeight(rideHeight);
        BlockState state = world.m_8055_(pos);
        if (state.m_61145_((Property)BlockStateProperties.f_61374_).isPresent()) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            if (oppositeFacing) {
                facing = facing.m_122424_();
            }
            dummy.m_146922_(facing.m_122435_());
        } else {
            dummy.m_146922_(-1.0f);
        }
        if (!world.f_46443_) {
            world.m_7967_((Entity)dummy);
        }
        return dummy;
    }

    public void ride(Player player) {
        if (this.m_146908_() != -1.0f) {
            player.m_146922_(this.m_146908_());
        }
        player.m_20329_((Entity)this);
    }

    public void setRideHeight(float h) {
        this.f_19804_.m_135381_(DATA_ID_RIDE_HEIGHT, (Object)Float.valueOf(h));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_RIDE_HEIGHT, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag var1) {
        this.f_19804_.m_135381_(DATA_ID_RIDE_HEIGHT, (Object)Float.valueOf(var1.m_128457_("RideHeight")));
    }

    public void m_7380_(CompoundTag var1) {
        var1.m_128350_("RideHeight", ((Float)this.f_19804_.m_135370_(DATA_ID_RIDE_HEIGHT)).floatValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

