/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.entity;

import com.dairymoose.entity.BicycleEntity;
import com.dairymoose.entity.BicycleModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class BicycleRenderer
extends EntityRenderer<BicycleEntity> {
    private float modelScale = 1.0f;
    private final BicycleModel bicycleModel;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation texture = new ResourceLocation("modernlife", "textures/item/bicycle_uv.png");

    public BicycleRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.bicycleModel = new BicycleModel(ctx.m_174023_(BicycleModel.BICYCLE));
    }

    public boolean shouldRender(BicycleEntity p_225626_1_, Frustum p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        return true;
    }

    public void render(BicycleEntity bicycleEntity, float angle, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int p_225623_6_) {
        float t;
        float calcSpeed = 0.0f;
        Vec3 pos = bicycleEntity.m_20182_();
        if (bicycleEntity.lastRenderPos != null && (double)(t = (float)(System.currentTimeMillis() - bicycleEntity.lastRenderTime) / 1000.0f) >= 0.05) {
            pos = new Vec3(pos.f_82479_, 0.0, pos.f_82481_);
            bicycleEntity.lastRenderPos = new Vec3(bicycleEntity.lastRenderPos.f_82479_, 0.0, bicycleEntity.lastRenderPos.f_82481_);
            float distSqr = (float)pos.m_82557_(bicycleEntity.lastRenderPos);
            float dist = Mth.m_14116_((float)distSqr);
            calcSpeed = dist / t;
            float increment = calcSpeed / 15.0f;
            bicycleEntity.renderWheelRot = (bicycleEntity.renderWheelRot + increment) % 360.0f;
            bicycleEntity.lastRenderPos = pos;
            bicycleEntity.lastRenderTime = System.currentTimeMillis();
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 1.5, 0.0);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - angle));
        float lvt_7_1_ = (float)bicycleEntity.getHurtTime() - partialTicks;
        float lvt_8_1_ = bicycleEntity.getDamage() - partialTicks;
        if (lvt_8_1_ < 0.0f) {
            lvt_8_1_ = 0.0f;
        }
        if (lvt_7_1_ > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)lvt_7_1_) * lvt_7_1_ * lvt_8_1_ / 10.0f * (float)bicycleEntity.getHurtDir()));
        }
        matrixStack.m_85841_(-this.modelScale, -this.modelScale, this.modelScale);
        this.bicycleModel.setupAnim(bicycleEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer builder = buffer.m_6299_(this.bicycleModel.m_103119_(this.getTextureLocation(bicycleEntity)));
        this.bicycleModel.renderToBufferWithRotation(bicycleEntity.renderWheelRot, matrixStack, builder, p_225623_6_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        if (bicycleEntity.lastRenderPos == null) {
            bicycleEntity.lastRenderPos = pos;
            bicycleEntity.lastRenderTime = System.currentTimeMillis();
        }
        super.m_7392_((Entity)bicycleEntity, angle, partialTicks, matrixStack, buffer, p_225623_6_);
    }

    public ResourceLocation getTextureLocation(BicycleEntity var1) {
        return texture;
    }
}

