/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.init.ModTags;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class FleshTendonFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60734_() == BOPBlocks.ROSE_QUARTZ_CLUSTER || world.m_8055_(pos).m_60734_() == BOPBlocks.LARGE_ROSE_QUARTZ_BUD || world.m_8055_(pos).m_60734_() == BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD || world.m_8055_(pos).m_60734_() == BOPBlocks.SMALL_ROSE_QUARTZ_BUD || world.m_8055_(pos).m_60734_() == BOPBlocks.FLESH_TENDONS_STRAND || world.m_8055_(pos).m_60734_() == BOPBlocks.FLESH_TENDONS || world.m_8055_(pos).m_60734_() == BOPBlocks.PUS_BUBBLE || world.m_8055_(pos).m_60734_() == BOPBlocks.HAIR || world.m_8055_(pos).m_60734_() == BOPBlocks.EYEBULB || world.m_8055_(pos).m_60734_() == BOPBlocks.BLOOD || world.m_8055_(pos).m_60734_() == Blocks.f_49991_;
    private static final int MIN_DISTANCE = 8;
    private static final int MAX_DISTANCE = 32;
    private static final float MID_POS_MULTIPLIER = 0.9f;
    private static final float TENDON_STEP = 0.005f;

    public FleshTendonFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    private static BlockPos quadratic(float t, BlockPos v0, BlockPos v1, BlockPos v2) {
        float dt = 1.0f - t;
        Vec3 v = new Vec3((double)v0.m_123341_(), (double)v0.m_123342_(), (double)v0.m_123343_()).m_82490_((double)(dt * dt)).m_82549_(new Vec3((double)v1.m_123341_(), (double)v1.m_123342_(), (double)v1.m_123343_()).m_82490_((double)(2.0f * dt * t))).m_82549_(new Vec3((double)v2.m_123341_(), (double)v2.m_123342_(), (double)v2.m_123343_()).m_82490_((double)(t * t)));
        return BlockPos.m_274561_((double)v.f_82479_, (double)v.f_82480_, (double)v.f_82481_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos curPos;
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        int maxY = world.m_141937_() + world.m_141928_() - 1;
        BlockState below = world.m_8055_(pos.m_7495_());
        if (!below.m_204336_(ModTags.Blocks.FLESH)) {
            return false;
        }
        int xOff = rand.m_188503_(64) - 32;
        int zOff = rand.m_188503_(64) - 32;
        int minX = rand.m_188499_() ? 8 : -8;
        int minZ = rand.m_188499_() ? 8 : -8;
        BlockPos endPos = pos.m_7918_(Math.abs(xOff) < 8 ? minX : xOff, pos.m_123342_(), Math.abs(zOff) < 8 ? minZ : zOff);
        while (world.m_46859_(endPos) && endPos.m_123342_() < maxY) {
            endPos = endPos.m_7494_();
        }
        if (endPos.m_123342_() == pos.m_123342_()) {
            return false;
        }
        BlockPos midPos = endPos.m_7918_(0, Mth.m_14143_((float)((float)(-(endPos.m_123342_() - pos.m_123342_())) * 0.9f)), 0);
        for (float d = 0.0f; d < 1.0f && (curPos = FleshTendonFeature.quadratic(d, pos, midPos, endPos)).m_123342_() < maxY; d += 0.005f) {
            BlockState fleshBlock = BOPBlocks.FLESH.m_49966_();
            if (rand.m_188503_(5) == 0) {
                fleshBlock = BOPBlocks.POROUS_FLESH.m_49966_();
            }
            this.setBlock(world, curPos, fleshBlock);
            if (rand.m_188503_(75) == 0) {
                this.generateFleshBall(world, curPos, rand);
            }
            if (rand.m_188503_(4) != 0) continue;
            this.placeFleshTendonColumn(world, rand, curPos.m_7495_());
        }
        return true;
    }

    public boolean generateFleshBall(WorldGenLevel world, BlockPos pos, RandomSource rand) {
        this.setBlock(world, pos, BOPBlocks.POROUS_FLESH.m_49966_());
        this.setBlock(world, pos.m_122012_(), Blocks.f_50701_.m_49966_(), 2);
        this.setBlock(world, pos.m_122019_(), Blocks.f_50701_.m_49966_(), 2);
        this.setBlock(world, pos.m_122029_(), Blocks.f_50701_.m_49966_(), 2);
        this.setBlock(world, pos.m_122024_(), Blocks.f_50701_.m_49966_(), 2);
        this.setBlock(world, pos.m_122012_().m_122024_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_122019_().m_122024_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_122012_().m_122029_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_122019_().m_122029_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_().m_122012_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_().m_122019_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_().m_122029_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7494_().m_122024_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_().m_122012_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_().m_122019_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_().m_122029_(), BOPBlocks.FLESH.m_49966_());
        this.setBlock(world, pos.m_7495_().m_122024_(), BOPBlocks.FLESH.m_49966_());
        this.placeFleshTendonColumn(world, rand, pos.m_6625_(2));
        return true;
    }

    public void placeFleshTendonColumn(WorldGenLevel p_67377_, RandomSource p_67378_, BlockPos p_67379_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        blockpos$mutable.m_122190_((Vec3i)p_67379_);
        int rand = p_67378_.m_188503_(6);
        int minHeight = rand == 0 ? 4 : 1;
        int maxHeight = rand == 0 ? 8 : 4;
        int height = Mth.m_216271_((RandomSource)p_67378_, (int)minHeight, (int)maxHeight);
        if (p_67377_.m_8055_(blockpos$mutable.m_7494_()).m_204336_(ModTags.Blocks.FLESH)) {
            Block fleshCheck;
            for (int i = 0; i <= height && (fleshCheck = p_67377_.m_8055_(blockpos$mutable.m_7495_()).m_60734_()) != BOPBlocks.FLESH_TENDONS && fleshCheck != BOPBlocks.FLESH_TENDONS_STRAND; ++i) {
                if (p_67377_.m_46859_((BlockPos)blockpos$mutable)) {
                    if (i == height || !p_67377_.m_46859_(blockpos$mutable.m_7495_())) {
                        this.setBlock(p_67377_, (BlockPos)blockpos$mutable, BOPBlocks.FLESH_TENDONS.m_49966_(), 2);
                        break;
                    }
                    this.setBlock(p_67377_, (BlockPos)blockpos$mutable, BOPBlocks.FLESH_TENDONS_STRAND.m_49966_(), 2);
                }
                blockpos$mutable.m_122173_(Direction.DOWN);
            }
        }
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.respectsCutoff((WorldGenRegion)world, pos) && this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state, int flags) {
        if (this.respectsCutoff((WorldGenRegion)world, pos) && this.replace.matches(world, pos)) {
            world.m_7731_(pos, state, flags);
            return true;
        }
        return false;
    }

    private boolean respectsCutoff(WorldGenRegion region, BlockPos pos) {
        int i = SectionPos.m_123171_((int)pos.m_123341_());
        int j = SectionPos.m_123171_((int)pos.m_123343_());
        ChunkPos chunkpos = region.m_143488_();
        int k = Math.abs(chunkpos.f_45578_ - i);
        int l = Math.abs(chunkpos.f_45579_ - j);
        return k <= region.f_143481_ && l <= region.f_143481_;
    }
}

