/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.KeyringTooltip;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemKeyring
extends Item {
    private static final String TAG_ITEMS = "Items";
    private final RegistryObject<ItemKey> key;

    public ItemKeyring(RegistryObject<ItemKey> key, Item.Properties properties) {
        super(properties);
        this.key = key;
    }

    public ItemStack getKey() {
        if (this.key == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)this.key.get(), 1);
    }

    public boolean m_142305_(ItemStack targetStack, ItemStack stack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        ItemStack newStack;
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (stack.m_41619_()) {
            ItemKeyring.removeOne(targetStack).ifPresent(s -> access.m_142104_(s));
            if (ItemKeyring.getContents(targetStack).count() == 0L) {
                ItemStack newStack2 = new ItemStack((ItemLike)ModItems.KEYRING.get(), 1);
                newStack2.m_41751_(targetStack.m_41783_());
                slot.m_5852_(newStack2);
            } else {
                ItemStack newStack3 = this.rotateKeyring(targetStack);
                slot.m_5852_(newStack3);
            }
            return true;
        }
        int added = ItemKeyring.add(targetStack, stack);
        stack.m_41774_(added);
        if (targetStack.m_41720_() == ModItems.KEYRING.get() && ItemKeyring.getContents(targetStack).count() > 0L && !(newStack = ItemKeyring.getKeyring(ItemKeyring.getContents(targetStack).findFirst().orElse(ItemStack.f_41583_))).m_41619_()) {
            newStack.m_41751_(targetStack.m_41783_());
            slot.m_5852_(newStack);
        }
        return true;
    }

    public static ItemStack getKeyring(ItemStack item) {
        if (item.m_41619_() || !(item.m_41720_() instanceof ItemKey)) {
            return ItemStack.f_41583_;
        }
        Optional<ItemKeyring> keyring = ModItems.getKeyrings().filter(s -> s.getKey().m_41720_() == item.m_41720_()).findFirst();
        if (!keyring.isPresent()) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)keyring.get(), 1);
    }

    public static int add(ItemStack target, ItemStack item) {
        ListTag list;
        if (item.m_41619_() || !(item.m_41720_() instanceof ItemKey)) {
            return 0;
        }
        CompoundTag tag = target.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            tag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
        }
        if ((list = tag.m_128437_(TAG_ITEMS, 10)).size() >= 64) {
            return 0;
        }
        Optional<CompoundTag> match = ItemKeyring.getMatchingItem(item, list);
        if (match.isPresent()) {
            return 0;
        }
        ItemStack copy = item.m_41777_();
        copy.m_41764_(1);
        CompoundTag entry = new CompoundTag();
        copy.m_41739_(entry);
        list.add(0, (Tag)entry);
        return 1;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack stack, ListTag list) {
        return list.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(t -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)t), (ItemStack)stack)).findFirst();
    }

    private static ItemStack getActiveKey(ItemStack stack, Item item) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            return null;
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).map(ItemStack::m_41712_).filter(t -> ItemStack.m_41656_((ItemStack)t, (ItemStack)new ItemStack((ItemLike)item))).findFirst().orElse(null);
    }

    private static Optional<ItemStack> removeOne(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag first = list.m_128728_(0);
        ItemStack firstStack = ItemStack.m_41712_((CompoundTag)first);
        list.remove(0);
        if (list.isEmpty()) {
            tag.m_128473_(TAG_ITEMS);
        }
        return Optional.of(firstStack);
    }

    private static Stream<ItemStack> getContents(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Stream.empty();
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        return list.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        ItemKeyring.getContents(stack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new KeyringTooltip((NonNullList<ItemStack>)nonnulllist));
    }

    public Component m_7626_(ItemStack stack) {
        if (this.key == null || !this.key.isPresent()) {
            return super.m_7626_(stack);
        }
        ItemStack activeKey = ItemKeyring.getActiveKey(stack, (Item)this.key.get());
        Object subName = activeKey != null ? activeKey.m_41786_() : Component.m_237115_((String)((ItemKey)((Object)this.key.get())).m_5524_());
        MutableComponent name = Component.m_237115_((String)((ItemKeyring)((Object)ModItems.KEYRING.get())).m_5524_());
        return name.m_130946_(" (").m_7220_(subName).m_130946_(")");
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Component m_41466_() {
        return Component.m_237115_((String)(((ItemKeyring)((Object)ModItems.KEYRING.get())).m_5524_() + ".desc"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level world, List<Component> list, TooltipFlag advanced) {
        List<MutableComponent> desc = Arrays.stream(this.m_41466_().getString().split("\n")).map(Component::m_237113_).toList();
        for (MutableComponent component : desc) {
            list.add((Component)component.m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_142023_(ItemEntity entity) {
        ItemUtils.m_150952_((ItemEntity)entity, ItemKeyring.getContents(entity.m_32055_()));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        if (this.key != null && this.key.isPresent()) {
            return ((ItemKey)((Object)this.key.get())).m_6225_(context);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        List<ItemStack> list = ItemKeyring.getContents(stack).toList();
        if (list.isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ItemStack keyring = this.rotateKeyring(stack);
        return InteractionResultHolder.m_19090_((Object)keyring);
    }

    private ItemStack rotateKeyring(ItemStack stack) {
        List<ItemStack> list = ItemKeyring.getContents(stack).toList();
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).m_41720_() != this.key.get()) continue;
            index = i;
            break;
        }
        if (++index >= list.size()) {
            index = 0;
        }
        ItemStack nextItem = list.get(index);
        ItemStack keyring = ItemKeyring.getKeyring(nextItem);
        keyring.m_41751_(stack.m_41783_());
        return keyring;
    }
}

