/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BlockController
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock {
    public BlockController(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Direction blockDir = (Direction)state.m_61143_((Property)f_54117_);
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return InteractionResult.FAIL;
        }
        ItemStack item = player.m_150109_().m_36056_();
        if (!item.m_41619_() && this.toggle(level, pos, player, item.m_41720_())) {
            return InteractionResult.SUCCESS;
        }
        if (blockDir != hit.m_82434_()) {
            return InteractionResult.CONSUME;
        }
        if (!level.f_46443_) {
            if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue() && item.m_41619_()) {
                blockEntity.printDebugInfo();
            }
            blockEntity.interactPutItemsIntoInventory(player);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean toggle(Level world, BlockPos pos, Player player, Item item) {
        if (world.f_46443_ || item == null) {
            return false;
        }
        if (item instanceof ItemKeyring) {
            ItemKeyring keyring = (ItemKeyring)item;
            item = keyring.getKey().m_41720_();
        }
        if (item == ModItems.DRAWER_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.DRAWER);
        } else if (item == ModItems.SHROUD_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.CONCEALMENT);
        } else if (item == ModItems.QUANTIFY_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.QUANTIFY);
        } else {
            return false;
        }
        return true;
    }

    public void toggle(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull EnumKeyType keyType) {
        if (level.f_46443_) {
            return;
        }
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        switch (keyType) {
            case DRAWER: {
                blockEntity.toggleLock(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED, player.m_36316_());
                break;
            }
            case CONCEALMENT: {
                blockEntity.toggleShroud(player.m_36316_());
                break;
            }
            case QUANTIFY: {
                blockEntity.toggleQuantified(player.m_36316_());
            }
        }
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (world.f_46443_) {
            return;
        }
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.updateCache();
        world.m_186460_(pos, (Block)this, 100);
    }

    public BlockEntityController newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BlockEntityController(pos, state);
    }
}

