/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityItemRepository;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.core.Api;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.PlayerEventListener;
import com.jaquadro.minecraft.storagedrawers.core.recipe.AddUpgradeRecipe;
import com.jaquadro.minecraft.storagedrawers.core.recipe.KeyringRecipe;
import com.jaquadro.minecraft.storagedrawers.core.recipe.UpgradeDetachedDrawerRecipe;
import com.jaquadro.minecraft.storagedrawers.integration.TheOneProbe;
import com.jaquadro.minecraft.storagedrawers.network.MessageHandler;
import com.jaquadro.minecraft.storagedrawers.network.PlayerBoolConfigMessage;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="storagedrawers")
public class StorageDrawers {
    public static final String MOD_ID = "storagedrawers";
    public static final Api api = new Api();
    public static Logger log = LogManager.getLogger();
    public static CompTierRegistry compRegistry;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    public static final RegistryObject<RecipeSerializer<AddUpgradeRecipe>> UPGRADE_RECIPE_SERIALIZER;
    public static final RegistryObject<RecipeSerializer<UpgradeDetachedDrawerRecipe>> DETACHED_UPGRADE_RECIPE_SERIALIZER;
    public static final RegistryObject<RecipeSerializer<KeyringRecipe>> KEYRING_RECIPE_SERIALIZER;

    public StorageDrawers() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.spec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.register(bus);
        ModItems.register(bus);
        ModBlockEntities.register(bus);
        ModContainers.register(bus);
        bus.addListener(this::setup);
        bus.addListener(this::onModQueueEvent);
        bus.addListener(this::onModConfigEvent);
        bus.addListener(ModItems::creativeModeTabRegister);
        RECIPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventListener());
    }

    private void setup(FMLCommonSetupEvent event) {
        MessageHandler.init();
        compRegistry = new CompTierRegistry();
        compRegistry.initialize();
    }

    private void onModQueueEvent(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> new TheOneProbe());
    }

    private void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            CommonConfig.setLoaded();
        }
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            ClientConfig.setLoaded();
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (!event.getLevel().m_5776_() || !(event.getEntity() instanceof Player)) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        UUID playerId = Minecraft.m_91087_().f_91074_.m_20148_();
        if (event.getEntity().m_20148_() == playerId) {
            MessageHandler.INSTANCE.sendToServer((Object)new PlayerBoolConfigMessage(playerId.toString(), "invertShift", (Boolean)ClientConfig.GENERAL.invertShift.get()));
            MessageHandler.INSTANCE.sendToServer((Object)new PlayerBoolConfigMessage(playerId.toString(), "invertClick", (Boolean)ClientConfig.GENERAL.invertClick.get()));
        }
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityDrawerGroup.register(event);
        CapabilityItemRepository.register(event);
        CapabilityDrawerAttributes.register(event);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MOD_ID);
        UPGRADE_RECIPE_SERIALIZER = RECIPES.register("add_upgrade", () -> new SimpleCraftingRecipeSerializer(AddUpgradeRecipe::new));
        DETACHED_UPGRADE_RECIPE_SERIALIZER = RECIPES.register("add_detached_upgrade", () -> new SimpleCraftingRecipeSerializer(UpgradeDetachedDrawerRecipe::new));
        KEYRING_RECIPE_SERIALIZER = RECIPES.register("keyring", () -> new SimpleCraftingRecipeSerializer(KeyringRecipe::new));
    }
}

