/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.config;

import com.google.common.collect.Lists;
import de.cheaterpaul.fallingleaves.modcompat.SereneSeasons;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public final ForgeConfigSpec.IntValue leafSize;
    public final ForgeConfigSpec.IntValue leafLifespan;
    public final ForgeConfigSpec.IntValue leafSpawnRate;
    public final ForgeConfigSpec.IntValue coniferLeafSpawnRate;
    public final ForgeConfigSpec.BooleanValue dropFromPlayerPlacedBlocks;
    public final ForgeConfigSpec.IntValue minimumFreeSpaceBelow;
    public final ForgeConfigSpec.BooleanValue disableWind;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> windlessDimension;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        this.leafSize = builder.comment("modifies the size of the leaves").defineInRange("leafSize", 4, 1, 20);
        this.leafLifespan = builder.comment(new String[]{"modifies how long it takes for the leaves to disappear", "Values over 2000 are not recommend"}).defineInRange("leafLifespan", 200, 100, Integer.MAX_VALUE);
        this.leafSpawnRate = builder.comment(new String[]{"modifies the amount of leaves that are spawning", "Values over 10000 are not recommend"}).defineInRange("leafSpawnRate", 10, 0, Integer.MAX_VALUE);
        this.coniferLeafSpawnRate = builder.comment(new String[]{"modifier the amount of leaves are spawning from conifer trees", "Values over 10000 are not recommend"}).defineInRange("coniferLeafSpawnRate", 2, 0, Integer.MAX_VALUE);
        this.dropFromPlayerPlacedBlocks = builder.comment("whether player placed blocks should also drop leaves").define("dropFromPlayerPlacedBlocks", true);
        this.minimumFreeSpaceBelow = builder.comment("how much room below the leaves block is needed for the leaves to spawn").defineInRange("minimumFreeSpaceBelow", 1, 1, 20);
        this.disableWind = builder.comment("disable wind effects").define("disableWind", false);
        this.windlessDimension = builder.comment("windless dimensions").defineList("windlessDimension", (List)Lists.newArrayList((Object[])new String[]{BuiltinDimensionTypes.f_223539_.m_135782_().toString(), BuiltinDimensionTypes.f_223540_.m_135782_().toString()}), string -> string instanceof String && ResourceLocation.m_135820_((String)((String)string)) != null);
        SereneSeasons.registerConfig(builder);
    }
}

