/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntityTilt;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackModel
extends BakedModelWrapper<BakedModel> {
    public TrackModel(BakedModel originalModel) {
        super(originalModel);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        List templateQuads = super.getQuads(state, side, rand, extraData, renderType);
        if (templateQuads.isEmpty()) {
            return templateQuads;
        }
        if (!extraData.has(TrackBlockEntityTilt.ASCENDING_PROPERTY)) {
            return templateQuads;
        }
        double angleIn = (Double)extraData.get(TrackBlockEntityTilt.ASCENDING_PROPERTY);
        double angle = Math.abs(angleIn);
        boolean flip = angleIn < 0.0;
        TrackShape trackShape = (TrackShape)((Object)state.m_61143_(TrackBlock.SHAPE));
        double hAngle = switch (trackShape) {
            case TrackShape.XO -> 0.0;
            case TrackShape.PD -> 45.0;
            case TrackShape.ZO -> 90.0;
            case TrackShape.ND -> 135.0;
            default -> 0.0;
        };
        Vec3 verticalOffset = new Vec3(0.0, -0.25, 0.0);
        Vec3 diagonalRotationPoint = trackShape == TrackShape.ND || trackShape == TrackShape.PD ? new Vec3((double)((Mth.f_13994_ - 1.0f) / 2.0f), 0.0, 0.0) : Vec3.f_82478_;
        UnaryOperator transform = v -> {
            v = v.m_82549_(verticalOffset);
            v = VecHelper.rotateCentered(v, hAngle, Direction.Axis.Y);
            v = v.m_82549_(diagonalRotationPoint);
            v = VecHelper.rotate(v, angle, Direction.Axis.Z);
            v = v.m_82546_(diagonalRotationPoint);
            v = VecHelper.rotateCentered(v, -hAngle + (double)(flip ? 180 : 0), Direction.Axis.Y);
            v = v.m_82546_(verticalOffset);
            return v;
        };
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int i = 0; i < size; ++i) {
            BakedQuad quad = BakedQuadHelper.clone((BakedQuad)templateQuads.get(i));
            int[] vertexData = quad.m_111303_();
            for (int j = 0; j < 4; ++j) {
                BakedQuadHelper.setXYZ(vertexData, j, (Vec3)transform.apply(BakedQuadHelper.getXYZ(vertexData, j)));
            }
            quads.add(quad);
        }
        return quads;
    }
}

