/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience;

import com.simibubi.create.content.fluids.VirtualFluid;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.Nullable;

public class ExperienceFluid
extends VirtualFluid {
    protected final int xpRatio;

    public ExperienceFluid(int xpRatio, ForgeFlowingFluid.Properties properties) {
        super(properties);
        this.xpRatio = xpRatio;
    }

    public ExperienceFluid(ForgeFlowingFluid.Properties properties) {
        this(1, properties);
    }

    public ExperienceOrb convertToOrb(Level level, double x, double y, double z, int fluidAmount) {
        return new ExperienceOrb(level, x, y, z, fluidAmount);
    }

    public void drop(ServerLevel level, Vec3 pos, int fluidAmount) {
        while (fluidAmount > 0) {
            int orbSize = ExperienceOrb.m_20782_((int)fluidAmount);
            fluidAmount -= orbSize;
            if (ExperienceOrb.m_147096_((ServerLevel)level, (Vec3)pos, (int)orbSize)) continue;
            level.m_7967_((Entity)this.convertToOrb((Level)level, pos.f_82479_, pos.f_82480_, pos.f_82481_, orbSize));
        }
    }

    public void awardOrDrop(@Nullable Player player, ServerLevel level, Vec3 pos, Vec3 speed, int amount) {
        ExperienceOrb orb = this.convertToOrb((Level)level, pos.f_82479_, pos.f_82480_, pos.f_82481_, amount);
        if (player == null || MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.PickupXp(player, orb))) {
            if (!ExperienceOrb.m_147096_((ServerLevel)level, (Vec3)pos, (int)orb.f_20770_)) {
                orb.m_20256_(speed);
                level.m_7967_((Entity)orb);
            }
        } else {
            int left = orb.m_147092_(player, orb.f_20770_);
            if (left > 0) {
                player.m_6756_(left);
                this.applyAdditionalEffects((LivingEntity)player, left);
            }
        }
    }

    public void applyAdditionalEffects(LivingEntity entity, int expAmount) {
    }

    public int getXpRatio() {
        return this.xpRatio;
    }
}

