/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Predicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class ModUtils {
    public static float clockHandDegrees(long time, int divisor) {
        return 360.0f / (float)divisor * (float)(time % (long)divisor);
    }

    public static double calcSpeed(double metersPerTick, ESpeedUnit unit) {
        return metersPerTick * 20.0 * unit.getFactor();
    }

    public static MutableComponent calcSpeedString(double metersPerTick, ESpeedUnit unit) {
        return TextUtils.text((String)((int)Math.abs(Math.round(ModUtils.calcSpeed(metersPerTick, unit))) + " " + unit.getUnit()));
    }

    public static int calculateMedian(Queue<Integer> history, int smoothingThreshold, Predicate<Integer> filter) {
        if (history.isEmpty()) {
            return 0;
        }
        LinkedList<Integer> values = new LinkedList<Integer>();
        Iterator iterator = history.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!filter.test(i)) continue;
            values.add(i);
        }
        Collections.sort(values);
        int median = 0;
        if (values.size() % 2 == 0) {
            median = (int)(((double)((Integer)values.get(values.size() / 2)).intValue() + (double)((Integer)values.get(values.size() / 2 + 1)).intValue()) / 2.0);
        }
        int med = median = ((Integer)values.get(values.size() / 2)).intValue();
        return (int)history.stream().mapToInt(x -> x).filter(x -> Math.abs(med - x) <= smoothingThreshold).average().orElse(0.0);
    }

    public static String timeRemainingString(long ticks) {
        StringBuilder sb = new StringBuilder();
        String unpredictable = " ~ ";
        String whitespace = " ";
        if (ticks == -1L || ticks >= 119700L) {
            sb.append(" ");
            sb.append(" ~ ");
        } else if (ticks < 200L) {
            sb.append(Lang.translateDirect((String)"display_source.station_summary.now", (Object[])new Object[0]).getString());
        } else {
            long min = ticks / 1200L;
            long sec = ticks / 20L % 60L;
            if ((sec = (long)(Mth.m_14167_((float)((float)sec / 15.0f)) * 15)) == 60L) {
                ++min;
                sec = 0L;
            }
            sb.append(min > 0L ? Components.literal((String)String.valueOf(min)).getString() : "");
            sb.append(min > 0L ? Lang.translateDirect((String)"display_source.station_summary.minutes", (Object[])new Object[0]).getString() : Lang.translateDirect((String)"display_source.station_summary.seconds", (Object[])new Object[]{sec}).getString());
        }
        return sb.toString();
    }

    public static long generateId(Predicate<Long> exists) {
        long id;
        while (exists.test(id = DragonLib.RANDOM.nextLong())) {
        }
        return id;
    }

    public static String formatTime(long time, boolean asETA) throws RuntimeSideException {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new RuntimeSideException(true);
        }
        if (asETA) {
            return ModUtils.timeRemainingString(time - DragonLib.getCurrentWorldTime());
        }
        return TimeUtils.parseTime((long)((time + 6000L) % 24000L), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
    }
}

