/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.registry;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.NearestTrackStationResult;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.navigation.NavigatableGraph;
import de.mrjulsen.crn.data.navigation.Route;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.NextConnectionsDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.debug.TrainDebugData;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.crn.registry.data.NextConnectionsRequestData;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public final class ModAccessorTypes {
    public static final DataAccessorType<String, StationTag, StationTag> GET_STATION_TAG = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_station_tag"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.m_128365_("Data", (Tag)GlobalSettings.getInstance().getOrCreateStationTagFor((String)in).toNbt());
        return false;
    }, (hasMore, previousData, iteration, nbt) -> StationTag.fromNbt(nbt.m_128469_("Data"), null)));
    public static final DataAccessorType<TagName, StationTag, StationTag> GET_STATION_TAG_BY_TAG_NAME = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_station_tag_by_tag_name"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128359_("Data", in.get()), nbt -> TagName.of(nbt.m_128461_("Data")), (player, in, temp, nbt, iteration) -> {
        nbt.m_128365_("Data", (Tag)GlobalSettings.getInstance().getOrCreateStationTagFor((TagName)in).toNbt());
        return false;
    }, (hasMore, previousData, iteration, nbt) -> StationTag.fromNbt(nbt.m_128469_("Data"), null)));
    public static final DataAccessorType<String, StationTag, StationTag> CREATE_STATION_TAG = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "create_station_tag"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.m_128365_("Data", (Tag)GlobalSettings.getInstance().createOrGetStationTag((String)in).toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> StationTag.fromNbt(nbt.m_128469_("Data"), null)));
    public static final DataAccessorType<StationTag, Void, Void> REGISTER_STATION_TAG = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "register_station_tag"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.m_128365_("Data", (Tag)in.toNbt()), nbt -> StationTag.fromNbt(nbt.m_128469_("Data"), null), (player, in, temp, nbt, iteration) -> {
        in.updateLastEdited(player.m_36316_().getName());
        GlobalSettings.getInstance().registerStationTag((StationTag)in);
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> DELETE_STATION_TAG = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "delete_station_tag"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.m_128362_("Data", in), nbt -> nbt.m_128342_("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().removeStationTag((UUID)in);
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateStationTagNameData, Void, Void> UPDATE_STATION_TAG_NAME = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "update_station_tag_name"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.m_128362_("Id", in.tagId());
        nbt.m_128359_("Name", in.name());
    }, nbt -> new GlobalSettingsClient.UpdateStationTagNameData(nbt.m_128342_("Id"), nbt.m_128461_("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            x.updateLastEdited(player.m_36316_().getName());
            x.setName(TagName.of(in.name()));
        });
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.AddStationTagEntryData, Optional<StationTag>, Optional<StationTag>> ADD_STATION_TAG_ENTRY = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "add_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.m_128362_("Id", in.tagId());
        nbt.m_128359_("Name", in.station());
        nbt.m_128365_("Info", (Tag)in.info().toNbt());
    }, nbt -> new GlobalSettingsClient.AddStationTagEntryData(nbt.m_128342_("Id"), nbt.m_128461_("Name"), StationTag.StationInfo.fromNbt(nbt.m_128469_("Info"))), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            x.add(in.station(), in.info());
            x.updateLastEdited(player.m_36316_().getName());
            nbt.m_128365_("Data", (Tag)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.m_128441_("Data") ? StationTag.fromNbt(nbt.m_128469_("Data"), null) : null)));
    public static final DataAccessorType<GlobalSettingsClient.AddStationTagEntryData, Optional<StationTag>, Optional<StationTag>> UPDATE_STATION_TAG_ENTRY = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "update_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.m_128362_("Id", in.tagId());
        nbt.m_128359_("Name", in.station());
        nbt.m_128365_("Info", (Tag)in.info().toNbt());
    }, nbt -> new GlobalSettingsClient.AddStationTagEntryData(nbt.m_128342_("Id"), nbt.m_128461_("Name"), StationTag.StationInfo.fromNbt(nbt.m_128469_("Info"))), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            x.updateInfoForStation(in.station(), in.info());
            x.updateLastEdited(player.m_36316_().getName());
            nbt.m_128365_("Data", (Tag)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.m_128441_("Data") ? StationTag.fromNbt(nbt.m_128469_("Data"), null) : null)));
    public static final DataAccessorType<GlobalSettingsClient.RemoveStationTagEntryData, Optional<StationTag>, Optional<StationTag>> REMOVE_STATION_TAG_ENTRY = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "remove_station_tag_entry"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.m_128362_("Id", in.tagId());
        nbt.m_128359_("Name", in.station());
    }, nbt -> new GlobalSettingsClient.RemoveStationTagEntryData(nbt.m_128342_("Id"), nbt.m_128461_("Name")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getStationTag(in.tagId()).ifPresent(x -> {
            x.remove(in.station());
            x.updateLastEdited(player.m_36316_().getName());
            nbt.m_128365_("Data", (Tag)x.toNbt());
        });
        return false;
    }, (hasMore, data, iteration, nbt) -> Optional.ofNullable(nbt.m_128441_("Data") ? StationTag.fromNbt(nbt.m_128469_("Data"), null) : null)));
    public static final DataAccessorType<Void, Collection<StationTag>, Collection<StationTag>> GET_ALL_STATION_TAGS = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_all_station_tags"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue(GlobalSettings.getInstance().getAllStationTags().stream().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            nbt.m_128365_("Data" + i, (Tag)((StationTag)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(StationTag.fromNbt(nbt.m_128469_(x), null)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Boolean, Collection<StationTag>, Collection<StationTag>> GET_ALL_STATIONS_AS_TAGS = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_all_stations_as_tags"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.m_128379_("Data", in.booleanValue()), nbt -> nbt.m_128471_("Data"), (player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<StationTag>(TrainUtils.getAllStations().stream().filter(x -> in == false || !GlobalSettings.getInstance().isStationBlacklisted((GlobalStation)x)).map(x -> GlobalSettings.getInstance().getOrCreateStationTagFor((GlobalStation)x)).distinct().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            nbt.m_128365_("Data" + i, (Tag)((StationTag)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(StationTag.fromNbt(nbt.m_128469_(x), null)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<TrainGroup>, List<TrainGroup>> GET_ALL_TRAIN_GROUPS = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_all_train_groups"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<TrainGroup>((Collection<TrainGroup>)GlobalSettings.getInstance().getAllTrainGroups()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 64 && !tags.isEmpty(); ++i) {
            nbt.m_128365_("Data" + i, (Tag)((TrainGroup)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(TrainGroup.fromNbt(nbt.m_128469_(x))));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Void, Void> DELETE_TRAIN_GROUP = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "delete_train_group"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().removeTrainGroup((String)in);
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainGroupColorData, Void, Void> UPDATE_TRAIN_GROUP_COLOR = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "update_train_group_color"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.m_128359_("Id", in.name());
        nbt.m_128405_("Color", in.color());
    }, nbt -> new GlobalSettingsClient.UpdateTrainGroupColorData(nbt.m_128461_("Id"), nbt.m_128451_("Color")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainGroup(in.name()).ifPresent(x -> x.setColor(in.color()));
        return false;
    }));
    public static final DataAccessorType<String, TrainGroup, TrainGroup> CREATE_TRAIN_GROUP = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "create_train_group"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        TrainGroup group = GlobalSettings.getInstance().createOrGetTrainGroup((String)in);
        nbt.m_128365_("Data", (Tag)group.toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> TrainGroup.fromNbt(nbt.m_128469_("Data"))));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> ADD_STATION_TO_BLACKLIST = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "add_station_to_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().blacklistStation((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128359_("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(nbt.m_128461_(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> REMOVE_STATION_FROM_BLACKLIST = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "remove_station_from_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().removeStationFromBlacklist((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128359_("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(nbt.m_128461_(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<String>, List<String>> GET_BLACKLISTED_STATIONS = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_blacklisted_stations"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedStations()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128359_("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(nbt.m_128461_(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> ADD_TRAIN_TO_BLACKLIST = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "add_train_to_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().blacklistTrain((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128359_("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(nbt.m_128461_(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Collection<String>, Collection<String>> REMOVE_TRAIN_FROM_BLACKLIST = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "remove_train_from_blacklist"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            GlobalSettings.getInstance().removeTrainFromBlacklist((String)in);
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128359_("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(nbt.m_128461_(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<String>, List<String>> GET_BLACKLISTED_TRAINS = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_blacklisted_trains"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128359_("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(nbt.m_128461_(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<UUID, ClientRoutePart.TrainRealTimeData, ClientRoutePart.TrainRealTimeData> UPDATE_REALTIME = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "update_realtime"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128362_("Data", in), nbt -> nbt.m_128342_("Data"), (player, in, temp, nbt, iteration) -> {
        if (!TrainListener.data.containsKey(in)) {
            return false;
        }
        TrainData data = TrainListener.data.get(in);
        Map<Integer, ClientTrainStop.TrainStopRealTimeData> values = data.getPredictions().stream().map(a -> new ClientTrainStop.TrainStopRealTimeData(a.getStationTag().getClientTag(a.getStationName()), a.getEntryIndex(), a.getScheduledArrivalTime(), a.getScheduledDepartureTime(), a.getRealTimeArrivalTime(), a.getRealTimeDepartureTime(), a.getArrivalTimeDeviation(), a.getDepartureTimeDeviation(), a.getRealTimeArrivalTicks(), a.getCurrentCycle())).collect(Collectors.toMap(a -> a.entryIndex(), a -> a));
        nbt.m_128365_("Data", (Tag)new ClientRoutePart.TrainRealTimeData(data.getSessionId(), values, data.getStatus(), data.isCancelled()).toNbt());
        return false;
    }, (hasMore, previousData, iteration, nbt) -> nbt.m_128441_("Data") ? ClientRoutePart.TrainRealTimeData.fromNbt(nbt.m_128469_("Data")) : null));
    public static final DataAccessorType<UUID, UserSettings, UserSettings> GET_USER_SETTINGS = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_user_settings"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128362_("Data", in), nbt -> nbt.m_128342_("Data"), (player, in, temp, nbt, iteration) -> {
        nbt.m_128365_("Data", (Tag)UserSettings.getSettingsFor(in, false).toNbt());
        nbt.m_128362_("Id", in);
        return false;
    }, (hasMore, list, iteration, nbt) -> UserSettings.fromNbt(nbt.m_128469_("Data"), nbt.m_128342_("Id"), false)));
    public static final DataAccessorType<UserSettings, Void, Void> SAVE_USER_SETTINGS = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "save_user_settings"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.m_128365_("Data", (Tag)in.toNbt());
        nbt.m_128362_("Id", in.getOwnerId());
    }, nbt -> UserSettings.fromNbt(nbt.m_128469_("Data"), nbt.m_128342_("Id"), false), (player, in, temp, nbt, iteration) -> {
        in.save();
        return false;
    }));
    public static final DataAccessorType<BlockPos, NearestTrackStationResult, NearestTrackStationResult> GET_NEAREST_STATION = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_nearest_station"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.m_128405_("x", in.m_123341_());
        nbt.m_128405_("y", in.m_123342_());
        nbt.m_128405_("z", in.m_123343_());
    }, nbt -> new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z")), (player, in, temp, nbt, iteration) -> {
        NearestTrackStationResult result = NearestTrackStationResult.empty();
        try {
            result = TrainUtils.getNearestTrackStation(player.m_9236_(), (Vec3i)in);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Error while trying to find nearest track station.", (Throwable)e);
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((ServerPlayer)player, (Object)new ServerErrorPacket(e.getMessage()));
        }
        nbt.m_128365_("Data", (Tag)result.toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> NearestTrackStationResult.fromNbt(nbt.m_128469_("Data"))));
    public static final DataAccessorType<UUID, TrainDisplayData, TrainDisplayData> GET_TRAIN_DISPLAY_DATA = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_train_display_data"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128362_("Data", in), nbt -> nbt.m_128342_("Data"), (player, in, temp, nbt, iteration) -> {
        Optional<Train> trainOpt = TrainUtils.getTrain(in);
        if (!trainOpt.isPresent() || !TrainUtils.isTrainUsable(trainOpt.get()) || GlobalSettings.getInstance().isTrainBlacklisted(trainOpt.get())) {
            nbt.m_128365_("Data", (Tag)TrainDisplayData.empty().toNbt());
            return false;
        }
        nbt.m_128365_("Data", (Tag)TrainDisplayData.of(trainOpt.get()).toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> TrainDisplayData.fromNbt(nbt.m_128469_("Data"))));
    public static final DataAccessorType<NextConnectionsRequestData, NextConnectionsDisplayData, NextConnectionsDisplayData> GET_NEXT_CONNECTIONS_DISPLAY_DATA = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_next_connections_display_data"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128365_("Data", (Tag)in.toNbt()), nbt -> NextConnectionsRequestData.fromNbt(nbt.m_128469_("Data")), (player, in, temp, nbt, iteration) -> {
        nbt.m_128365_("Data", (Tag)NextConnectionsDisplayData.at(in.stationName(), in.selfTrainId()).toNbt());
        return false;
    }, (hasMore, list, iteration, nbt) -> NextConnectionsDisplayData.fromNbt(nbt.m_128469_("Data"))));
    public static final DataAccessorType<Void, Collection<String>, Collection<String>> GET_ALL_TRAIN_NAMES = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_all_train_names"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>(TrainUtils.getTrains(false).stream().map(x -> x.name.getString()).toList()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128359_("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(nbt.m_128461_(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, Collection<String>, Collection<String>> GET_ALL_STATION_NAMES = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_all_station_names"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<String>(TrainUtils.getAllStations().stream().map(x -> x.name).toList()));
        }
        Queue tags = (Queue)temp.getFirst();
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128359_("Data" + i, (String)tags.poll());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(nbt.m_128461_(x)));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<Void, List<TrainLine>, List<TrainLine>> GET_ALL_TRAIN_LINES = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_all_train_lines"), (DataAccessorType)DataAccessorType.Builder.createNoInputChunked((player, in, temp, nbt, iteration) -> {
        Queue tags;
        if (temp.getFirst() == null) {
            temp.setFirst(new ConcurrentLinkedQueue<TrainLine>((Collection<TrainLine>)GlobalSettings.getInstance().getAllTrainLines()));
        }
        if ((tags = (Queue)temp.getFirst()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < 256 && !tags.isEmpty(); ++i) {
            nbt.m_128365_("Data" + i, (Tag)((TrainLine)tags.poll()).toNbt());
        }
        return !tags.isEmpty();
    }, (hasMore, list, iteration, nbt) -> {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList l = list;
        nbt.m_128431_().forEach(x -> l.add(TrainLine.fromNbt(nbt.m_128469_(x))));
        return l;
    }, chunks -> chunks));
    public static final DataAccessorType<String, Void, Void> DELETE_TRAIN_LINE = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "delete_train_line"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().removeTrainLine((String)in);
        return false;
    }));
    public static final DataAccessorType<GlobalSettingsClient.UpdateTrainLineColorData, Void, Void> UPDATE_TRAIN_LINE_COLOR = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "update_train_line_color"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> {
        nbt.m_128359_("Id", in.name());
        nbt.m_128405_("Color", in.color());
    }, nbt -> new GlobalSettingsClient.UpdateTrainLineColorData(nbt.m_128461_("Id"), nbt.m_128451_("Color")), (player, in, temp, nbt, iteration) -> {
        GlobalSettings.getInstance().getTrainLine(in.name()).ifPresent(x -> x.setColor(in.color()));
        return false;
    }));
    public static final DataAccessorType<String, TrainLine, TrainLine> CREATE_TRAIN_LINE = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "create_train_line"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> nbt.m_128359_("Data", in), nbt -> nbt.m_128461_("Data"), (player, in, temp, nbt, iteration) -> {
        TrainLine group = GlobalSettings.getInstance().createOrGetTrainLine((String)in);
        nbt.m_128365_("Data", (Tag)group.toNbt());
        return false;
    }, (hasMore, data, iteration, nbt) -> TrainLine.fromNbt(nbt.m_128469_("Data"))));
    public static final DataAccessorType<NavigationData, List<ClientRoute>, List<ClientRoute>> NAVIGATE = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "navigate"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> {
        nbt.m_128359_("Start", in.start());
        nbt.m_128359_("End", in.end());
        nbt.m_128362_("Player", in.player());
    }, nbt -> new NavigationData(nbt.m_128461_("Start"), nbt.m_128461_("End"), nbt.m_128342_("Player")), (player, in, temp, nbt, iteration) -> {
        try {
            Queue tags;
            if (temp.getFirst() == null) {
                GlobalSettings settings = GlobalSettings.getInstance();
                List<Route> routes = NavigatableGraph.searchRoutes(settings.getTagByName(TagName.of(in.start())).orElse(settings.getOrCreateStationTagFor(in.start())), settings.getTagByName(TagName.of(in.end())).orElse(settings.getOrCreateStationTagFor(in.end())), in.player(), true);
                temp.setFirst(new ConcurrentLinkedQueue<Route>(routes));
            }
            if ((tags = (Queue)temp.getFirst()).isEmpty()) {
                return false;
            }
            Route r = (Route)tags.poll();
            nbt.m_128365_("Data", (Tag)r.toNbt());
            return !tags.isEmpty();
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Navigation error.", (Throwable)e);
            return false;
        }
    }, (hasMore, list, iteration, nbt) -> {
        if (!nbt.m_128441_("Data")) {
            return List.of();
        }
        if (list == null) {
            list = new ArrayList<ClientRoute>();
        }
        list.add(ClientRoute.fromNbt(nbt.m_128469_("Data"), true));
        return list;
    }, chunks -> chunks));
    public static final DataAccessorType<DepartureRoutesData, List<Pair<Boolean, ClientRoute>>, List<Pair<Boolean, ClientRoute>>> GET_DEPARTURE_AND_ARRIVAL_ROUTES_AT = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_departure_and_arrival_routes_at"), (DataAccessorType)DataAccessorType.Builder.createChunked((in, nbt) -> {
        nbt.m_128359_("Station", in.stationTagName());
        nbt.m_128362_("Player", in.player());
    }, nbt -> new DepartureRoutesData(nbt.m_128461_("Station"), nbt.m_128342_("Player")), (player, in, temp, nbt, iteration) -> {
        try {
            Queue tags;
            if (temp.getFirst() == null) {
                UserSettings settings = UserSettings.getSettingsFor(in.player(), true);
                StationTag station = GlobalSettings.getInstance().getOrCreateStationTagFor(TagName.of(in.stationTagName()));
                Set trains = TrainUtils.getDepartingTrainsAt(station).stream().filter(x -> TrainUtils.isTrainUsable(x) && !GlobalSettings.getInstance().isTrainBlacklisted((Train)x) && TrainListener.data.containsKey(x.id)).collect(Collectors.toSet());
                ArrayList<Pair> routesL = new ArrayList<Pair>();
                for (Train train : trains) {
                    TrainData data = TrainListener.data.get(train.id);
                    List<TrainPrediction> matchingPredictions = data.getPredictionsChronologically().stream().filter(x -> x.getStationTag().equals(station)).toList();
                    for (TrainPrediction prediction : matchingPredictions) {
                        TrainTravelSection section = prediction.getSection();
                        if (!section.isUsable() && (!section.isFirstStop(prediction) || !section.previousSection().isUsable() || !section.previousSection().shouldIncludeNextStationOfNextSection()) || section.getTrainGroup() != null && settings.searchExcludedTrainGroups.getValue().contains(section.getTrainGroup().getGroupName())) continue;
                        TrainTravelSection previousSection = section.previousSection();
                        boolean isStart = section.isFirstStop(prediction);
                        boolean isStartAndFinal = isStart && previousSection.isUsable() && previousSection.shouldIncludeNextStationOfNextSection() && (previousSection.getTrainGroup() == null || !settings.searchExcludedTrainGroups.getValue().contains(previousSection.getTrainGroup().getGroupName()));
                        TrainStop stop = new TrainStop(prediction);
                        stop.simulateTicks(settings.searchDepartureInTicks.getValue().intValue());
                        TrainPrediction fromPrediction = section.getFirstStop().get();
                        TrainStop from = new TrainStop(fromPrediction);
                        Route route = new Route(List.of(new RoutePart(data.getSessionId(), train.id, List.of(stop, from), section.getAllStops(settings.searchDepartureInTicks.getValue().intValue(), prediction.getEntryIndex()))), false);
                        if (!(isStart && !isStartAndFinal || section.getTrainGroup() != null && settings.searchExcludedTrainGroups.getValue().contains(section.getTrainGroup().getGroupName()))) {
                            Route selectedRoute = route;
                            if (isStartAndFinal) {
                                TrainPrediction frPred = previousSection.getFirstStop().get();
                                TrainStop fr = new TrainStop(frPred);
                                selectedRoute = new Route(List.of(new RoutePart(data.getSessionId(), train.id, List.of(stop, fr), previousSection.getAllStops(settings.searchDepartureInTicks.getValue().intValue(), prediction.getEntryIndex()))), false);
                            }
                            routesL.add(Pair.of((Object)true, (Object)selectedRoute));
                        }
                        if (!section.isUsable() || section.getTrainGroup() != null && settings.searchExcludedTrainGroups.getValue().contains(section.getTrainGroup().getGroupName())) continue;
                        routesL.add(Pair.of((Object)false, (Object)route));
                    }
                }
                Collections.sort(routesL, (a, b) -> {
                    long val1 = (Boolean)a.getFirst() != false ? ((Route)a.getSecond()).getStart().getScheduledArrivalTime() : ((Route)a.getSecond()).getStart().getScheduledDepartureTime();
                    long val2 = (Boolean)b.getFirst() != false ? ((Route)b.getSecond()).getStart().getScheduledArrivalTime() : ((Route)b.getSecond()).getStart().getScheduledDepartureTime();
                    return Long.compare(val1, val2);
                });
                temp.setFirst(new ConcurrentLinkedQueue(routesL));
            }
            if ((tags = (Queue)temp.getFirst()).isEmpty()) {
                return false;
            }
            Pair r = (Pair)tags.poll();
            nbt.m_128379_("IsArrival", ((Boolean)r.getFirst()).booleanValue());
            nbt.m_128365_("Data", (Tag)((Route)r.getSecond()).toNbt());
            return !tags.isEmpty();
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Schedule board generation error.", (Throwable)e);
            return false;
        }
    }, (hasMore, list, iteration, nbt) -> {
        if (!nbt.m_128441_("Data")) {
            return List.of();
        }
        if (list == null) {
            list = new ArrayList<Pair>();
        }
        list.add(Pair.of((Object)nbt.m_128471_("IsArrival"), (Object)ClientRoute.fromNbt(nbt.m_128469_("Data"), false)));
        return list;
    }, chunks -> chunks));
    public static final DataAccessorType<DeparturesData, List<ClientTrainStop>, List<ClientTrainStop>> GET_DEPARTURES_AT = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_departures_at"), (DataAccessorType)DataAccessorType.Builder.create((in, nbt) -> {
        nbt.m_128362_("Tag", in.stationTagId());
        nbt.m_128362_("Train", in.trainId());
    }, nbt -> new DeparturesData(nbt.m_128342_("Tag"), nbt.m_128342_("Train")), (player, in, temp, nbt, iteration) -> {
        try {
            if (!GlobalSettings.getInstance().stationTagExists(in.stationTagId())) {
                return false;
            }
            StationTag tag = GlobalSettings.getInstance().getStationTag(in.stationTagId()).get();
            ListTag list = new ListTag();
            list.addAll(TrainUtils.getDeparturesAt(tag, in.trainId()).stream().map(x -> x.toNbt(true)).toList());
            nbt.m_128365_("Data", (Tag)list);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Next connections error.", (Throwable)e);
        }
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.m_128441_("Data") ? nbt.m_128437_("Data", 10).stream().map(x -> (ClientTrainStop)ClientTrainStop.fromNbt((CompoundTag)x)).toList() : List.of()));
    public static final DataAccessorType<Void, Boolean, Boolean> ALL_TRAINS_INITIALIZED = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "all_trains_initialized"), (DataAccessorType)DataAccessorType.Builder.createNoInput((player, in, temp, nbt, iteration) -> {
        nbt.m_128379_("Data", TrainListener.allTrainsInitialized());
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.m_128471_("Data")));
    public static final DataAccessorType<Void, List<TrainDebugData>, List<TrainDebugData>> GET_ALL_TRAINS_DEBUG_DATA = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "get_all_trains_debug_data"), (DataAccessorType)DataAccessorType.Builder.createNoInput((player, in, temp, nbt, iteration) -> {
        ListTag list = new ListTag();
        list.addAll(TrainListener.data.values().stream().map(x -> TrainDebugData.fromTrain(x).toNbt()).toList());
        nbt.m_128365_("Data", (Tag)list);
        return false;
    }, (hasMore, data, iteration, nbt) -> nbt.m_128437_("Data", 10).stream().map(x -> TrainDebugData.fromNbt((CompoundTag)x)).toList()));
    public static final DataAccessorType<Void, Void, Void> SHOW_TRAIN_DEBUG_SCREEN = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "show_train_debug_screen"), (DataAccessorType)DataAccessorType.Builder.createNoIO((player, in, temp, nbt, iteration) -> {
        ClientWrapper.showTrainDebugScreen();
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> TRAIN_SOFT_RESET = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "train_soft_reset"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.m_128362_("Data", in), nbt -> nbt.m_128342_("Data"), (player, in, temp, nbt, iteration) -> {
        if (TrainListener.data.containsKey(in)) {
            TrainListener.data.get(in).resetPredictions();
        }
        return false;
    }));
    public static final DataAccessorType<UUID, Void, Void> TRAIN_HARD_RESET = DataAccessorType.register((ResourceLocation)new ResourceLocation("createrailwaysnavigator", "train_hard_reset"), (DataAccessorType)DataAccessorType.Builder.createEmptyResponse((in, nbt) -> nbt.m_128362_("Data", in), nbt -> nbt.m_128342_("Data"), (player, in, temp, nbt, iteration) -> {
        if (TrainListener.data.containsKey(in)) {
            TrainListener.data.get(in).hardResetPredictions();
        }
        return false;
    }));

    public static void init() {
    }

    public record DeparturesData(UUID stationTagId, UUID trainId) {
    }

    public record DepartureRoutesData(String stationTagName, UUID player) {
    }

    public record NavigationData(String start, String end, UUID player) {
    }
}

