/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedDisplayUpdatePacket
implements IPacketBase<AdvancedDisplayUpdatePacket> {
    private BlockPos pos;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey key;
    private boolean doubleSided;

    public AdvancedDisplayUpdatePacket() {
    }

    public AdvancedDisplayUpdatePacket(Level level, BlockPos pos, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided) {
        this.pos = pos;
        this.key = key;
        this.doubleSided = doubleSided;
        this.apply(level, this);
    }

    protected AdvancedDisplayUpdatePacket(BlockPos pos, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided) {
        this.pos = pos;
        this.key = key;
        this.doubleSided = doubleSided;
    }

    public void encode(AdvancedDisplayUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130079_(packet.key.toNbt());
        buffer.writeBoolean(packet.doubleSided);
    }

    public AdvancedDisplayUpdatePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        AdvancedDisplaysRegistry.DisplayTypeResourceKey key = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(buffer.m_130260_());
        boolean doubleSided = buffer.readBoolean();
        return new AdvancedDisplayUpdatePacket(pos, key, doubleSided);
    }

    private void apply(Level level, AdvancedDisplayUpdatePacket packet) {
        BlockEntity blockEntity;
        if (level.m_46749_(packet.pos) && (blockEntity = level.m_7702_(packet.pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity2 = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity2.applyToAll(be -> {
                be.setDisplayTypeKey(packet.key);
                if (level.m_8055_(be.m_58899_()).m_60734_() instanceof AbstractAdvancedSidedDisplayBlock) {
                    BlockState state = level.m_8055_(be.m_58899_());
                    state = (BlockState)state.m_61124_(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                    level.m_46597_(be.m_58899_(), state);
                }
                be.notifyUpdate();
            });
        }
    }

    public void handle(AdvancedDisplayUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null) {
                Level level = player.m_9236_();
                this.apply(level, packet);
            }
        });
    }
}

