/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class NextConnectionsDisplayData {
    private final List<TrainStopDisplayData> stops;
    private static final String NBT_STOPS = "Stops";

    public NextConnectionsDisplayData(List<TrainStopDisplayData> stops) {
        this.stops = stops;
    }

    public static NextConnectionsDisplayData empty() {
        return new NextConnectionsDisplayData(List.of());
    }

    public static NextConnectionsDisplayData at(String stationName, UUID selfTrainId) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return new NextConnectionsDisplayData(TrainUtils.getDeparturesAt(GlobalSettings.getInstance().getOrCreateStationTagFor(TagName.of(stationName)), selfTrainId).stream().map(x -> TrainStopDisplayData.of(x)).toList());
    }

    public List<TrainStopDisplayData> getConnections() {
        return this.stops;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        list.addAll(this.stops.stream().map(x -> x.toNbt()).toList());
        nbt.m_128365_(NBT_STOPS, (Tag)list);
        return nbt;
    }

    public static NextConnectionsDisplayData fromNbt(CompoundTag nbt) {
        return new NextConnectionsDisplayData(nbt.m_128437_(NBT_STOPS, 10).stream().map(x -> TrainStopDisplayData.fromNbt((CompoundTag)x)).toList());
    }
}

