/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import com.simibubi.create.content.trains.entity.TrainIconType;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class BasicTrainDisplayData {
    private final UUID id;
    private final String name;
    private final TrainIconType icon;
    private final List<TrainStatus.CompiledTrainStatus> status;
    private final boolean cancelled;
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private static final String NBT_ICON = "Icon";
    private static final String NBT_STATUS = "Status";
    private static final String NBT_CANCELLED = "Cancelled";

    public BasicTrainDisplayData(UUID id, String name, TrainIconType icon, List<TrainStatus.CompiledTrainStatus> status, boolean cancelled) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.status = status;
        this.cancelled = cancelled;
    }

    public static BasicTrainDisplayData empty() {
        return new BasicTrainDisplayData(new UUID(0L, 0L), "", TrainIconType.getDefault(), List.of(), true);
    }

    public static BasicTrainDisplayData of(UUID train) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        if (!TrainListener.data.containsKey(train)) {
            return BasicTrainDisplayData.empty();
        }
        TrainData data = TrainListener.data.get(train);
        return new BasicTrainDisplayData(data.getTrainId(), data.getTrainName(), TrainIconType.getDefault(), new ArrayList<TrainStatus.CompiledTrainStatus>(data.getStatus()), data.isCancelled());
    }

    public static BasicTrainDisplayData of(TrainStop stop) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        if (!TrainListener.data.containsKey(stop.getTrainId())) {
            return BasicTrainDisplayData.empty();
        }
        TrainData data = TrainListener.data.get(stop.getTrainId());
        return new BasicTrainDisplayData(stop.getTrainId(), stop.getTrainName(), stop.getTrainIcon(), new ArrayList<TrainStatus.CompiledTrainStatus>(data.getStatus()), data.isCancelled());
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TrainIconType getIcon() {
        return this.icon;
    }

    public List<TrainStatus.CompiledTrainStatus> getStatus() {
        return this.status;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean hasStatusInfo() {
        return !this.getStatus().isEmpty();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag statusList = new ListTag();
        statusList.addAll(this.status.stream().map(x -> x.toNbt()).toList());
        nbt.m_128362_(NBT_ID, this.id);
        nbt.m_128359_(NBT_NAME, this.name);
        nbt.m_128359_(NBT_ICON, this.icon.getId().toString());
        nbt.m_128365_(NBT_STATUS, (Tag)statusList);
        nbt.m_128379_(NBT_CANCELLED, this.cancelled);
        return nbt;
    }

    public static BasicTrainDisplayData fromNbt(CompoundTag nbt) {
        return new BasicTrainDisplayData(nbt.m_128342_(NBT_ID), nbt.m_128461_(NBT_NAME), TrainIconType.byId((ResourceLocation)new ResourceLocation(nbt.m_128461_(NBT_ICON))), nbt.m_128437_(NBT_STATUS, 10).stream().map(x -> TrainStatus.CompiledTrainStatus.fromNbt((CompoundTag)x)).toList(), nbt.m_128471_(NBT_CANCELLED));
    }

    public final boolean equals(Object obj) {
        BasicTrainDisplayData o;
        return obj instanceof BasicTrainDisplayData && (o = (BasicTrainDisplayData)obj).getId().equals(this.getId());
    }

    public final int hashCode() {
        return Objects.hash(this.getId());
    }
}

