/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.utility.Couple;
import de.mrjulsen.crn.data.NearestTrackStationResult;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.navigation.TrainSchedule;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.mcdragonlib.data.Single;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public final class TrainUtils {
    public static GlobalRailwayManager getRailwayManager() {
        return Create.RAILWAYS;
    }

    public static Map<String, Collection<GlobalTrainDisplayData.TrainDeparturePrediction>> allPredictionsRaw() {
        return new HashMap<String, Collection<GlobalTrainDisplayData.TrainDeparturePrediction>>(GlobalTrainDisplayData.statusByDestination);
    }

    public static boolean isStationKnown(String station) {
        return TrainUtils.allPredictionsRaw().keySet().stream().anyMatch(x -> TrainUtils.stationMatches(station, x));
    }

    public static Collection<GlobalStation> getAllStations() {
        ArrayList<GlobalStation> stations = new ArrayList<GlobalStation>();
        TrainUtils.getRailwayManager().trackNetworks.forEach((uuid, graph) -> {
            Collection foundStations = graph.getPoints(EdgePointType.STATION);
            stations.addAll(foundStations);
        });
        return stations;
    }

    public static Optional<Train> getTrain(UUID trainId) {
        return Optional.ofNullable((Train)TrainUtils.getRailwayManager().trains.get(trainId));
    }

    public static Set<UUID> getTrainIds() {
        return new HashSet<UUID>(TrainUtils.getRailwayManager().trains.keySet());
    }

    public static Set<Train> getTrains(boolean onlyValid) {
        return new HashSet<Train>(TrainUtils.getRailwayManager().trains.values().stream().filter(x -> !onlyValid || TrainUtils.isTrainValid(x)).toList());
    }

    public static Set<SignalBoundary> getAllSignals() {
        return new HashSet<SignalBoundary>(TrainUtils.getRailwayManager().trackNetworks.values().stream().flatMap(x -> x.getPoints(EdgePointType.SIGNAL).stream()).toList());
    }

    public static Set<Train> getDepartingTrainsAt(StationTag station) {
        return ImmutableMap.copyOf((Map)GlobalTrainDisplayData.statusByDestination).entrySet().stream().filter(x -> station.contains((String)x.getKey())).flatMap(x -> ((Collection)x.getValue()).stream()).map(x -> x.train).collect(Collectors.toSet());
    }

    public static Set<Train> getDepartingTrainsAt(String station) {
        return ImmutableMap.copyOf((Map)GlobalTrainDisplayData.statusByDestination).entrySet().stream().filter(x -> station.equals(x.getKey())).flatMap(x -> ((Collection)x.getValue()).stream()).map(x -> x.train).collect(Collectors.toSet());
    }

    public static List<TrainStop> getDeparturesAt(StationTag station, UUID selfTrain) {
        return TrainUtils.getDeparturesAt((TrainPrediction x) -> x.getStationTag().equals(station), selfTrain);
    }

    public static List<TrainStop> getDeparturesAtStationName(String stationName, UUID selfTrain) {
        return TrainUtils.getDeparturesAt((TrainPrediction x) -> TrainUtils.stationMatches(x.getStationName(), stationName), selfTrain);
    }

    public static List<TrainStop> getDeparturesAt(Predicate<TrainPrediction> stationFilter, UUID selfTrain) {
        Single.MutableSingle selfSchedule = new Single.MutableSingle(null);
        TrainUtils.getTrain(selfTrain).ifPresent(x -> selfSchedule.setFirst((Object)new TrainSchedule(TrainListener.data.containsKey(x.id) ? TrainListener.data.get(x.id).getSessionId() : new UUID(0L, 0L), (Train)x)));
        List<TrainStop> list = TrainListener.data.values().stream().filter(x -> !x.getTrainId().equals(selfTrain) && TrainUtils.isTrainUsable(x.getTrain())).flatMap(x -> x.getPredictions().stream().filter(stationFilter)).map(TrainStop::new).filter(x -> {
            if (selfSchedule.getFirst() != null) {
                return true;
            }
            Optional<Train> train = TrainUtils.getTrain(x.getTrainId());
            if (!train.isPresent()) {
                return false;
            }
            TrainSchedule sched = new TrainSchedule(TrainListener.data.containsKey(train.get().id) ? TrainListener.data.get(train.get().id).getSessionId() : new UUID(0L, 0L), train.get());
            return !sched.isEqual((TrainSchedule)selfSchedule.getFirst());
        }).sorted((a, b) -> Long.compare(a.getScheduledDepartureTime(), b.getScheduledDepartureTime())).toList();
        ArrayList<TrainStop> results = new ArrayList<TrainStop>();
        HashSet<UUID> usedTrains = new HashSet<UUID>();
        usedTrains.add(selfTrain);
        for (TrainStop stop : list) {
            TrainData data;
            TrainTravelSection section;
            if (!TrainListener.data.containsKey(stop.getTrainId()) || !(section = (data = TrainListener.data.get(stop.getTrainId())).getSectionByIndex(stop.getSectionIndex())).isUsable() && (!section.isFirstStop(stop.getScheduleIndex()) || !section.previousSection().isUsable() || !section.previousSection().shouldIncludeNextStationOfNextSection()) || usedTrains.contains(stop.getTrainId())) continue;
            usedTrains.add(stop.getTrainId());
            results.add(stop);
        }
        return results;
    }

    public static Set<Train> isSignalOccupied(UUID signalId, Set<UUID> excludedTrains) {
        Optional<SignalBoundary> signal = TrainUtils.getAllSignals().stream().filter(x -> x.getId().equals(signalId)).findFirst();
        if (!signal.isPresent()) {
            return Set.of();
        }
        Set<Train> occupyingTrains = TrainUtils.getTrains(false).stream().filter(x -> !excludedTrains.contains(x.id) && x.occupiedSignalBlocks.keySet().stream().anyMatch(y -> y.equals(((SignalBoundary)signal.get()).groups.getFirst()) || y.equals(((SignalBoundary)signal.get()).groups.getSecond()))).collect(Collectors.toSet());
        return occupyingTrains;
    }

    public static NearestTrackStationResult getNearestTrackStation(Level level, Vec3i pos) {
        Optional<GlobalStation> station = TrainUtils.getAllStations().stream().filter(x -> TrainUtils.isStationKnown(x.name) && x.getBlockEntityDimension().equals(level.m_46472_()) && !GlobalSettings.getInstance().isStationBlacklisted(x.name)).min((a, b) -> Double.compare(a.getBlockEntityPos().m_123331_(pos), b.getBlockEntityPos().m_123331_(pos)));
        double distance = station.isPresent() ? station.get().getBlockEntityPos().m_123331_(pos) : 0.0;
        return new NearestTrackStationResult(station, distance);
    }

    public static TrainExitSide getTrainStationExit(GlobalStation station, Direction stationDirection, Level level) {
        DoorControlBehaviour dcb = TrainUtils.getTrainStationDoorControl(station, level);
        if (dcb == null) {
            return TrainExitSide.UNKNOWN;
        }
        if (dcb.mode.matches(stationDirection.m_122427_())) {
            return TrainExitSide.RIGHT;
        }
        if (dcb.mode.matches(stationDirection.m_122428_())) {
            return TrainExitSide.LEFT;
        }
        return TrainExitSide.UNKNOWN;
    }

    public static DoorControlBehaviour getTrainStationDoorControl(GlobalStation station, Level level) {
        BlockPos stationPos = station.getBlockEntityPos();
        if (level == null || !level.m_46749_(stationPos)) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(stationPos);
        if (blockEntity instanceof StationBlockEntity) {
            StationBlockEntity be = (StationBlockEntity)blockEntity;
            return be.doorControls;
        }
        return null;
    }

    public static Optional<TrackEdge> getEdge(GlobalStation station) {
        Single.MutableSingle edge = new Single.MutableSingle(null);
        Create.RAILWAYS.trackNetworks.forEach((uuid, graph) -> {
            if (edge.getFirst() != null) {
                return;
            }
            TrackEdge e = graph.getConnection(Couple.create((Object)graph.locateNode((TrackNodeLocation)station.edgeLocation.getFirst()), (Object)graph.locateNode((TrackNodeLocation)station.edgeLocation.getSecond())));
            if (e == null) {
                return;
            }
            edge.setFirst((Object)e);
        });
        return Optional.ofNullable((TrackEdge)edge.getFirst());
    }

    public static double angleOn(TrackEdgePoint point, TrackEdge edge) {
        double basePos = point.isPrimary(edge.node1) ? edge.getLength() - point.position : point.position;
        Vec3 vec = edge.getDirectionAt(basePos);
        return point.isPrimary(edge.node1) ? MathUtils.getVectorAngle((Vec3)vec) : MathUtils.getVectorAngle((Vec3)vec.m_82548_());
    }

    public static TrainExitSide getExitSide(GlobalStation station) {
        Optional<Object> edge;
        Level level = ModCommonEvents.getPhysicalLevel();
        if (level == null || station == null || !level.m_46749_(station.getBlockEntityPos())) {
            return TrainExitSide.UNKNOWN;
        }
        Optional<Object> optional = edge = level != null ? TrainUtils.getEdge(station) : Optional.empty();
        if (!edge.isPresent()) {
            return TrainExitSide.UNKNOWN;
        }
        TrainExitSide side = TrainUtils.getTrainStationExit(station, Direction.m_122364_((double)TrainUtils.angleOn((TrackEdgePoint)station, (TrackEdge)edge.get())), level);
        return side;
    }

    public static boolean stationMatches(String stationName, String filter) {
        String regex = filter.isBlank() ? filter : "\\Q" + filter.replace("*", "\\E.*\\Q");
        return stationName.matches(regex);
    }

    public static boolean isTrainValid(Train train) {
        return !train.invalid && train.runtime.getSchedule() != null && train.graph != null;
    }

    public static boolean isTrainUsable(Train train) {
        return TrainUtils.isTrainValid(train) && TrainListener.data.containsKey(train.id) && TrainListener.data.get(train.id).isInitialized() && !TrainListener.data.get(train.id).isPreparing();
    }
}

