/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.mcdragonlib.data.Cache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TrainTravelSection {
    private static final int INVALID = -1;
    private final transient TrainData data;
    private final transient int scheduleIndex;
    private final transient boolean isDefault;
    private final boolean includeLastStationOfLastSection;
    private final boolean usable;
    private final TrainGroup trainGroup;
    private final TrainLine trainLine;
    private final Cache<List<TrainPrediction>> predictions = new Cache(() -> this.getPredictions(-1, false));
    private final Cache<TrainTravelSection> nextSection;
    private final Cache<TrainTravelSection> previousSection;

    public TrainTravelSection(TrainData data, int indexInSchedule, TrainGroup group, TrainLine line, boolean includePreviousStation, boolean usable) {
        this(false, data, indexInSchedule, group, line, includePreviousStation, usable);
    }

    private TrainTravelSection(boolean isDefault, TrainData data, int indexInSchedule, TrainGroup group, TrainLine line, boolean includePreviousStation, boolean usable) {
        this.data = data;
        this.scheduleIndex = indexInSchedule;
        this.isDefault = isDefault;
        this.trainGroup = group;
        this.trainLine = line;
        this.includeLastStationOfLastSection = includePreviousStation;
        this.usable = usable;
        this.nextSection = new Cache(() -> {
            if (data.isSingleSection()) {
                return this;
            }
            List<TrainTravelSection> sections = data.getSections();
            if (sections.isEmpty()) {
                return this;
            }
            int selfIndex = sections.indexOf(this);
            if (selfIndex < 0 || selfIndex >= sections.size()) {
                return sections.get(0);
            }
            return sections.get((selfIndex + 1) % sections.size());
        });
        this.previousSection = new Cache(() -> {
            if (data.isSingleSection()) {
                return this;
            }
            List<TrainTravelSection> sections = data.getSections();
            if (sections.isEmpty()) {
                return this;
            }
            int selfIndex = sections.indexOf(this);
            if (selfIndex < 0 || selfIndex >= sections.size()) {
                return sections.get(0);
            }
            int prevIndex = selfIndex - 1;
            return sections.get(prevIndex < 0 ? sections.size() - 1 : prevIndex);
        });
    }

    public static final TrainTravelSection def(TrainData data) {
        return new TrainTravelSection(true, data, 0, null, null, true, true);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public TrainData getData() {
        return this.data;
    }

    public int getScheduleIndex() {
        return this.scheduleIndex;
    }

    public boolean shouldIncludeNextStationOfNextSection() {
        return this.includeLastStationOfLastSection;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public TrainGroup getTrainGroup() {
        return this.trainGroup;
    }

    public TrainLine getTrainLine() {
        return this.trainLine;
    }

    public TrainTravelSection nextSection() {
        return (TrainTravelSection)this.nextSection.get();
    }

    public TrainTravelSection previousSection() {
        return (TrainTravelSection)this.previousSection.get();
    }

    public List<TrainPrediction> getPredictions(int startingAtIndex, boolean ignoreIncludeLastStationRule) {
        if (this.data.getTrain() == null || this.data.getTrain().runtime == null || this.data.getTrain().runtime.getSchedule() == null) {
            return List.of();
        }
        ArrayList<TrainPrediction> result = new ArrayList<TrainPrediction>();
        TrainTravelSection nextSection = this.nextSection();
        Map<Integer, TrainPrediction> predictions = this.data.getPredictionsRaw().entrySet().stream().filter(x -> !GlobalSettings.getInstance().isStationBlacklisted(((TrainPrediction)x.getValue()).getStationName())).collect(Collectors.toMap(x -> (Integer)x.getKey(), x -> (TrainPrediction)x.getValue()));
        int startIndex = this.getScheduleIndex();
        int stopIndex = nextSection.getScheduleIndex();
        int count = this.data.getTrain().runtime.getSchedule().entries.size();
        boolean customStartFound = false;
        boolean endReached = false;
        TrainPrediction pred = null;
        for (int i = 0; i < count * 2; ++i) {
            int j = (startIndex + i) % count;
            if (i != 0 && j == stopIndex) {
                if (!ignoreIncludeLastStationRule && this.shouldIncludeNextStationOfNextSection()) {
                    endReached = true;
                } else {
                    return result;
                }
            }
            boolean bl = customStartFound = customStartFound || startingAtIndex < 0 || j == startingAtIndex;
            if (!predictions.containsKey(j) || !customStartFound) continue;
            pred = predictions.get(j);
            result.add(pred);
            if (endReached) break;
        }
        return result;
    }

    public int getFirstIndexFor(StationTag tag) {
        return this.getPredictions(-1, false).stream().filter(x -> x.getStationTag().equals(tag)).map(x -> x.getEntryIndex()).findFirst().orElse(0);
    }

    public List<TrainStop> getAllStops(long simulationTime, int currentIndex) {
        ArrayList<TrainStop> result = new ArrayList<TrainStop>();
        List<TrainPrediction> predictions = this.getPredictions(-1, false);
        TrainStop lastStop = null;
        for (TrainPrediction prediction : predictions) {
            TrainStop stop = new TrainStop(prediction);
            stop.simulateTicks(simulationTime);
            if (lastStop != null && lastStop.getScheduledArrivalTime() > stop.getScheduledArrivalTime()) {
                if (prediction.getEntryIndex() == currentIndex) {
                    result.forEach(x -> x.simulateCycles(-1));
                } else {
                    stop.simulateCycles(1);
                }
            }
            result.add(stop);
            lastStop = stop;
        }
        return result;
    }

    public List<String> getStopovers() {
        List predictions = (List)this.predictions.get();
        return predictions.stream().limit(predictions.size() - 1).skip(1L).map(x -> x.getStationTag().getTagName().get()).toList();
    }

    public List<String> getStopoversFrom(int startIndex) {
        ArrayList<String> predictions = new ArrayList<String>();
        boolean startFound = false;
        for (int i = 0; i < ((List)this.predictions.get()).size() - 1; ++i) {
            TrainPrediction prediction = (TrainPrediction)((List)this.predictions.get()).get(i);
            boolean wasStartFound = startFound;
            if (prediction.getEntryIndex() == startIndex) {
                startFound = true;
            }
            if (!wasStartFound) continue;
            predictions.add(prediction.getStationTag().getTagName().get());
        }
        return predictions;
    }

    public Optional<TrainPrediction> getFinalStop() {
        List predictions = (List)this.predictions.get();
        return predictions.isEmpty() ? Optional.empty() : Optional.ofNullable((TrainPrediction)predictions.get(predictions.size() - 1));
    }

    public boolean isFinalStop(TrainPrediction prediction) {
        Optional<TrainPrediction> pred = this.getFinalStop();
        return pred.isPresent() && pred.get() == prediction;
    }

    public boolean isFirstStop(TrainPrediction prediction) {
        Optional<TrainPrediction> pred = this.getFirstStop();
        return pred.isPresent() && pred.get() == prediction;
    }

    public boolean isFinalStop(int scheduleIndex) {
        Optional<TrainPrediction> pred = this.getFinalStop();
        return pred.isPresent() && pred.get().getEntryIndex() == scheduleIndex;
    }

    public boolean isFirstStop(int scheduleIndex) {
        Optional<TrainPrediction> pred = this.getFirstStop();
        return pred.isPresent() && pred.get().getEntryIndex() == scheduleIndex;
    }

    public Optional<TrainPrediction> getFirstStop() {
        List predictions = (List)this.predictions.get();
        return predictions.isEmpty() ? Optional.empty() : Optional.ofNullable((TrainPrediction)predictions.get(0));
    }

    public Optional<TrainPrediction> getNextStop() {
        List predictions = (List)this.predictions.get();
        return predictions.isEmpty() ? Optional.empty() : Optional.ofNullable((TrainPrediction)predictions.get(0));
    }

    public String getDisplayText() {
        if (!this.isUsable()) {
            return ELanguage.translate("block.createrailwaysnavigator.advanced_display.ber.not_in_service").getString();
        }
        return this.getFinalStop().map(x -> GlobalSettings.getInstance().getOrCreateStationTagFor(x.getStationName()).getTagName().get()).orElse("?");
    }

    public String getDisplayTextStart() {
        return !this.isUsable() ? ELanguage.translate("block.createrailwaysnavigator.advanced_display.ber.not_in_service").getString() : this.getFirstStop().map(x -> GlobalSettings.getInstance().getOrCreateStationTagFor(x.getStationName()).getTagName().get()).orElse("?");
    }

    public String getStartStationName() {
        return this.getFirstStop().map(x -> x.getStationName()).orElse("?");
    }

    public String getDestinationStationName() {
        return this.getFinalStop().map(x -> x.getStationName()).orElse("?");
    }

    public String toString() {
        return this.getDisplayText();
    }
}

