/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.event.events.CreateTrainPredictionEvent;
import de.mrjulsen.crn.event.events.GlobalTrainDisplayDataRefreshEventPost;
import de.mrjulsen.crn.event.events.GlobalTrainDisplayDataRefreshEventPre;
import de.mrjulsen.crn.event.events.ScheduleResetEvent;
import de.mrjulsen.crn.event.events.SubmitTrainPredictionsEvent;
import de.mrjulsen.crn.event.events.TotalDurationTimeChangedEvent;
import de.mrjulsen.crn.event.events.TrainArrivalAndDepartureEvent;
import de.mrjulsen.crn.event.events.TrainDestinationChangedEvent;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.io.File;
import java.io.IOException;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.storage.LevelResource;

public final class TrainListener {
    private static final transient String FILENAME = "createrailwaysnavigator_train_data.nbt";
    public static final ConcurrentHashMap<UUID, TrainData> data = new ConcurrentHashMap();
    private static transient boolean trainDataListenerActive = false;
    private static transient long currentTrainDataListenerId = 0L;
    private static final transient Queue<Runnable> trainDataHookTasks = new ConcurrentLinkedQueue<Runnable>();

    public static void init() {
        CRNEventsManager.getEvent(GlobalTrainDisplayDataRefreshEventPre.class).register("createrailwaysnavigator", () -> TrainListener.queueTrainListenerTask(TrainListener::refreshPre));
        CRNEventsManager.getEvent(GlobalTrainDisplayDataRefreshEventPost.class).register("createrailwaysnavigator", () -> TrainListener.queueTrainListenerTask(TrainListener::refreshPost));
        CRNEventsManager.getEvent(TrainDestinationChangedEvent.class).register("createrailwaysnavigator", (train, current, next, nextIndex) -> {});
        CRNEventsManager.getEvent(TotalDurationTimeChangedEvent.class).register("createrailwaysnavigator", (train, old, newDuration) -> CreateRailwaysNavigator.LOGGER.warn("The total duration of the train " + train.name.getString() + " (" + train.id + ") has changed from " + old + " Ticks to " + newDuration + " Ticks. This will result in changes to the scheduled departure times!"));
        CRNEventsManager.getEvent(TrainArrivalAndDepartureEvent.class).register("createrailwaysnavigator", (train, station, isArrival) -> TrainListener.queueTrainListenerTask(() -> {
            if (data.containsKey(train.id)) {
                if (isArrival) {
                    data.get(train.id).reachDestination(DragonLib.getCurrentWorldTime(), ((ScheduleRuntimeAccessor)train.runtime).crn$getTicksInTransit());
                } else {
                    data.get(train.id).leaveDestination();
                }
            }
        }));
        CRNEventsManager.getEvent(ScheduleResetEvent.class).register("createrailwaysnavigator", (train, soft) -> TrainListener.queueTrainListenerTask(() -> {
            if (data.containsKey(train.id)) {
                TrainData trainData = data.get(train.id);
                if (soft) {
                    trainData.resetPredictions();
                } else {
                    trainData.hardResetPredictions();
                }
            }
        }));
        CRNEventsManager.getEvent(SubmitTrainPredictionsEvent.class).register("createrailwaysnavigator", (train, predictions, entryCount, accumulatedTime, current) -> {});
        CRNEventsManager.getEvent(CreateTrainPredictionEvent.class).register("createrailwaysnavigator", (train, schedule, predictables, index, stayDuration, minStayDuration, prediction) -> TrainListener.queueTrainListenerTask(() -> {
            ScheduleRuntimeAccessor accessor = (ScheduleRuntimeAccessor)schedule;
            UUID trainId = accessor.crn$getTrain().id;
            if (data.containsKey(trainId) && prediction != null) {
                TrainData trainData = data.get(trainId);
                TrainPrediction pred = trainData.setPredictionData(index, schedule.currentEntry, schedule.getSchedule().entries.size(), stayDuration, minStayDuration, accessor.crn$predictionTicks().get(index), prediction);
                predictables.values().forEach(x -> x.predictForStation(trainData, pred, schedule, index, accessor.crn$getTrain()));
            }
        }));
    }

    public static Set<Train> getAllTrains() {
        return data.values().stream().map(x -> x.getTrain()).collect(Collectors.toSet());
    }

    public static boolean allTrainsInitialized() {
        return data.values().stream().filter(x -> !GlobalSettings.getInstance().isTrainBlacklisted(x.getTrain()) && !x.getPredictionsRaw().isEmpty() && !x.getTrain().runtime.paused && !x.getTrain().derailed && !x.getTrain().runtime.completed && TrainUtils.isTrainValid(x.getTrain())).allMatch(x -> x.isInitialized() && !x.isPreparing());
    }

    public static void start() {
        new Thread(() -> {
            long id;
            TrainListener.init();
            while (currentTrainDataListenerId == (id = System.nanoTime())) {
            }
            currentTrainDataListenerId = id;
            trainDataListenerActive = true;
            trainDataHookTasks.clear();
            data.clear();
            try {
                TrainListener.load();
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.error("Unable to load train listener data.", (Throwable)e);
            }
            long threadId = id;
            new Thread(() -> {
                try {
                    while (currentTrainDataListenerId == threadId && trainDataListenerActive) {
                        while (!trainDataHookTasks.isEmpty()) {
                            try {
                                trainDataHookTasks.poll().run();
                            }
                            catch (Exception e) {
                                CreateRailwaysNavigator.LOGGER.error("Error while executing train listener task.", (Throwable)e);
                            }
                        }
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            CreateRailwaysNavigator.LOGGER.error("Error while waiting for next task.", (Throwable)e);
                        }
                    }
                    TrainListener.save();
                    data.clear();
                    trainDataHookTasks.clear();
                    CreateRailwaysNavigator.LOGGER.info("Train listener has been stopped.");
                }
                catch (Exception e) {
                    CreateRailwaysNavigator.LOGGER.error("Error while executing Train Listener.", (Throwable)e);
                }
            }, "CRN Train Listener").start();
            CreateRailwaysNavigator.LOGGER.info("Train listener has been started.");
        }, "CRN Train Listener Launcher").start();
    }

    public static void stop() {
        trainDataListenerActive = false;
        CreateRailwaysNavigator.LOGGER.info("Stopping train listener...");
    }

    public static synchronized void save() {
        if (!trainDataListenerActive) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        data.entrySet().forEach(x -> nbt.m_128365_(((UUID)x.getKey()).toString(), (Tag)((TrainData)x.getValue()).toNbt()));
        try {
            NbtIo.m_128944_((CompoundTag)nbt, (File)new File(ModCommonEvents.getCurrentServer().get().m_129843_(new LevelResource("data/createrailwaysnavigator_train_data.nbt")).toString()));
            CreateRailwaysNavigator.LOGGER.debug("Saved train listener data.");
        }
        catch (IOException e) {
            CreateRailwaysNavigator.LOGGER.error("Unable to save train listener data.", (Throwable)e);
        }
    }

    private static void load() throws IOException {
        File settingsFile = new File(ModCommonEvents.getCurrentServer().get().m_129843_(new LevelResource("data/createrailwaysnavigator_train_data.nbt")).toString());
        if (!settingsFile.exists()) {
            return;
        }
        CompoundTag nbt = NbtIo.m_128937_((File)settingsFile);
        for (String key : nbt.m_128431_()) {
            try {
                UUID id = UUID.fromString(key);
                data.put(id, TrainData.fromNbt(nbt.m_128469_(key)));
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.warn("Unable to read train listener train data with ID '" + key + "'.", (Throwable)e);
            }
        }
    }

    private static void queueTrainListenerTask(Runnable task) {
        trainDataHookTasks.add(task);
    }

    public static synchronized void refreshPre() {
        if (!trainDataListenerActive) {
            return;
        }
        Set<Train> trains = TrainUtils.getTrains(true);
        ((ConcurrentHashMap.CollectionView)((Object)data.keySet())).retainAll(trains.stream().filter(x -> !GlobalSettings.getInstance().isTrainBlacklisted((Train)x)).map(x -> x.id).toList());
        trains.forEach(x -> data.computeIfAbsent(x.id, a -> TrainData.of(x)).refreshPre());
    }

    public static synchronized void refreshPost() {
        if (!trainDataListenerActive) {
            return;
        }
        data.values().forEach(x -> x.refreshPost());
    }

    public static synchronized void tick() {
        if (!trainDataListenerActive) {
            return;
        }
        data.values().forEach(x -> x.tick());
    }
}

