/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DynamicDelayCondition
extends ScheduledDelay {
    public static final String NBT_MIN = "Min";

    public DynamicDelayCondition() {
        this.data.m_128405_(NBT_MIN, 5);
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)new ItemStack((ItemLike)Items.f_42351_), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + this.getId().m_135815_() + ".title"), (Object[])new Object[]{this.formatCustomTime(this.getMinValue(), true), this.formatTime(true)}));
    }

    protected Component formatCustomTime(int time, boolean compact) {
        if (compact) {
            return Components.literal((String)(time + this.getUnit().suffix));
        }
        return Components.literal((String)(time + " ")).m_7220_((Component)Lang.translateDirect((String)this.getUnit().key, (Object[])new Object[0]));
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_())), (Object)Lang.translateDirect((String)"schedule.condition.for_x_time", (Object[])new Object[]{this.formatTime(false)}).m_130940_(ChatFormatting.DARK_AQUA), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".at_least"), (Object[])new Object[]{this.formatCustomTime(this.getMinValue(), false)}).m_130940_(ChatFormatting.DARK_AQUA));
    }

    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        TrainData data;
        Optional<TrainPrediction> pred;
        int time = context.m_128451_("Time");
        long currentDelay = 0L;
        long scheduledDepartureTime = 0L;
        boolean initialized = false;
        if (TrainListener.data.containsKey(train.id) && (pred = (data = TrainListener.data.get(train.id)).getNextStopPrediction()).isPresent()) {
            currentDelay = pred.get().getArrivalTimeDeviation();
            initialized = data.isInitialized() && !data.isPreparing();
            scheduledDepartureTime = pred.get().getScheduledDepartureTime();
        }
        if (!((long)time < (initialized ? Math.max((long)this.totalWaitTicks() - currentDelay, (long)this.minWaitTicks()) : (long)this.totalWaitTicks()) || initialized && DragonLib.getCurrentWorldTime() < scheduledDepartureTime)) {
            return true;
        }
        context.m_128405_("Time", time + 1);
        this.requestDisplayIfNecessary(context, time);
        return false;
    }

    public ResourceLocation getId() {
        return new ResourceLocation("createrailwaysnavigator", "dynamic_delay");
    }

    public int getMinValue() {
        return this.intData(NBT_MIN);
    }

    public int minWaitTicks() {
        return this.getMinValue() * this.getUnit().ticksPer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initDynamicDelayCondition(this, builder);
    }
}

