/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.mcdragonlib.data.Cache;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class TrainSchedule {
    private final UUID sessionId;
    private final Train train;
    private final List<TrainStop> stops;
    private final Cache<List<TrainStop>> stopsChronologically = new Cache(() -> this.getAllStops().stream().sorted((a, b) -> Long.compare(a.getScheduledArrivalTime(), b.getScheduledArrivalTime())).toList());
    private boolean simulated;
    private long simulationTime;

    private TrainSchedule(UUID sessionId, Train train, List<TrainStop> stops) {
        this.sessionId = sessionId;
        this.train = train;
        this.stops = stops;
    }

    public TrainSchedule(UUID sessionId, Train train) {
        this(TrainListener.data.get(train.id).getSessionId(), train, TrainListener.data.get(train.id).getPredictions().stream().map(x -> new TrainStop((TrainPrediction)x)).toList());
    }

    public static TrainSchedule empty() {
        return new TrainSchedule(new UUID(0L, 0L), null, List.of());
    }

    public static TrainSchedule ofSectionForIndex(UUID sessionId, Train train, int stationSectionIndex, int targetStationIndex, long simulationTime) {
        return new TrainSchedule(sessionId, train, TrainListener.data.get(train.id).getSectionForIndex(stationSectionIndex).getAllStops(simulationTime, targetStationIndex));
    }

    public List<TrainStop> getAllStops() {
        return this.stops;
    }

    public List<TrainStop> getAllStopsChronologically() {
        return (List)this.stopsChronologically.get();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public Train getTrain() {
        return this.train;
    }

    public boolean stopsAt(StationTag tag) {
        return this.stops.stream().anyMatch(x -> x.getTag().equals(tag));
    }

    public TrainSchedule simulate(long ticks) {
        this.simulated = true;
        this.simulationTime += ticks;
        return new TrainSchedule(this.sessionId, this.train, this.stops.stream().map(x -> x.copy()).peek(x -> x.simulateTicks(ticks)).toList());
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public long getSimulationTime() {
        return this.simulationTime;
    }

    public boolean isEqual(TrainSchedule other) {
        if (other == null) {
            return false;
        }
        if (this.getAllStops().size() != other.getAllStops().size()) {
            return false;
        }
        HashSet tagsA = new HashSet();
        HashSet tagsB = new HashSet();
        this.getAllStops().stream().forEach(x -> tagsA.add(x.getTag().getTagName().get()));
        other.getAllStops().stream().forEach(x -> tagsB.add(x.getTag().getTagName().get()));
        return tagsA.size() == tagsB.size() && tagsA.stream().allMatch(x -> tagsB.contains(x));
    }
}

