/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.data.ISaveableNavigatorData;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class Route
implements ISaveableNavigatorData {
    protected static final String NBT_PARTS = "Parts";
    protected final List<RoutePart> parts;
    protected final List<TransferConnection> connections;
    protected final Cache<Boolean> isCancelled = new Cache(() -> this.getParts().stream().anyMatch(x -> x.isCancelled()));

    public Route(List<RoutePart> parts, boolean realTimeTracker) {
        this.parts = parts;
        this.connections = TransferConnection.getConnections(parts);
    }

    public static Route empty(boolean realTimeTracker) {
        return new Route(List.of(), realTimeTracker);
    }

    public List<TransferConnection> getConnections() {
        return this.connections;
    }

    public Optional<TransferConnection> getConnectionWith(TrainStop stop) {
        return this.getConnections().stream().filter(x -> x.getArrivalStation() == stop || x.getDepartureStation() == stop).findFirst();
    }

    public RoutePart getFirstPart() {
        return this.parts.get(0);
    }

    public RoutePart getLastPart() {
        return this.parts.get(this.parts.size() - 1);
    }

    public TrainStop getStart() {
        return this.getFirstPart().getFirstStop();
    }

    public TrainStop getEnd() {
        return this.getLastPart().getLastStop();
    }

    public ImmutableList<RoutePart> getParts() {
        return ImmutableList.copyOf(this.parts);
    }

    public int getTransferCount() {
        return this.parts.size() - 1;
    }

    public long departureIn() {
        return this.getFirstPart().departureIn();
    }

    public long arrivalAtDestinationIn() {
        return this.getLastPart().timeUntilEnd();
    }

    public long travelTime() {
        return this.arrivalAtDestinationIn() - this.departureIn();
    }

    public boolean isAnyCancelled() {
        return (Boolean)this.isCancelled.get();
    }

    public boolean isPartReachable(RoutePart part) {
        int idx = this.parts.indexOf(part);
        if (idx <= 0) {
            return true;
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            if (!this.connections.get(i).isConnectionMissed()) continue;
            return i >= idx;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ROUTE[" + this.getStart().getClientTag().tagName() + " -> " + this.getEnd().getClientTag().tagName() + "]");
        return builder.toString();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        list.addAll(this.parts.stream().map(x -> x.toNbt()).toList());
        nbt.m_128365_(NBT_PARTS, (Tag)list);
        return nbt;
    }

    public static Route fromNbt(CompoundTag nbt, boolean realTimeTracker) {
        return new Route(nbt.m_128437_(NBT_PARTS, 10).stream().map(x -> RoutePart.fromNbt((CompoundTag)x)).toList(), realTimeTracker);
    }

    @Override
    public List<ISaveableNavigatorData.SaveableNavigatorDataLine> getOverviewData() {
        ArrayList<ISaveableNavigatorData.SaveableNavigatorDataLine> lines = new ArrayList<ISaveableNavigatorData.SaveableNavigatorDataLine>();
        lines.add(new ISaveableNavigatorData.SaveableNavigatorDataLine((Component)TextUtils.text((String)(ModUtils.formatTime(this.getStart().getScheduledDepartureTime(), false) + "   " + this.getStart().getClientTag().tagName())), ModGuiIcons.ROUTE_START.getAsSprite(16, 16)));
        lines.add(new ISaveableNavigatorData.SaveableNavigatorDataLine((Component)TextUtils.text((String)(ModUtils.formatTime(this.getEnd().getScheduledArrivalTime(), false) + "   " + this.getEnd().getClientTag().tagName())), ModGuiIcons.ROUTE_END.getAsSprite(16, 16)));
        lines.add(new ISaveableNavigatorData.SaveableNavigatorDataLine((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.date", (Object[])new Object[]{(this.getStart().getScheduledDepartureTime() + 6000L) / 24000L, ModUtils.formatTime(this.getStart().getScheduledDepartureTime(), false)}).m_130946_(" | ").m_130946_(TimeUtils.parseDurationShort((long)this.departureIn())), ModGuiIcons.CALENDAR.getAsSprite(16, 16)));
        lines.add(new ISaveableNavigatorData.SaveableNavigatorDataLine((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.transfers", (Object[])new Object[]{this.getTransferCount()}).m_7220_((Component)TextUtils.text((String)(" | " + TimeUtils.parseDurationShort((long)this.travelTime())))), ModGuiIcons.INFO.getAsSprite(16, 16)));
        if (this.isAnyCancelled()) {
            lines.add(new ISaveableNavigatorData.SaveableNavigatorDataLine((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.cancelled").m_130940_(ChatFormatting.RED), ModGuiIcons.IMPORTANT.getAsSprite(16, 16)));
        }
        return lines;
    }

    @Override
    public ISaveableNavigatorData.SaveableNavigatorDataLine getTitle() {
        return new ISaveableNavigatorData.SaveableNavigatorDataLine((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.saved_route"), ModGuiIcons.BOOKMARK.getAsSprite(16, 16));
    }

    @Override
    public long timeOrderValue() {
        return this.getStart().getScheduledDepartureTime();
    }
}

