/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.google.common.base.Objects;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.navigation.EdgeData;
import de.mrjulsen.crn.data.train.TrainPrediction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Node
implements Comparable<Node> {
    private final StationTag tag;
    private final Map<UUID, TrainPrediction> departingTrains = new HashMap<UUID, TrainPrediction>();
    private long cost = Long.MAX_VALUE;
    private Node previousNode = null;
    private Node nextNode = null;
    private final Set<EdgeConnection> connections = new HashSet<EdgeConnection>();
    private final Set<EdgeConnection> nextConnections = new HashSet<EdgeConnection>();
    private final Map<Node, EdgeConnection> preferredConnectionForNode = new HashMap<Node, EdgeConnection>();
    private boolean isTransferPoint = false;

    public Node(TrainPrediction prediction) {
        this.tag = prediction.getStationTag();
    }

    public void addTrain(TrainPrediction prediction) {
        this.departingTrains.put(prediction.getData().getTrainId(), prediction);
    }

    public Map<UUID, TrainPrediction> getIdsOfDepartingTrains() {
        return this.departingTrains;
    }

    public StationTag getStationTag() {
        return this.tag;
    }

    public long getCost() {
        return this.cost;
    }

    public boolean setCost(long cost) {
        boolean b;
        boolean bl = b = this.cost != cost;
        if (b) {
            this.connections.clear();
            this.preferredConnectionForNode.clear();
        }
        this.cost = cost;
        return b;
    }

    public Node getPreviousNode() {
        return this.previousNode;
    }

    public void setConnection(Node previousNode, EdgeData viaEdge, long cost) {
        if (cost > this.cost) {
            return;
        }
        this.setCost(cost);
        if (viaEdge != null) {
            this.connections.add(new EdgeConnection(previousNode, viaEdge));
        }
        this.setPreviousNode(previousNode);
    }

    public void setPreviousNode(Node previousNode) {
        this.previousNode = previousNode;
    }

    public void setNextNode(Node nextNode) {
        this.nextNode = nextNode;
        nextNode.getConnections().stream().filter(x -> x.target() == this).forEach(x -> this.nextConnections.add(new EdgeConnection(nextNode, x.edge().invert())));
    }

    public Node getNextNode() {
        return this.nextNode;
    }

    public boolean isTransferPoint() {
        return this.isTransferPoint;
    }

    public void setTransferPoint(boolean isTransferPoint) {
        this.isTransferPoint = isTransferPoint;
    }

    public boolean hasConnections() {
        return !this.connections.isEmpty();
    }

    @Override
    public int compareTo(Node o) {
        return Long.compare(this.cost, o.cost);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Node)) return false;
        Node o = (Node)obj;
        if (!this.tag.equals(o.tag)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tag});
    }

    public void init() {
        this.cost = Long.MAX_VALUE;
        this.previousNode = null;
        this.isTransferPoint = false;
        this.connections.clear();
        this.preferredConnectionForNode.clear();
    }

    public EdgeConnection selectBestConnectionFor(Node nextNode, EdgeData nextEdge) {
        if (!this.hasConnections()) {
            return null;
        }
        EdgeConnection possibleConnection = this.getPreviousNode() == null ? null : this.getPreviousNode().getPreferredConnectionFor(this);
        for (EdgeConnection connection : this.connections) {
            if (connection.edge() == null || !connection.edge().connected(nextEdge)) continue;
            possibleConnection = connection;
            break;
        }
        if (possibleConnection == null) {
            return null;
        }
        this.preferredConnectionForNode.put(nextNode, possibleConnection);
        return possibleConnection;
    }

    public EdgeConnection getPreferredConnectionFor(Node node) {
        return this.preferredConnectionForNode.getOrDefault(node, this.connections.stream().findFirst().orElse(null));
    }

    public Set<EdgeConnection> getConnections() {
        return this.connections;
    }

    public Set<EdgeConnection> getNextConnections() {
        return this.nextConnections;
    }

    public static class EdgeConnection {
        private final Node target;
        private final EdgeData edge;

        public EdgeConnection(Node target, EdgeData edge) {
            this.target = target;
            this.edge = edge;
        }

        public Node target() {
            return this.target;
        }

        public EdgeData edge() {
            return this.edge;
        }
    }
}

