/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class ClientTrainListener {
    private static final ConcurrentHashMap<UUID, ConcurrentHashMap<UUID, Pair<UUID, Consumer<ClientRoutePart.TrainRealTimeData>>>> callbacks = new ConcurrentHashMap();

    public static int debug_registeredListenersCount() {
        return callbacks.values().stream().mapToInt(x -> x.size()).sum();
    }

    public static UUID register(UUID sessionId, UUID trainId, Consumer<ClientRoutePart.TrainRealTimeData> callback) {
        Map trainCallbacks = callbacks.computeIfAbsent(trainId, x -> new ConcurrentHashMap());
        UUID id = null;
        while (trainCallbacks.containsKey(id = UUID.randomUUID())) {
        }
        trainCallbacks.put(id, Pair.of((Object)sessionId, callback));
        return id;
    }

    public static void unregister(UUID trainId, UUID callbackId) {
        if (callbacks.containsKey(trainId)) {
            Map trainCallbacks = callbacks.get(trainId);
            if (trainCallbacks.containsKey(callbackId)) {
                trainCallbacks.remove(callbackId);
            }
            if (trainCallbacks.isEmpty()) {
                callbacks.remove(trainId);
            }
        }
    }

    public static void tick(Runnable andThen) {
        callbacks.entrySet().stream().forEach(x -> {
            if (((ConcurrentHashMap)x.getValue()).isEmpty()) {
                callbacks.remove(x.getKey());
                return;
            }
            Map listeners = (Map)x.getValue();
            DataAccessor.getFromServer((Object)((UUID)x.getKey()), ModAccessorTypes.UPDATE_REALTIME, res -> {
                if (res != null) {
                    new ArrayList(listeners.values()).stream().forEach(a -> ((Consumer)a.getSecond()).accept(res));
                }
                DLUtils.doIfNotNull((Object)andThen, a -> a.run());
            });
        });
    }

    public static void clear() {
        callbacks.clear();
    }
}

