/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.navigation.ITrainListenerClient;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.RoutePartProgressState;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.util.IListenable;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.Single;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ClientRoutePart
extends RoutePart
implements ITrainListenerClient<TrainRealTimeData>,
IListenable<ListenerNotificationData> {
    public static final String EVENT_UPDATE = "update";
    public static final String EVENT_ANNOUNCE_START = "announce_start";
    public static final String EVENT_ARRIVAL_AT_START = "arrival_at_start";
    public static final String EVENT_DEPARTURE_FROM_START = "departure_at_start";
    public static final String EVENT_WHILE_TRANSIT = "while_transit";
    public static final String EVENT_NEXT_STOP_ANNOUNCED = "next_stop_announced";
    public static final String EVENT_ARRIVAL_AT_STOPOVER = "arrival_at_stopover";
    public static final String EVENT_DEPARTURE_FROM_STOPOVER = "departure_at_stopover";
    public static final String EVENT_LAST_STOP_ANNOUNCED = "last_stop_announced";
    public static final String EVENT_ARRIVAL_AT_LAST_STOP = "arrival_at_last_stop";
    public static final String EVENT_DEPARTURE_FROM_LAST_STOP = "departure_at_last_stop";
    public static final String EVENT_FIRST_STOP_STATION_CHANGED = "first_stop_station_changed";
    public static final String EVENT_FIRST_STOP_DELAYED = "first_stop_delayed";
    public static final String EVENT_LAST_STOP_STATION_CHANGED = "last_stop_station_changed";
    public static final String EVENT_LAST_STOP_DELAYED = "last_stop_delayed";
    public static final String EVENT_ANY_STOP_ANNOUNCED = "any_stop_announced";
    public static final String EVENT_ARRIVAL_AT_ANY_STOP = "arrival_at_any_stop";
    public static final String EVENT_DEPARTURE_FROM_ANY_STOP = "departure_at_any_stop";
    public static final String EVENT_SCHEDULE_CHANGED = "schedule_changed";
    public static final String EVENT_TRAIN_CANCELLED = "train_cancelled";
    private final Map<String, IdentityHashMap<Object, Consumer<ListenerNotificationData>>> listeners = new HashMap<String, IdentityHashMap<Object, Consumer<ListenerNotificationData>>>();
    private RoutePartProgressState progressState = RoutePartProgressState.BEFORE;
    private ClientTrainStop nextStop;
    private final Queue<QueuedAnnouncementEvent> queuedAnnouncements = new ConcurrentLinkedQueue<QueuedAnnouncementEvent>();
    private final Cache<List<ClientTrainStop>> clientTrainStops = new Cache(() -> this.getAllStops().stream().filter(x -> x instanceof ClientTrainStop).map(x -> (ClientTrainStop)x).toList());
    private final Cache<List<ClientTrainStop>> clientJourneyStops = new Cache(() -> this.getAllJourneyStops().stream().filter(x -> x instanceof ClientTrainStop).map(x -> (ClientTrainStop)x).toList());

    public ClientRoutePart(UUID sessionId, UUID trainId, List<TrainStop> routeStops, List<TrainStop> allStops) {
        super(sessionId, trainId, routeStops, allStops);
        this.nextStop = this.getFirstClientStop();
        this.createEvent(EVENT_UPDATE);
        this.createEvent(EVENT_ANNOUNCE_START);
        this.createEvent(EVENT_ARRIVAL_AT_START);
        this.createEvent(EVENT_DEPARTURE_FROM_START);
        this.createEvent(EVENT_WHILE_TRANSIT);
        this.createEvent(EVENT_NEXT_STOP_ANNOUNCED);
        this.createEvent(EVENT_ARRIVAL_AT_STOPOVER);
        this.createEvent(EVENT_DEPARTURE_FROM_STOPOVER);
        this.createEvent(EVENT_LAST_STOP_ANNOUNCED);
        this.createEvent(EVENT_ARRIVAL_AT_LAST_STOP);
        this.createEvent(EVENT_DEPARTURE_FROM_LAST_STOP);
        this.createEvent(EVENT_FIRST_STOP_STATION_CHANGED);
        this.createEvent(EVENT_FIRST_STOP_DELAYED);
        this.createEvent(EVENT_LAST_STOP_STATION_CHANGED);
        this.createEvent(EVENT_LAST_STOP_DELAYED);
        this.createEvent(EVENT_ANY_STOP_ANNOUNCED);
        this.createEvent(EVENT_ARRIVAL_AT_ANY_STOP);
        this.createEvent(EVENT_DEPARTURE_FROM_ANY_STOP);
        this.createEvent(EVENT_SCHEDULE_CHANGED);
        this.createEvent(EVENT_TRAIN_CANCELLED);
        this.getFirstClientStop().listen("announce_next_stop", this, x -> this.notifyListeners(EVENT_ANNOUNCE_START, new ListenerNotificationData(this, (ClientTrainStop)x)));
        this.getFirstClientStop().listen("station_reached", this, x -> {
            this.progressState = RoutePartProgressState.AT_START;
            this.notifyListeners(EVENT_ARRIVAL_AT_START, new ListenerNotificationData(this, (ClientTrainStop)x));
            this.notifyListeners(EVENT_ARRIVAL_AT_ANY_STOP, new ListenerNotificationData(this, (ClientTrainStop)x));
        });
        this.getFirstClientStop().listen("station_left", this, x -> {
            this.progressState = RoutePartProgressState.TRAVELING;
            this.notifyListeners(EVENT_DEPARTURE_FROM_START, new ListenerNotificationData(this, (ClientTrainStop)x));
            this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_STOP, new ListenerNotificationData(this, (ClientTrainStop)x));
        });
        this.getFirstClientStop().listen("delayed", this, x -> this.notifyListeners(EVENT_FIRST_STOP_DELAYED, new ListenerNotificationData(this, (ClientTrainStop)x)));
        this.getFirstClientStop().listen("station_changed", this, x -> this.notifyListeners(EVENT_FIRST_STOP_STATION_CHANGED, new ListenerNotificationData(this, (ClientTrainStop)x)));
        for (ClientTrainStop stop : this.getClientStopovers()) {
            stop.listen("announce_next_stop", this, x -> this.queuedAnnouncements.add(new QueuedAnnouncementEvent(() -> {
                this.progressState = RoutePartProgressState.NEXT_STOP_ANNOUNCED;
                this.notifyListeners(EVENT_NEXT_STOP_ANNOUNCED, new ListenerNotificationData(this, (ClientTrainStop)x));
                this.notifyListeners(EVENT_ANY_STOP_ANNOUNCED, new ListenerNotificationData(this, (ClientTrainStop)x));
            }, (ClientTrainStop)x)));
            stop.listen("station_reached", this, x -> {
                this.progressState = RoutePartProgressState.AT_STOPOVER;
                this.notifyListeners(EVENT_ARRIVAL_AT_STOPOVER, new ListenerNotificationData(this, (ClientTrainStop)x));
                this.notifyListeners(EVENT_ARRIVAL_AT_ANY_STOP, new ListenerNotificationData(this, (ClientTrainStop)x));
            });
            stop.listen("station_left", this, x -> {
                this.progressState = RoutePartProgressState.TRAVELING;
                this.notifyListeners(EVENT_DEPARTURE_FROM_STOPOVER, new ListenerNotificationData(this, (ClientTrainStop)x));
                this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_STOP, new ListenerNotificationData(this, (ClientTrainStop)x));
            });
        }
        this.getLastClientStop().listen("announce_next_stop", this, x -> this.queuedAnnouncements.add(new QueuedAnnouncementEvent(() -> {
            this.progressState = RoutePartProgressState.END_ANNOUNCED;
            this.notifyListeners(EVENT_LAST_STOP_ANNOUNCED, new ListenerNotificationData(this, (ClientTrainStop)x));
            this.notifyListeners(EVENT_ANY_STOP_ANNOUNCED, new ListenerNotificationData(this, (ClientTrainStop)x));
        }, (ClientTrainStop)x)));
        this.getLastClientStop().listen("station_reached", this, x -> {
            this.progressState = RoutePartProgressState.AT_END;
            this.queuedAnnouncements.clear();
            this.notifyListeners(EVENT_ARRIVAL_AT_LAST_STOP, new ListenerNotificationData(this, (ClientTrainStop)x));
            this.notifyListeners(EVENT_ARRIVAL_AT_ANY_STOP, new ListenerNotificationData(this, (ClientTrainStop)x));
        });
        this.getLastClientStop().listen("station_left", this, x -> {
            this.progressState = RoutePartProgressState.AFTER;
            this.queuedAnnouncements.clear();
            this.notifyListeners(EVENT_DEPARTURE_FROM_LAST_STOP, new ListenerNotificationData(this, (ClientTrainStop)x));
            this.notifyListeners(EVENT_DEPARTURE_FROM_ANY_STOP, new ListenerNotificationData(this, (ClientTrainStop)x));
            this.close();
        });
        this.getLastClientStop().listen("delayed", this, x -> this.notifyListeners(EVENT_LAST_STOP_DELAYED, new ListenerNotificationData(this, (ClientTrainStop)x)));
        this.getLastClientStop().listen("station_changed", this, x -> this.notifyListeners(EVENT_LAST_STOP_STATION_CHANGED, new ListenerNotificationData(this, (ClientTrainStop)x)));
        this.getAllClientStops().stream().forEach(x -> x.listen(EVENT_SCHEDULE_CHANGED, this, a -> this.notifyListeners(EVENT_SCHEDULE_CHANGED, new ListenerNotificationData(this, (ClientTrainStop)a))));
        this.listen(EVENT_DEPARTURE_FROM_ANY_STOP, this, p -> {
            int idx = routeStops.indexOf(p.trainStop());
            this.nextStop = idx < 0 || idx >= routeStops.size() - 1 ? p.trainStop() : (ClientTrainStop)routeStops.get(idx + 1);
        });
    }

    @Override
    public Map<String, IdentityHashMap<Object, Consumer<ListenerNotificationData>>> getListeners() {
        return this.listeners;
    }

    public List<ClientTrainStop> getAllJourneyClientStops() {
        return (List)this.clientJourneyStops.get();
    }

    public List<ClientTrainStop> getAllClientStops() {
        return (List)this.clientTrainStops.get();
    }

    public List<ClientTrainStop> getClientStopovers() {
        return this.getAllClientStops().size() <= 2 ? List.of() : ImmutableList.copyOf(this.getAllClientStops().subList(1, this.routeStops.size() - 1));
    }

    public ClientTrainStop getFirstClientStop() {
        return this.getAllClientStops().get(0);
    }

    public ClientTrainStop getLastClientStop() {
        return this.getAllClientStops().get(this.getAllClientStops().size() - 1);
    }

    public ClientTrainStop getNextStop() {
        return this.nextStop;
    }

    public int getNextStopIndex() {
        return this.routeStops.indexOf(this.nextStop);
    }

    public RoutePartProgressState getProgressState() {
        return this.progressState;
    }

    @Override
    public void update(TrainRealTimeData data) {
        if (this.isCancelled()) {
            return;
        }
        this.status.clear();
        if (!data.sessionId().equals(this.getSessionId())) {
            this.cancelled = true;
        }
        Single.MutableSingle shouldRenderStatus = new Single.MutableSingle((Object)false);
        this.getAllClientStops().stream().forEach(x -> {
            if (data.stationData().containsKey(x.getScheduleIndex())) {
                x.update(data.stationData().get(x.getScheduleIndex()));
                if (x.shouldRenderRealTime()) {
                    shouldRenderStatus.setFirst((Object)true);
                }
            }
        });
        this.getAllJourneyClientStops().stream().forEach(x -> {
            if (data.stationData().containsKey(x.getScheduleIndex())) {
                x.update(data.stationData().get(x.getScheduleIndex()));
            }
        });
        if (((Boolean)shouldRenderStatus.getFirst()).booleanValue() || data.cancelled()) {
            this.status.addAll(data.statusInfo());
        }
        this.cancelled = this.cancelled || data.cancelled();
        this.notifyListeners(EVENT_UPDATE, new ListenerNotificationData(this, this.nextStop));
        if (this.getProgressState() == RoutePartProgressState.TRAVELING) {
            QueuedAnnouncementEvent event;
            this.notifyListeners(EVENT_WHILE_TRANSIT, new ListenerNotificationData(this, this.nextStop));
            while (!this.queuedAnnouncements.isEmpty() && this.routeStops.indexOf((event = this.queuedAnnouncements.peek()).trainStop()) <= this.getNextStopIndex()) {
                event = this.queuedAnnouncements.poll();
                if (this.getNextStop() != event.trainStop()) continue;
                event.callback().run();
                break;
            }
        }
        if (this.isCancelled()) {
            CreateRailwaysNavigator.LOGGER.info("Train got cancelled. Closing route...");
            this.notifyListeners(EVENT_TRAIN_CANCELLED, new ListenerNotificationData(this, this.nextStop));
            this.close();
        }
    }

    public static RoutePart fromNbt(CompoundTag nbt) {
        return new ClientRoutePart(nbt.m_128441_("SessionId") ? nbt.m_128342_("SessionId") : new UUID(0L, 0L), nbt.m_128342_("TrainId"), nbt.m_128437_("Stops", 10).stream().map(x -> ClientTrainStop.fromNbt((CompoundTag)x)).toList(), nbt.m_128437_("EntireJourney", 10).stream().map(x -> ClientTrainStop.fromNbt((CompoundTag)x)).toList());
    }

    @Override
    public void close() {
        this.getAllClientStops().stream().forEach(x -> {
            x.stopListeningAll(this);
            x.close();
        });
        this.getAllJourneyClientStops().stream().forEach(x -> {
            x.stopListeningAll(this);
            x.close();
        });
        this.stopListeningAll(this);
    }

    public record TrainRealTimeData(UUID sessionId, Map<Integer, ClientTrainStop.TrainStopRealTimeData> stationData, Set<TrainStatus.CompiledTrainStatus> statusInfo, boolean cancelled) {
        private static final String NBT_SESSION_ID = "SessionId";
        private static final String NBT_STATUS_INFOS = "Status";
        private static final String NBT_CANCELLED = "Cancelled";

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_(NBT_SESSION_ID, this.sessionId);
            ListTag status = new ListTag();
            status.addAll(this.statusInfo().stream().map(x -> x.toNbt()).toList());
            nbt.m_128365_(NBT_STATUS_INFOS, (Tag)status);
            nbt.m_128379_(NBT_CANCELLED, this.cancelled);
            for (Map.Entry<Integer, ClientTrainStop.TrainStopRealTimeData> e : this.stationData.entrySet()) {
                nbt.m_128365_("" + e.getKey(), (Tag)e.getValue().toNbt());
            }
            return nbt;
        }

        public static TrainRealTimeData fromNbt(CompoundTag nbt) {
            return new TrainRealTimeData(nbt.m_128342_(NBT_SESSION_ID), nbt.m_128431_().stream().filter(x -> {
                try {
                    Integer.parseInt(x);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toMap(x -> Integer.parseInt(x), x -> ClientTrainStop.TrainStopRealTimeData.fromNbt(nbt.m_128469_(x)))), nbt.m_128437_(NBT_STATUS_INFOS, 10).stream().map(x -> TrainStatus.CompiledTrainStatus.fromNbt((CompoundTag)x)).collect(Collectors.toSet()), nbt.m_128471_(NBT_CANCELLED));
        }
    }

    public record ListenerNotificationData(ClientRoutePart part, ClientTrainStop trainStop) {
    }

    public record QueuedAnnouncementEvent(Runnable callback, ClientTrainStop trainStop) {
    }
}

