/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class StationTag {
    public static final int MAX_NAME_LENGTH = 32;
    private static final String LEGACY_NBT_TAG_NAME = "AliasName";
    private static final String NBT_ID = "Id";
    private static final String NBT_TAG_NAME = "TagName";
    private static final String NBT_STATION_LIST = "Stations";
    private static final String NBT_STATION_MAP = "StationData";
    private static final String NBT_LAST_EDITOR = "LastEditor";
    private static final String NBT_LAST_EDITED_TIME = "LastEditedTimestamp";
    private static final String NBT_STATION_ENTRY_NAME = "Name";
    protected UUID id;
    protected TagName tagName;
    protected Map<String, StationInfo> stations = new HashMap<String, StationInfo>();
    protected String lastEditorName = null;
    protected long lastEditedTime = 0L;

    protected StationTag(UUID id, TagName tagName, Map<String, StationInfo> initialValues, String lastEditorName, long lastEditedTime) {
        this(id, tagName, initialValues);
        this.lastEditorName = lastEditorName;
        this.lastEditedTime = lastEditedTime;
    }

    public StationTag(UUID id, TagName tagName, Map<String, StationInfo> initialValues) {
        this(id, tagName);
        this.stations.putAll(initialValues);
    }

    public StationTag(UUID id, TagName tagName) {
        this.id = id;
        this.tagName = tagName;
        this.updateLastEdited("Server");
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public StationTag copy() {
        return new StationTag(null, new TagName(this.getTagName().get()), new HashMap<String, StationInfo>(this.getAllStations()));
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.tagName == null) {
            return nbt;
        }
        DLUtils.doIfNotNull((Object)this.id, i -> nbt.m_128362_(NBT_ID, i));
        nbt.m_128365_(NBT_TAG_NAME, (Tag)this.getTagName().toNbt());
        if (this.lastEditorName != null) {
            nbt.m_128359_(NBT_LAST_EDITOR, this.getLastEditorName());
        }
        nbt.m_128356_(NBT_LAST_EDITED_TIME, this.lastEditedTime);
        ListTag stationsList = new ListTag();
        this.stations.forEach((key, value) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128359_(NBT_STATION_ENTRY_NAME, key);
            value.writeNbt(entry);
            stationsList.add((Object)entry);
        });
        nbt.m_128365_(NBT_STATION_MAP, (Tag)stationsList);
        return nbt;
    }

    public static StationTag fromNbt(CompoundTag nbt, UUID overwriteId) {
        UUID id = overwriteId == null ? (nbt.m_128441_(NBT_ID) ? nbt.m_128342_(NBT_ID) : null) : overwriteId;
        TagName name = TagName.fromNbt(nbt.m_128469_(!nbt.m_128441_(NBT_TAG_NAME) ? LEGACY_NBT_TAG_NAME : NBT_TAG_NAME));
        String lastEditorName = nbt.m_128441_(NBT_LAST_EDITOR) ? nbt.m_128461_(NBT_LAST_EDITOR) : null;
        long lastEditedTime = nbt.m_128454_(NBT_LAST_EDITED_TIME);
        AbstractMap stations = nbt.m_128441_(NBT_STATION_LIST) ? new HashMap<String, StationInfo>(nbt.m_128437_(NBT_STATION_LIST, 8).stream().map(x -> ((StringTag)x).m_7916_()).collect(Collectors.toMap(x -> x, x -> StationInfo.empty()))) : (nbt.m_128441_(NBT_STATION_MAP) ? new HashMap<String, StationInfo>(nbt.m_128437_(NBT_STATION_MAP, 10).stream().map(x -> (CompoundTag)x).collect(Collectors.toMap(x -> x.m_128461_(NBT_STATION_ENTRY_NAME), x -> StationInfo.fromNbt(x)))) : new IdentityHashMap<String, StationInfo>());
        return new StationTag(id, name, stations, lastEditorName, lastEditedTime);
    }

    public String getLastEditorName() {
        return this.lastEditorName;
    }

    public void updateLastEdited(String name) {
        this.lastEditorName = name;
        this.lastEditedTime = new Date().getTime();
    }

    public Date getLastEditedTime() {
        return new Date(this.lastEditedTime);
    }

    public String getLastEditedTimeFormatted() {
        return DragonLib.DATE_FORMAT.format(this.getLastEditedTime());
    }

    public TagName getTagName() {
        return this.tagName;
    }

    public void updateInfoForStation(String station, StationInfo info) {
        if (this.stations.containsKey(station)) {
            this.stations.replace(station, info);
        }
    }

    public void add(String station, StationInfo info) {
        if (!this.stations.containsKey(station)) {
            this.stations.put(station, info);
        }
    }

    public void addAll(Map<String, StationInfo> stations) {
        stations.forEach((key, value) -> {
            if (!this.stations.containsKey(key)) {
                this.stations.put((String)key, (StationInfo)value);
            }
        });
    }

    public boolean contains(String stationName) {
        String regex = stationName.isBlank() ? stationName : "\\Q" + stationName.replace("*", "\\E.*\\Q");
        return this.stations.keySet().stream().anyMatch(x -> x.matches(regex));
    }

    public Set<String> getAllStationNames() {
        return Set.copyOf(this.stations.keySet());
    }

    public Map<String, StationInfo> getAllStations() {
        return Map.copyOf(this.stations);
    }

    public StationInfo getInfoForStation(String stationName) {
        return this.stations.containsKey(stationName) ? this.stations.get(stationName) : StationInfo.empty();
    }

    public void setName(TagName name) {
        this.tagName = name;
    }

    public void remove(String station) {
        this.stations.remove(station);
    }

    public ClientStationTag getClientTag(String station) {
        return new ClientStationTag(this.getTagName().get(), station, this.getInfoForStation(station), this.getId());
    }

    public String toString() {
        return this.getTagName().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StationTag) {
            StationTag alias = (StationTag)obj;
            return this.getTagName().equals(alias.getTagName()) && this.getAllStationNames().size() == alias.getAllStationNames().size() && this.getAllStationNames().stream().allMatch(x -> alias.contains((String)x));
        }
        return false;
    }

    public int hashCode() {
        return 7 * Objects.hash(this.tagName);
    }

    public void applyFrom(StationTag newData) {
        this.tagName = newData.tagName;
        this.stations.clear();
        this.stations.putAll(newData.stations);
        this.lastEditedTime = newData.lastEditedTime;
        this.lastEditorName = newData.lastEditorName;
    }

    public record StationInfo(String platform) {
        public static final int MAX_PLATFORM_NAME_LENGTH = 8;
        private static final String NBT_PLATFORM = "Platform";

        public static StationInfo empty() {
            return new StationInfo("");
        }

        public boolean isPlatformKnown() {
            return this.platform() != null && !this.platform().isBlank();
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_(NBT_PLATFORM, this.platform());
            return nbt;
        }

        public void writeNbt(CompoundTag nbt) {
            nbt.m_128359_(NBT_PLATFORM, this.platform());
        }

        public static StationInfo fromNbt(CompoundTag nbt) {
            return new StationInfo(nbt.m_128461_(NBT_PLATFORM));
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj instanceof StationInfo) {
                StationInfo other = (StationInfo)obj;
                return this.platform().equals(other.platform());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.platform());
        }
    }

    public record ClientStationTag(String tagName, String stationName, StationInfo info, UUID tagId) {
        public static final String NBT_TAG_NAME = "TagName";
        public static final String NBT_STATION_NAME = "StationName";
        public static final String NBT_STATION_INFO = "StationInfo";
        public static final String NBT_TAG_ID = "Id";

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("TagName", this.tagName());
            nbt.m_128359_(NBT_STATION_NAME, this.stationName());
            nbt.m_128365_(NBT_STATION_INFO, (Tag)this.info().toNbt());
            nbt.m_128362_("Id", this.tagId() == null ? new UUID(0L, 0L) : this.tagId());
            return nbt;
        }

        public static ClientStationTag fromNbt(CompoundTag nbt) {
            return new ClientStationTag(nbt.m_128461_("TagName"), nbt.m_128461_(NBT_STATION_NAME), StationInfo.fromNbt(nbt.m_128469_(NBT_STATION_INFO)), nbt.m_128342_("Id"));
        }
    }
}

