/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.routedetails;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.TrainJourneySreen;
import de.mrjulsen.crn.client.gui.widgets.routedetails.RoutePartWidget;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.events.RouteDetailsActionsEvent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.gui.widgets.WidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.DLWidgetsCollection;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Single;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.io.Closeable;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RoutePartTrainDetailsWidget
extends WidgetContainer
implements Closeable {
    protected static final ResourceLocation GUI = new ResourceLocation("createrailwaysnavigator", "textures/gui/widgets.png");
    protected static final int GUI_TEXTURE_WIDTH = 256;
    protected static final int GUI_TEXTURE_HEIGHT = 256;
    protected static final int ENTRY_WIDTH = 225;
    protected static final int DEFAULT_HEIGHT = 28;
    protected static final int REASON_WIDTH = 132;
    protected static final int V = 92;
    private final ClientTrainStop stop;
    private final ClientRoutePart part;
    private Set<TrainStatus.CompiledTrainStatus> status = Set.of();
    public static final int ACTION_BTN_WIDTH = 140;
    public static final int ACTION_BTN_HEIGHT = 14;
    private int actionIndex;
    private int currentHeight;
    private final DLWidgetsCollection actionButtons = new DLWidgetsCollection();
    private final RoutePartWidget container;

    public RoutePartTrainDetailsWidget(Screen parent, RoutePartWidget container, ClientRoute route, ClientRoutePart part, ClientTrainStop firstStop, int pX, int pY, int width) {
        super(pX, pY, width, 28);
        this.stop = firstStop;
        this.part = part;
        this.container = container;
        part.listen("update", this, data -> {
            int oldHeight = this.currentHeight;
            this.currentHeight = 28;
            this.updateStatus();
            this.currentHeight += this.actionIndex * 15;
            int diff = this.currentHeight - oldHeight;
            this.actionButtons.performForEach(x -> x.set_y(x.y() + diff));
            this.set_height(this.currentHeight);
        });
        this.currentHeight = 28;
        this.updateStatus();
        this.addAction(new RoutePartWidget.RoutePartDetailsActionBuilder((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.title"), Sprite.empty(), b -> Minecraft.m_91087_().m_91152_((Screen)new TrainJourneySreen(parent, route, part.getTrainId()))));
        CRNEventsManager.getEventOptional(RouteDetailsActionsEvent.class).ifPresent(x -> x.run(route, part, container.isExpanded()).forEach(this::addAction));
        if (!part.getStopovers().isEmpty()) {
            this.addAction(new RoutePartWidget.RoutePartDetailsActionBuilder(container.isExpanded() ? Constants.TOOLTIP_COLLAPSE : Constants.TOOLTIP_EXPAND, (container.isExpanded() ? GuiIcons.ARROW_UP : GuiIcons.ARROW_DOWN).getAsSprite(16, 16), b -> container.setExpanded(!container.isExpanded())));
        }
        this.currentHeight += this.actionIndex * 15;
        this.set_height(this.currentHeight);
    }

    private void updateStatus() {
        this.status = this.part.getStatus();
        this.currentHeight += this.status.stream().mapToInt(x -> Math.max(9, (int)((float)ClientWrapper.getTextBlockHeight(this.font, x.text(), 176) * 0.75f) + 2)).sum() + 4;
    }

    public void addAction(RoutePartWidget.RoutePartDetailsActionBuilder builder) {
        DLIconButton btn2 = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, builder.icon(), this.x() + 76, this.y() + this.currentHeight + this.actionIndex * 15, 140, 14, builder.text(), builder.onClick()){

            public void m_94757_(double mouseX, double mouseY) {
                this.setFontColor(RoutePartTrainDetailsWidget.this.isInBounds(mouseX, mouseY) ? -96 : -1);
                super.m_94757_(mouseX, mouseY);
            }
        });
        btn2.setFontColor(-1);
        btn2.setBackColor(0);
        this.actionButtons.add((IDragonLibWidget)btn2);
        ++this.actionIndex;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.x(), (int)this.y(), (int)225, (int)28, (int)0, (int)92, (int)225, (int)28, (int)256, (int)256);
        this.renderData(graphics, this.y() + 1);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTick);
    }

    protected void renderData(Graphics graphics, int y) {
        float scale = 0.75f;
        float mul = 1.3333334f;
        float maxWidth = 140.0f;
        GuiUtils.drawTexture((ResourceLocation)Constants.GUI_WIDGETS, (Graphics)graphics, (int)this.x, (int)(y + 28 - 1), (int)225, (int)(this.height() - 28), (int)0, (int)120, (int)225, (int)1, (int)256, (int)256);
        this.stop.getTrainIcon().render(-1, graphics.graphics(), this.x + 80, y + 7);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        MutableComponent trainName = TextUtils.text((String)this.part.getLastStop().getTrainDisplayName()).m_130940_(ChatFormatting.BOLD);
        CreateDynamicWidgets.renderTextHighlighted(graphics, (int)((float)(this.x() + 80 + 24) / 0.75f), (int)((float)(y + 4) / 0.75f), this.font, (Component)trainName, this.part.getLastStop().getTrainDisplayColor());
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)(this.x() + 80 + 24) / 0.75f) + this.font.m_92852_((FormattedText)trainName) + 10), (int)((int)((float)(y + 6) / 0.75f)), (FormattedText)GuiUtils.ellipsisString((Font)this.font, (Component)TextUtils.text((String)String.format("%s (%s)", this.stop.getTrainName(), this.stop.getTrainId().toString().split("-")[0])), (int)((int)((140.0f - (float)this.font.m_92852_((FormattedText)trainName) - 15.0f) / 0.75f))), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)(this.x() + 80 + 24) / 0.75f)), (int)((int)((float)(y + 18) / 0.75f)), (FormattedText)GuiUtils.ellipsisString((Font)this.font, (Component)TextUtils.text((String)this.stop.getDisplayTitle()), (int)154), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85841_(1.3333334f, 1.3333334f, 1.3333334f);
        graphics.poseStack().m_85849_();
        int reasonsY = 0;
        for (TrainStatus.CompiledTrainStatus trainInformation : this.status) {
            reasonsY += trainInformation.render(graphics, (Single<Font>)Single.of((Object)this.font), this.x() + 76, this.y() + 28 + 2 + reasonsY, 132);
        }
    }

    public void set_height(int h) {
        super.set_height(h);
        this.container.updateHeight();
    }

    @Override
    public void close() {
        this.part.stopListeningAll(this);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    public static enum TrainStopType {
        START(48, 30, 8),
        TRANSIT(78, 21, 1),
        END(142, 44, 14);

        private int v;
        private int h;
        private int dy;

        private TrainStopType(int v, int h, int dy) {
            this.v = v;
            this.h = h;
            this.dy = dy;
        }

        public int getV() {
            return this.v;
        }

        public int getH() {
            return this.h;
        }

        public int getDy() {
            return this.dy;
        }
    }
}

